/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.event.TupleSetListener;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ExpressionParser;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ParseException;
import com.jidesoft.thirdparty.prefuse.data.tuple.AbstractTupleSet;
import com.jidesoft.thirdparty.prefuse.data.tuple.TupleSet;
import com.jidesoft.thirdparty.prefuse.util.collections.CompositeIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class CompositeTupleSet
extends AbstractTupleSet {
    private static final Logger s_logger = Logger.getLogger(CompositeTupleSet.class.getName());
    private Map m_map = new LinkedHashMap();
    private Set m_sets = new HashSet();
    private int m_count = 0;
    private Listener m_lstnr;

    public CompositeTupleSet() {
        this(true);
    }

    protected CompositeTupleSet(boolean bl) {
        this.m_lstnr = bl ? new Listener() : null;
    }

    public void addSet(String string, TupleSet tupleSet) {
        if (this.hasSet(string)) {
            throw new IllegalArgumentException("Name already in use: " + string);
        }
        this.m_map.put(string, tupleSet);
        this.m_sets.add(tupleSet);
        this.m_count += tupleSet.getTupleCount();
        if (this.m_lstnr != null) {
            tupleSet.addTupleSetListener(this.m_lstnr);
        }
    }

    public boolean hasSet(String string) {
        return this.m_map.containsKey(string);
    }

    public boolean containsSet(TupleSet tupleSet) {
        return this.m_sets.contains(tupleSet);
    }

    public TupleSet getSet(String string) {
        return (TupleSet)this.m_map.get(string);
    }

    public Iterator setNames() {
        return this.m_map.keySet().iterator();
    }

    public Iterator sets() {
        return this.m_map.values().iterator();
    }

    public TupleSet removeSet(String string) {
        TupleSet tupleSet = (TupleSet)this.m_map.remove(string);
        if (tupleSet != null) {
            this.m_sets.remove(tupleSet);
            if (this.m_lstnr != null) {
                tupleSet.removeTupleSetListener(this.m_lstnr);
            }
        }
        return tupleSet;
    }

    public void removeAllSets() {
        Iterator iterator = this.m_map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            iterator.remove();
            this.m_sets.remove(tupleSet);
            if (this.m_lstnr == null) continue;
            tupleSet.removeTupleSetListener(this.m_lstnr);
        }
        this.m_count = 0;
    }

    @Override
    public void clear() {
        for (Map.Entry entry : this.m_map.entrySet()) {
            ((TupleSet)entry.getValue()).clear();
        }
        this.m_count = 0;
    }

    @Override
    public Tuple addTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple setTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        Table table = tuple.getTable();
        if (this.m_sets.contains(table)) {
            return table.removeTuple(tuple);
        }
        return false;
    }

    @Override
    public boolean containsTuple(Tuple tuple) {
        Table table = tuple.getTable();
        return this.containsSet(table);
    }

    @Override
    public int getTupleCount() {
        if (this.m_lstnr != null) {
            return this.m_count;
        }
        int n2 = 0;
        Iterator iterator = this.m_map.entrySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            n2 += tupleSet.getTupleCount();
            ++n3;
        }
        return n2;
    }

    @Override
    public Iterator tuples() {
        CompositeIterator compositeIterator = new CompositeIterator(this.m_map.size());
        Iterator iterator = this.m_map.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            compositeIterator.setIterator(n2, tupleSet.tuples());
            ++n2;
        }
        return compositeIterator;
    }

    @Override
    public Iterator tuples(Predicate predicate) {
        CompositeIterator compositeIterator = new CompositeIterator(this.m_map.size());
        Iterator iterator = this.m_map.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            compositeIterator.setIterator(n2, tupleSet.tuples(predicate));
            ++n2;
        }
        return compositeIterator;
    }

    @Override
    public boolean isAddColumnSupported() {
        return true;
    }

    @Override
    public void addColumn(String string, Class clazz, Object object) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, clazz, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String string, Class clazz) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String string, Expression expression) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, expression);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String string, String string2) {
        Expression expression = null;
        try {
            expression = ExpressionParser.parse(string2);
            Throwable throwable = ExpressionParser.getError();
            if (throwable != null) {
                throw new RuntimeException(throwable);
            }
            this.addColumn(string, expression);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    private class Listener
    implements TupleSetListener {
        private Listener() {
        }

        @Override
        public void tupleSetChanged(TupleSet tupleSet, Tuple[] tupleArray, Tuple[] tupleArray2) {
            CompositeTupleSet.this.m_count += tupleArray.length - tupleArray2.length;
            CompositeTupleSet.this.fireTupleEvent(tupleArray, tupleArray2);
        }
    }
}

