/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.util;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIntTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;

public class RowManager {
    protected Table m_table;
    private IntIntSortedMap m_openrows;
    private int m_firstid = 0;
    private int m_curid = -1;

    public RowManager(Table table) {
        this.m_table = table;
    }

    public Table getTable() {
        return this.m_table;
    }

    public int getMinimumRow() {
        return this.m_firstid;
    }

    public int getMaximumRow() {
        return this.m_curid;
    }

    public int getRowCount() {
        return 1 + this.m_curid - this.m_firstid - (this.m_openrows == null ? 0 : this.m_openrows.size());
    }

    public boolean isValidRow(int n2) {
        return n2 >= this.m_firstid && n2 <= this.m_curid && (this.m_openrows == null || !this.m_openrows.containsKey(n2));
    }

    public void clear() {
        this.m_openrows = null;
        this.m_firstid = 0;
        this.m_curid = -1;
    }

    public int addRow() {
        int n2;
        if (this.m_openrows == null || this.m_openrows.isEmpty()) {
            n2 = this.m_firstid == 0 ? (this.m_curid = this.m_curid + 1) : (this.m_firstid = this.m_firstid - 1);
        } else {
            int n3 = this.m_openrows.firstKey();
            n2 = this.m_openrows.remove(n3);
        }
        return n2;
    }

    public boolean releaseRow(int n2) {
        if (n2 < 0) {
            return false;
        }
        if (this.m_openrows != null && this.m_openrows.containsKey(n2)) {
            return false;
        }
        if (n2 == this.m_curid) {
            --this.m_curid;
        } else if (n2 == this.m_firstid) {
            ++this.m_firstid;
        } else {
            if (this.m_openrows == null) {
                this.m_openrows = new IntIntTreeMap(false);
            }
            this.m_openrows.put(n2, n2);
        }
        return true;
    }

    public int getColumnRow(int n2, int n3) {
        return this.isValidRow(n2) ? n2 : -1;
    }

    public int getTableRow(int n2, int n3) {
        return this.isValidRow(n2) ? n2 : -1;
    }

    public IntIterator columnRows(int n2) {
        return new ColumnRowIterator(this.rows(), n2);
    }

    public IntIterator columnRows(int n2, boolean bl) {
        return new ColumnRowIterator(this.rows(bl), n2);
    }

    public IntIterator columnRows(IntIterator intIterator, int n2) {
        return new ColumnRowIterator(intIterator, n2);
    }

    public IntIterator rows() {
        return new RowIterator(false);
    }

    public IntIterator rows(boolean bl) {
        return new RowIterator(bl);
    }

    public class ColumnRowIterator
    extends IntIterator {
        private IntIterator rows;
        private int row;
        private int col;

        public ColumnRowIterator(IntIterator intIterator, int n2) {
            this.rows = intIterator;
            this.col = n2;
        }

        @Override
        public boolean hasNext() {
            return this.rows.hasNext();
        }

        @Override
        public int nextInt() {
            this.row = this.rows.nextInt();
            return RowManager.this.getColumnRow(this.row, this.col);
        }

        @Override
        public void remove() {
            RowManager.this.m_table.removeRow(this.row);
        }
    }

    public class RowIterator
    extends IntIterator {
        boolean reverse;
        int last = -1;
        int next;

        public RowIterator(boolean bl) {
            this.reverse = bl;
            this.next = this.advance(bl ? RowManager.this.m_curid : RowManager.this.m_firstid);
        }

        @Override
        public boolean hasNext() {
            return this.reverse ? this.next >= 0 : this.next <= RowManager.this.m_curid;
        }

        @Override
        public int nextInt() {
            this.last = this.next;
            this.next = this.advance(this.reverse ? (this.next = this.next - 1) : (this.next = this.next + 1));
            return this.last;
        }

        @Override
        public void remove() {
            RowManager.this.m_table.removeRow(this.last);
        }

        private final int advance(int n2) {
            if (RowManager.this.m_openrows == null) {
                return n2;
            }
            if (this.reverse) {
                while (n2 >= 0 && RowManager.this.m_openrows.containsKey(n2)) {
                    --n2;
                }
            } else {
                while (n2 <= RowManager.this.m_curid && RowManager.this.m_openrows.containsKey(n2)) {
                    ++n2;
                }
            }
            return n2;
        }
    }
}

