/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.util;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.event.ColumnListener;
import com.jidesoft.thirdparty.prefuse.data.event.TableListener;
import com.jidesoft.thirdparty.prefuse.data.util.Index;
import com.jidesoft.thirdparty.prefuse.data.util.RowManager;
import com.jidesoft.thirdparty.prefuse.util.collections.BooleanIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.DoubleIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.FloatIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IncompatibleComparatorException;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.IntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.LongIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.ObjectIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.SortedMapFactory;
import java.util.Comparator;

public class TreeIndex
implements Index,
ColumnListener,
TableListener {
    protected Table m_table;
    protected RowManager m_rows;
    protected Column m_col;
    protected IntSortedMap m_index;
    protected boolean m_reindex;
    protected int m_colidx;

    public TreeIndex(Table table, RowManager rowManager, Column column, Comparator comparator) throws IncompatibleComparatorException {
        this.m_table = table;
        this.m_rows = rowManager;
        this.m_col = column;
        this.m_index = SortedMapFactory.getMap(column.getColumnType(), comparator, false);
        this.index();
        this.m_col.addColumnListener(this);
        this.m_table.addTableListener(this);
    }

    @Override
    public void dispose() {
        this.m_col.removeColumnListener(this);
        this.m_table.removeTableListener(this);
    }

    @Override
    public Comparator getComparator() {
        return this.m_index.comparator();
    }

    @Override
    public int size() {
        return this.m_index.size();
    }

    private int getColumnIndex() {
        if (this.m_table.getColumn(this.m_colidx) != this.m_col) {
            this.m_colidx = this.m_table.getColumnNumber(this.m_col);
        }
        return this.m_colidx;
    }

    @Override
    public void index() {
        int n2;
        this.m_index.clear();
        this.m_colidx = n2 = this.getColumnIndex();
        IntIterator intIterator = this.m_rows.rows();
        if (this.m_index instanceof IntIntSortedMap) {
            IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n3 = intIterator.nextInt();
                intIntSortedMap.put(this.m_col.getInt(this.m_table.getColumnRow(n3, n2)), n3);
            }
        } else if (this.m_index instanceof LongIntSortedMap) {
            LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n4 = intIterator.nextInt();
                longIntSortedMap.put(this.m_col.getLong(this.m_table.getColumnRow(n4, n2)), n4);
            }
        } else if (this.m_index instanceof FloatIntSortedMap) {
            FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n5 = intIterator.nextInt();
                floatIntSortedMap.put(this.m_col.getFloat(this.m_table.getColumnRow(n5, n2)), n5);
            }
        } else if (this.m_index instanceof DoubleIntSortedMap) {
            DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n6 = intIterator.nextInt();
                doubleIntSortedMap.put(this.m_col.getDouble(this.m_table.getColumnRow(n6, n2)), n6);
            }
        } else if (this.m_index instanceof BooleanIntSortedMap) {
            BooleanIntSortedMap booleanIntSortedMap = (BooleanIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n7 = intIterator.nextInt();
                booleanIntSortedMap.put(this.m_col.getBoolean(this.m_table.getColumnRow(n7, n2)), n7);
            }
        } else if (this.m_index instanceof ObjectIntSortedMap) {
            ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n8 = intIterator.nextInt();
                objectIntSortedMap.put(this.m_col.get(this.m_table.getColumnRow(n8, n2)), n8);
            }
        } else {
            throw new IllegalStateException();
        }
        this.m_reindex = false;
    }

    @Override
    public void tableChanged(Table table, int n2, int n3, int n4, int n5) {
        if (n5 == 0 || table != this.m_table || n4 != -1) {
            return;
        }
        boolean bl = n5 == 1;
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.rowChanged(i2, bl);
        }
    }

    private void rowChanged(int n2, boolean bl) {
        int n3 = this.m_rows.getColumnRow(n2, this.getColumnIndex());
        if (this.m_index instanceof IntIntSortedMap) {
            IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
            int n4 = this.m_col.getInt(n2);
            if (bl) {
                intIntSortedMap.put(n4, n2);
            } else {
                intIntSortedMap.remove(n4, n2);
            }
        } else if (this.m_index instanceof LongIntSortedMap) {
            LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
            long l2 = this.m_col.getLong(n3);
            if (bl) {
                longIntSortedMap.put(l2, n2);
            } else {
                longIntSortedMap.remove(l2, n2);
            }
        } else if (this.m_index instanceof FloatIntSortedMap) {
            FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
            float f2 = this.m_col.getFloat(n3);
            if (bl) {
                floatIntSortedMap.put(f2, n2);
            } else {
                floatIntSortedMap.remove(f2, n2);
            }
        } else if (this.m_index instanceof DoubleIntSortedMap) {
            DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
            double d2 = this.m_col.getDouble(n3);
            if (bl) {
                doubleIntSortedMap.put(d2, n2);
            } else {
                doubleIntSortedMap.remove(d2, n2);
            }
        } else if (this.m_index instanceof BooleanIntSortedMap) {
            BooleanIntSortedMap booleanIntSortedMap = (BooleanIntSortedMap)this.m_index;
            boolean bl2 = this.m_col.getBoolean(n3);
            if (bl) {
                booleanIntSortedMap.put(bl2, n2);
            } else {
                booleanIntSortedMap.remove(bl2, n2);
            }
        } else if (this.m_index instanceof ObjectIntSortedMap) {
            ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
            Object object = this.m_col.get(n3);
            if (bl) {
                objectIntSortedMap.put(object, n2);
            } else {
                objectIntSortedMap.remove(object, n2);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void columnChanged(Column column, int n2, int n3, int n4) {
        this.m_reindex = true;
    }

    @Override
    public void columnChanged(Column column, int n2, boolean bl) {
        int n3 = this.m_rows.getTableRow(n2, this.getColumnIndex());
        if (n3 < 0) {
            return;
        }
        ((BooleanIntSortedMap)this.m_index).remove(bl, n3);
        ((BooleanIntSortedMap)this.m_index).put(column.getBoolean(n2), n3);
    }

    @Override
    public void columnChanged(Column column, int n2, int n3) {
        int n4 = this.m_rows.getTableRow(n2, this.getColumnIndex());
        if (n4 < 0) {
            return;
        }
        ((IntIntSortedMap)this.m_index).remove(n3, n4);
        ((IntIntSortedMap)this.m_index).put(column.getInt(n2), n4);
    }

    @Override
    public void columnChanged(Column column, int n2, long l2) {
        int n3 = this.m_rows.getTableRow(n2, this.getColumnIndex());
        if (n3 < 0) {
            return;
        }
        ((LongIntSortedMap)this.m_index).remove(l2, n3);
        ((LongIntSortedMap)this.m_index).put(column.getLong(n2), n3);
    }

    @Override
    public void columnChanged(Column column, int n2, float f2) {
        int n3 = this.m_rows.getTableRow(n2, this.getColumnIndex());
        if (n3 < 0) {
            return;
        }
        ((FloatIntSortedMap)this.m_index).remove(f2, n3);
        ((FloatIntSortedMap)this.m_index).put(column.getFloat(n2), n3);
    }

    @Override
    public void columnChanged(Column column, int n2, double d2) {
        int n3 = this.m_rows.getTableRow(n2, this.getColumnIndex());
        if (n3 < 0) {
            return;
        }
        ((DoubleIntSortedMap)this.m_index).remove(d2, n3);
        ((DoubleIntSortedMap)this.m_index).put(column.getDouble(n2), n3);
    }

    @Override
    public void columnChanged(Column column, int n2, Object object) {
        int n3 = this.m_rows.getTableRow(n2, this.getColumnIndex());
        if (n3 < 0) {
            return;
        }
        ((ObjectIntSortedMap)this.m_index).remove(object, n3);
        ((ObjectIntSortedMap)this.m_index).put(column.get(n2), n3);
    }

    @Override
    public int minimum() {
        return this.m_index.getMinimum();
    }

    @Override
    public int maximum() {
        return this.m_index.getMaximum();
    }

    @Override
    public int median() {
        return this.m_index.getMedian();
    }

    @Override
    public int uniqueCount() {
        return this.m_index.getUniqueCount();
    }

    @Override
    public IntIterator allRows(int n2) {
        boolean bl = (n2 & 0x20) > 0;
        return this.m_index.valueIterator(bl);
    }

    @Override
    public IntIterator rows(Object object, Object object2, int n2) {
        boolean bl;
        if (!(this.m_index instanceof ObjectIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl2 = (n2 & 0x10) > 0;
        boolean bl3 = (n2 & 8) > 0;
        boolean bl4 = bl = (n2 & 2) > 0;
        if (object == null) {
            object = ObjectIntSortedMap.MIN_KEY;
        }
        if (object2 == null) {
            object2 = ObjectIntSortedMap.MAX_KEY;
        }
        ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
        if (bl2) {
            return objectIntSortedMap.valueRangeIterator(object2, bl, object, bl3);
        }
        return objectIntSortedMap.valueRangeIterator(object, bl3, object2, bl);
    }

    @Override
    public IntIterator rows(int n2, int n3, int n4) {
        if (!(this.m_index instanceof IntIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n4 & 0x10) > 0;
        boolean bl2 = (n4 & 8) > 0;
        boolean bl3 = (n4 & 2) > 0;
        IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
        if (bl) {
            return intIntSortedMap.valueRangeIterator(n3, bl3, n2, bl2);
        }
        return intIntSortedMap.valueRangeIterator(n2, bl2, n3, bl3);
    }

    @Override
    public IntIterator rows(long l2, long l3, int n2) {
        if (!(this.m_index instanceof LongIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n2 & 0x10) > 0;
        boolean bl2 = (n2 & 8) > 0;
        boolean bl3 = (n2 & 2) > 0;
        LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
        if (bl) {
            return longIntSortedMap.valueRangeIterator(l3, bl3, l2, bl2);
        }
        return longIntSortedMap.valueRangeIterator(l2, bl2, l3, bl3);
    }

    @Override
    public IntIterator rows(float f2, float f3, int n2) {
        if (!(this.m_index instanceof FloatIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n2 & 0x10) > 0;
        boolean bl2 = (n2 & 8) > 0;
        boolean bl3 = (n2 & 2) > 0;
        FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
        if (bl) {
            return floatIntSortedMap.valueRangeIterator(f3, bl3, f2, bl2);
        }
        return floatIntSortedMap.valueRangeIterator(f2, bl2, f3, bl3);
    }

    @Override
    public IntIterator rows(double d2, double d3, int n2) {
        if (!(this.m_index instanceof DoubleIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n2 & 0x10) > 0;
        boolean bl2 = (n2 & 8) > 0;
        boolean bl3 = (n2 & 2) > 0;
        DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
        if (bl) {
            return doubleIntSortedMap.valueRangeIterator(d3, bl3, d2, bl2);
        }
        return doubleIntSortedMap.valueRangeIterator(d2, bl2, d3, bl3);
    }

    @Override
    public IntIterator rows(int n2) {
        return this.rows(n2, n2, 42);
    }

    @Override
    public IntIterator rows(long l2) {
        return this.rows(l2, l2, 42);
    }

    @Override
    public IntIterator rows(float f2) {
        return this.rows(f2, f2, 42);
    }

    @Override
    public IntIterator rows(double d2) {
        return this.rows(d2, d2, 42);
    }

    @Override
    public IntIterator rows(boolean bl) {
        if (!(this.m_index instanceof BooleanIntSortedMap)) {
            throw new IllegalStateException();
        }
        BooleanIntSortedMap booleanIntSortedMap = (BooleanIntSortedMap)this.m_index;
        return booleanIntSortedMap.valueRangeIterator(bl, true, bl, true);
    }

    @Override
    public IntIterator rows(Object object) {
        return this.rows(object, object, 42);
    }

    @Override
    public int get(double d2) {
        DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
        return doubleIntSortedMap.get(d2);
    }

    @Override
    public int get(float f2) {
        FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
        return floatIntSortedMap.get(f2);
    }

    @Override
    public int get(int n2) {
        IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
        return intIntSortedMap.get(n2);
    }

    @Override
    public int get(long l2) {
        LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
        return longIntSortedMap.get(l2);
    }

    @Override
    public int get(Object object) {
        ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
        return objectIntSortedMap.get(object);
    }
}

