/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.util.collections.AbstractTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.FloatIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralIterator;

public class FloatIntTreeMap
extends AbstractTreeMap
implements FloatIntSortedMap {
    private FloatEntry dummy = new FloatEntry(Float.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public FloatIntTreeMap() {
        this(null, false);
    }

    public FloatIntTreeMap(boolean bl) {
        this(null, bl);
    }

    public FloatIntTreeMap(LiteralComparator literalComparator) {
        this(literalComparator, false);
    }

    public FloatIntTreeMap(LiteralComparator literalComparator, boolean bl) {
        super(literalComparator, bl);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public boolean containsKey(float f2) {
        return this.find(f2, 0) != NIL;
    }

    @Override
    public int get(float f2) {
        AbstractTreeMap.Entry entry = this.find(f2, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.val;
    }

    @Override
    public int put(float f2, int n2) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new FloatEntry(f2, n2, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = f2;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int n3;
            if ((n3 = this.compare(this.dummy, entry)) == 0) {
                return entry.setValue(n2);
            }
            if (n3 < 0) {
                if (entry.left != NIL) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.left = new FloatEntry(f2, n2, entry, this.lastOrder);
                this.fixUpInsert(entry.left);
                return Integer.MIN_VALUE;
            }
            if (entry.right == NIL) break;
            entry = entry.right;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.right = new FloatEntry(f2, n2, entry, this.lastOrder);
        this.fixUpInsert(entry.right);
        return Integer.MIN_VALUE;
    }

    @Override
    public int remove(float f2) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.findPredecessor(f2, Integer.MAX_VALUE) : this.find(f2, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n2 = entry.val;
        this.remove(entry);
        return n2;
    }

    @Override
    public int remove(float f2, int n2) {
        AbstractTreeMap.Entry entry = this.findCeiling(f2, 0);
        if (entry != NIL && entry.getFloatKey() != f2) {
            entry = this.successor(entry);
        }
        if (entry == NIL || entry.getFloatKey() != f2) {
            return Integer.MIN_VALUE;
        }
        while (entry.val != n2 && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n2;
    }

    @Override
    public float firstKey() {
        return this.minimum(this.root).getFloatKey();
    }

    @Override
    public float lastKey() {
        return this.maximum(this.root).getFloatKey();
    }

    @Override
    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    @Override
    public LiteralIterator keyRangeIterator(float f2, boolean bl, float f3, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        if (this.cmp.compare(f2, f3) <= 0) {
            entry2 = this.findCeiling(f2, bl ? 0 : Integer.MAX_VALUE);
            entry = this.findCeiling(f3, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.findCeiling(f2, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.findCeiling(f3, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new KeyIterator(entry2, entry);
    }

    @Override
    public IntIterator valueRangeIterator(float f2, boolean bl, float f3, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(f2, bl, f3, bl2));
    }

    @Override
    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        int n2 = this.cmp.compare(entry.getFloatKey(), entry2.getFloatKey());
        if (this.allowDuplicates && n2 == 0) {
            n2 = entry.order < entry2.order ? -1 : (entry.order > entry2.order ? 1 : 0);
            this.lastOrder = 1 + (n2 < 0 ? entry.order : entry2.order);
        }
        return n2;
    }

    private AbstractTreeMap.Entry find(float f2, int n2) {
        this.dummy.key = f2;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.find(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findPredecessor(float f2, int n2) {
        this.dummy.key = f2;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findCeiling(float f2, int n2) {
        this.dummy.key = f2;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.findCeiling(this.dummy);
        return entry;
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
            super(entry, entry2);
        }

        @Override
        public boolean isFloatSupported() {
            return true;
        }

        @Override
        public float nextFloat() {
            return this.nextEntry().getFloatKey();
        }
    }

    static class FloatEntry
    extends AbstractTreeMap.Entry {
        float key;

        public FloatEntry(float f2, int n2) {
            super(n2);
            this.key = f2;
        }

        public FloatEntry(float f2, int n2, AbstractTreeMap.Entry entry, int n3) {
            super(n2, entry, n3);
            this.key = f2;
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public Object getKey() {
            return new Float(this.key);
        }

        @Override
        public boolean keyEquals(AbstractTreeMap.Entry entry) {
            return entry instanceof FloatEntry && this.key == ((FloatEntry)entry).key;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof FloatEntry)) {
                return false;
            }
            FloatEntry floatEntry = (FloatEntry)object;
            return this.key == floatEntry.key && this.val == floatEntry.val;
        }

        @Override
        public int hashCode() {
            int n2 = Float.floatToIntBits(this.key);
            int n3 = this.val;
            return n2 ^ n3 ^ this.order;
        }

        @Override
        public String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.key = entry.getFloatKey();
        }
    }
}

