/*
 * Decompiled with CFR 0.152.
 */
package com.nijikokun.register.payment;

import com.nijikokun.register.payment.Method;
import com.nijikokun.register.payment.methods.BOSE6;
import com.nijikokun.register.payment.methods.BOSE7;
import com.nijikokun.register.payment.methods.EE17;
import com.nijikokun.register.payment.methods.MCUR;
import com.nijikokun.register.payment.methods.iCo4;
import com.nijikokun.register.payment.methods.iCo5;
import com.nijikokun.register.payment.methods.iCo6;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Methods {
    private boolean self = false;
    private Method Method = null;
    private String preferred = "";
    private Set<Method> Methods = new HashSet<Method>();
    private Set<String> Dependencies = new HashSet<String>();
    private Set<Method> Attachables = new HashSet<Method>();

    public Methods() {
        this._init();
    }

    public Methods(String preferred) {
        this._init();
        if (this.Dependencies.contains(preferred)) {
            this.preferred = preferred;
        }
    }

    private void _init() {
        this.addMethod("iConomy", new iCo6());
        this.addMethod("iConomy", new iCo5());
        this.addMethod("iConomy", new iCo4());
        this.addMethod("BOSEconomy", new BOSE6());
        this.addMethod("BOSEconomy", new BOSE7());
        this.addMethod("Essentials", new EE17());
        this.addMethod("MultiCurrency", new MCUR());
    }

    public Set<String> getDependencies() {
        return this.Dependencies;
    }

    public Method createMethod(Plugin plugin) {
        for (Method method : this.Methods) {
            if (!method.isCompatible(plugin)) continue;
            method.setPlugin(plugin);
            return method;
        }
        return null;
    }

    private void addMethod(String name, Method method) {
        this.Dependencies.add(name);
        this.Methods.add(method);
    }

    public boolean hasMethod() {
        return this.Method != null;
    }

    public boolean setMethod(Plugin method) {
        if (this.hasMethod()) {
            return true;
        }
        if (this.self) {
            this.self = false;
            return false;
        }
        int count = 0;
        boolean match = false;
        Plugin plugin = null;
        PluginManager manager = method.getServer().getPluginManager();
        for (String name : this.getDependencies()) {
            Method current;
            if (this.hasMethod()) break;
            plugin = method.getDescription().getName().equals(name) ? method : manager.getPlugin(name);
            if (plugin == null || (current = this.createMethod(plugin)) == null) continue;
            if (this.preferred.isEmpty()) {
                this.Method = current;
                continue;
            }
            this.Attachables.add(current);
        }
        if (!this.preferred.isEmpty()) {
            do {
                if (this.hasMethod()) {
                    match = true;
                    continue;
                }
                for (Method attached : this.Attachables) {
                    if (attached == null) continue;
                    if (this.hasMethod()) {
                        match = true;
                        break;
                    }
                    if (this.preferred.isEmpty()) {
                        this.Method = attached;
                    }
                    if (count == 0) {
                        if (!this.preferred.equalsIgnoreCase(attached.getName())) continue;
                        this.Method = attached;
                        continue;
                    }
                    this.Method = attached;
                }
                ++count;
            } while (!match);
        }
        return this.hasMethod();
    }

    public Method getMethod() {
        return this.Method;
    }

    public boolean checkDisabled(Plugin method) {
        if (!this.hasMethod()) {
            return true;
        }
        if (this.Method.isCompatible(method)) {
            this.Method = null;
        }
        return this.Method == null;
    }
}

