/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.util.EntityUtil;
import com.sk89q.commandbook.util.ItemUtil;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@ComponentInformation(friendlyName="Fun", desc="Provides some fun commands to toy with users. (/rocket and /pong are two fun ones)")
public class FunComponent
extends BukkitComponent {
    private static final Random random = new Random();

    @Override
    public void enable() {
        this.registerCommands(Commands.class);
    }

    public LivingEntity spawn(Location loc, EntityType type, String specialType, CommandContext args, CommandSender sender) throws CommandException {
        Entity spawned = loc.getWorld().spawn(loc, type.getEntityClass());
        if (!(spawned instanceof LivingEntity)) {
            spawned.remove();
            throw new CommandException("Not a creature!");
        }
        LivingEntity creature = (LivingEntity)spawned;
        if (args.hasFlag('d')) {
            creature.setHealth(1);
        }
        if (args.hasFlag('i')) {
            creature.setFireTicks(500);
        }
        if (args.hasFlag('r')) {
            creature.setVelocity(new Vector(0, 2, 0));
        }
        if (args.hasFlag('b') && creature instanceof Ageable) {
            ((Ageable)creature).setBaby();
        }
        if (args.hasFlag('t') && creature instanceof Tameable && sender instanceof AnimalTamer) {
            ((Tameable)creature).setOwner((AnimalTamer)sender);
        }
        if (!specialType.equals("")) {
            if (creature instanceof Wolf) {
                if (specialType.contains("angry")) {
                    ((Wolf)creature).setAngry(true);
                }
                if (specialType.contains("sit(ting)?")) {
                    ((Wolf)creature).setSitting(true);
                }
                return creature;
            }
            if (creature instanceof Ocelot) {
                if (specialType.contains("black")) {
                    ((Ocelot)creature).setCatType(Ocelot.Type.BLACK_CAT);
                } else if (specialType.contains("red")) {
                    ((Ocelot)creature).setCatType(Ocelot.Type.RED_CAT);
                } else if (specialType.contains("siamese")) {
                    ((Ocelot)creature).setCatType(Ocelot.Type.SIAMESE_CAT);
                }
                return creature;
            }
            if (creature instanceof Creeper && specialType.matches("(power(ed)?|electric|lightning|shock(ed)?)")) {
                ((Creeper)creature).setPowered(true);
                return creature;
            }
            if (creature instanceof Sheep) {
                if (specialType.matches("shear(ed)?")) {
                    ((Sheep)creature).setSheared(true);
                    return creature;
                }
                ((Sheep)creature).setColor(ItemUtil.matchDyeColor(specialType));
                return creature;
            }
            if (creature instanceof Pig && specialType.matches("saddle(d)?")) {
                ((Pig)creature).setSaddle(true);
                return creature;
            }
            if (creature instanceof Slime) {
                ((Slime)creature).setSize(Integer.parseInt(specialType));
                return creature;
            }
            if (creature instanceof Skeleton) {
                if (specialType.matches("wither")) {
                    ((Skeleton)creature).setSkeletonType(Skeleton.SkeletonType.WITHER);
                    return creature;
                }
            } else {
                if (creature instanceof PigZombie) {
                    if (specialType.matches("angry")) {
                        ((PigZombie)creature).setAngry(true);
                        return creature;
                    }
                    ((PigZombie)creature).setAnger(Integer.parseInt(specialType));
                    return creature;
                }
                if (creature instanceof Enderman) {
                    ItemStack item = CommandBook.inst().getItem(specialType);
                    if (item == null) {
                        return creature;
                    }
                    ((Enderman)creature).setCarriedMaterial(item.getData());
                    return creature;
                }
                if (creature instanceof IronGolem && specialType.matches("(friendly|player(-created)?)")) {
                    ((IronGolem)creature).setPlayerCreated(true);
                } else if (creature instanceof Villager) {
                    Villager.Profession profession;
                    try {
                        profession = Villager.Profession.valueOf((String)specialType.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new CommandException("Unknown profession '" + specialType + "'");
                    }
                    if (profession != null) {
                        ((Villager)creature).setProfession(profession);
                    }
                }
            }
        }
        return creature;
    }

    public class Commands {
        @Command(aliases={"ping"}, usage="", desc="A dummy command", flags="", min=0, max=0)
        public void ping(CommandContext args, CommandSender sender) throws CommandException {
            sender.sendMessage(ChatColor.YELLOW + "Pong!");
        }

        @Command(aliases={"pong"}, usage="", desc="A dummy command", flags="", min=0, max=0)
        @CommandPermissions(value={"commandbook.pong"})
        public void pong(CommandContext args, CommandSender sender) throws CommandException {
            sender.sendMessage(ChatColor.YELLOW + "I hear " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " likes cute Asian boys.");
        }

        @Command(aliases={"spawnmob"}, usage="<mob>[|rider] [count] [location]", desc="Spawn a mob", flags="dirbt", min=1, max=4)
        @CommandPermissions(value={"commandbook.spawnmob"})
        public void spawnMob(CommandContext args, CommandSender sender) throws CommandException {
            String creatureName;
            String[] nameParts;
            Location loc = args.argsLength() >= 3 ? LocationUtil.matchLocation(sender, args.getString(2)) : PlayerUtil.checkPlayer(sender).getLocation();
            String[] creatureInput = args.getString(0).split("\\|");
            boolean hasRider = creatureInput.length == 2;
            String riderName = "";
            String specialType = "";
            String riderSpecialType = "";
            if (creatureInput[0].contains(":")) {
                nameParts = creatureInput[0].split(":", 2);
                creatureName = nameParts[0];
                specialType = nameParts[1].toLowerCase();
            } else {
                creatureName = creatureInput[0];
            }
            if (hasRider) {
                if (creatureInput[1].contains(":")) {
                    nameParts = creatureInput[1].split(":", 2);
                    riderName = nameParts[0];
                    riderSpecialType = nameParts[1].toLowerCase();
                } else {
                    riderName = creatureInput[1];
                }
            }
            int count = Math.max(1, args.getInteger(1, 1));
            EntityType type = EntityUtil.matchCreatureType(sender, creatureName, true);
            EntityType riderType = null;
            if (hasRider) {
                riderType = EntityUtil.matchCreatureType(sender, riderName, true);
                CommandBook.inst().checkPermission(sender, "commandbook.spawnmob." + riderType.getName());
            }
            CommandBook.inst().checkPermission(sender, "commandbook.spawnmob." + type.getName());
            if ((hasRider ? count * 2 : count) > 10) {
                CommandBook.inst().checkPermission(sender, "commandbook.spawnmob.many");
            }
            for (int i = 0; i < count; ++i) {
                LivingEntity ridee = FunComponent.this.spawn(loc, type, specialType, args, sender);
                if (!hasRider) continue;
                LivingEntity rider = FunComponent.this.spawn(loc, riderType, riderSpecialType, args, sender);
                ridee.setPassenger((Entity)rider);
            }
            sender.sendMessage(ChatColor.YELLOW + "" + count + " mob(s) spawned!");
        }

        @Command(aliases={"slap"}, usage="[target]", desc="Slap a player", flags="hdvs", min=0, max=1)
        @CommandPermissions(value={"commandbook.slap"})
        public void slap(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.slap.other");
                break;
            }
            for (Player player : targets) {
                ++count;
                if (args.hasFlag('v')) {
                    player.setVelocity(new Vector(random.nextDouble() * 10.0 - 5.0, random.nextDouble() * 10.0, random.nextDouble() * 10.0 - 5.0));
                } else if (args.hasFlag('h')) {
                    player.setVelocity(new Vector(random.nextDouble() * 5.0 - 2.5, random.nextDouble() * 5.0, random.nextDouble() * 5.0 - 2.5));
                } else {
                    player.setVelocity(new Vector(random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 1.0, random.nextDouble() * 2.0 - 1.0));
                }
                if (args.hasFlag('d')) {
                    player.setHealth(Math.max(0, player.getHealth() - 1));
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Slapped!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "You've been slapped by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " slapped " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " slapped more people...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players slapped.");
            }
        }

        @Command(aliases={"rocket"}, usage="[target]", desc="Rocket a player", flags="hs", min=0, max=1)
        @CommandPermissions(value={"commandbook.rocket"})
        public void rocket(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.rocket.other");
                break;
            }
            for (Player player : targets) {
                if (args.hasFlag('h')) {
                    player.setVelocity(new Vector(0, 4, 0));
                } else {
                    player.setVelocity(new Vector(0, 2, 0));
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Rocketed!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "You've been rocketed by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (++count < 6) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " rocketed " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " rocketed more people...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players rocketed.");
            }
        }

        @Command(aliases={"barrage"}, usage="[target]", desc="Send a barrage of arrows", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.barrage"})
        public void barrage(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.barrage.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.barrage");
            }
            for (Player player : targets) {
                double diff = 0.2617993877991494;
                for (double a = 0.0; a < Math.PI * 2; a += diff) {
                    Vector vel = new Vector(Math.cos(a), 0.0, Math.sin(a));
                    CommandBookUtil.sendArrowFromPlayer(player, vel, 2.0f);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Barrage attack!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "BARRAGE attack from " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " used BARRAGE on " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " used it on more people...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Barrage attack sent.");
            }
        }

        @Command(aliases={"firebarrage"}, usage="[target]", desc="Send a attack of fireballs", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.firebarrage"})
        public void barragefire(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.firebarrage.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.firebarrage");
            }
            for (Player player : targets) {
                CommandBookUtil.sendFireballsFromPlayer(player, 8);
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Fireball attack!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "Fireball attack from " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " used Fireball attack on " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " used it on more people...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Fireball attack sent.");
            }
        }

        @Command(aliases={"cannon"}, usage="[target]", desc="Send a ball of fire to a face", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.cannon"})
        public void cannon(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.cannon.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.cannon");
            }
            for (Player player : targets) {
                double diff = 0.2617993877991494;
                for (double a = 0.0; a < Math.PI * 2; a += diff) {
                    CommandBookUtil.sendCannonToPlayer(player);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Fireball attack!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "Fireball attack from " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " used Fireball attack on " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                BasePlugin.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " used it more people...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Fireball attack sent.");
            }
        }
    }
}

