/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.kits;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Kit {
    private volatile long coolDown;
    private final LinkedList<ItemStack> items = new LinkedList();
    private final Map<String, Long> lastDistribution = new HashMap<String, Long>();

    public long getCoolDown() {
        return this.coolDown;
    }

    public void setCoolDown(long coolDown) {
        this.coolDown = coolDown;
    }

    public void addItem(ItemStack item) {
        this.items.add(item);
    }

    public synchronized boolean distribute(Player player) {
        if (this.coolDown > 0L) {
            Long time = this.lastDistribution.get(player.getName());
            long now = System.currentTimeMillis();
            if (time != null && now - time < this.coolDown) {
                return false;
            }
            this.lastDistribution.put(player.getName(), now);
        }
        for (ItemStack item : this.items) {
            player.getInventory().addItem(new ItemStack[]{item.clone()});
        }
        return true;
    }

    public synchronized void flush() {
        long now = System.currentTimeMillis();
        Iterator<Long> it = this.lastDistribution.values().iterator();
        try {
            while (it.hasNext()) {
                if (now - it.next() <= this.coolDown) continue;
                it.remove();
            }
        }
        catch (NoSuchElementException ignore) {
            // empty catch block
        }
    }
}

