/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.kits;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.kits.FlatFileKitsManager;
import com.sk89q.commandbook.kits.GarbageCollector;
import com.sk89q.commandbook.kits.Kit;
import com.sk89q.commandbook.kits.KitManager;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.io.File;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Kits", desc="Distributes kits to players on command (with cooldowns)")
public class KitsComponent
extends BukkitComponent {
    private KitManager kits;

    @Override
    public void enable() {
        CommandBook.inst().createDefaultConfiguration("kits.txt");
        this.kits = new FlatFileKitsManager(new File(CommandBook.inst().getDataFolder(), "kits.txt"));
        this.kits.load();
        CommandBook.server().getScheduler().scheduleAsyncRepeatingTask((Plugin)CommandBook.inst(), (Runnable)new GarbageCollector(this), 12000L, 12000L);
        this.registerCommands(Commands.class);
    }

    @Override
    public void reload() {
        super.reload();
        this.kits.load();
    }

    public KitManager getKitManager() {
        return this.kits;
    }

    public class Commands {
        @Command(aliases={"kit"}, usage="<id> [target]", desc="Get a kit", flags="", min=0, max=2)
        public void kit(CommandContext args, CommandSender sender) throws CommandException {
            if (args.argsLength() == 0) {
                CommandBook.inst().checkPermission(sender, "commandbook.kit.list");
                Map<String, Kit> kits = KitsComponent.this.getKitManager().getKits();
                if (kits.size() == 0) {
                    throw new CommandException("No kits are configured.");
                }
                StringBuilder str = new StringBuilder();
                int count = 0;
                for (String id : kits.keySet()) {
                    if (!CommandBook.inst().hasPermission(sender, "commandbook.kit.kits." + id.replace(".", ""))) continue;
                    if (str.length() != 0) {
                        str.append(", ");
                    }
                    str.append(id);
                    ++count;
                }
                if (count == 0) {
                    throw new CommandException("You have access to no kits.");
                }
                sender.sendMessage(ChatColor.YELLOW + "Kits (" + count + "): " + ChatColor.WHITE + str.toString());
                sender.sendMessage(ChatColor.YELLOW + "Use /kit kitname to get a kit.");
            } else {
                String id = args.getString(0).toLowerCase();
                boolean included = false;
                Iterable<Player> targets = args.argsLength() == 2 ? PlayerUtil.matchPlayers(sender, args.getString(1)) : PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
                for (Player player : targets) {
                    if (player == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.kit.other");
                }
                Kit kit = KitsComponent.this.getKitManager().getKit(id);
                if (kit == null) {
                    throw new CommandException("No kit by that name exists.");
                }
                CommandBook.inst().checkPermission(sender, "commandbook.kit.kits." + id.replace(".", ""));
                for (Player player : targets) {
                    boolean success = kit.distribute(player);
                    if (player.equals(sender)) {
                        if (success) {
                            player.sendMessage(ChatColor.YELLOW + "Kit '" + id + "' given!");
                        } else {
                            player.sendMessage(ChatColor.RED + "You have to wait before you can get this kit again.");
                        }
                        included = true;
                        continue;
                    }
                    if (success) {
                        player.sendMessage(ChatColor.YELLOW + "You've been given " + "the '" + id + "' kit by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                        continue;
                    }
                    player.sendMessage(ChatColor.RED + "A kit could not be given to you because it has been too soon.");
                }
                if (!included) {
                    sender.sendMessage(ChatColor.YELLOW + "Kits given.");
                }
            }
        }
    }
}

