/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.minecraft.util.commands.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class EntityUtil {
    public static EntityType matchCreatureType(CommandSender sender, String filter, boolean requireSpawnable) throws CommandException {
        EntityType partialMatch = null;
        for (EntityType type : EntityType.values()) {
            Class clazz = type.getEntityClass();
            if (clazz == null || !LivingEntity.class.isAssignableFrom(clazz) || requireSpawnable && !type.isSpawnable()) continue;
            if (type.name().replace("_", "").equalsIgnoreCase(filter.replace("_", ""))) {
                return type;
            }
            if (type.getName() != null) {
                if (type.getName().equalsIgnoreCase(filter)) {
                    return type;
                }
                if (type.getName().toLowerCase().startsWith(filter.toLowerCase())) {
                    partialMatch = type;
                }
            }
            if (!type.name().replace("_", "").equalsIgnoreCase(filter.replace("_", "")) && (type.getName() == null || !type.getName().equalsIgnoreCase(filter) || !type.isSpawnable() && requireSpawnable)) continue;
            return type;
        }
        if (partialMatch != null) {
            return partialMatch;
        }
        throw new CommandException("Unknown mob specified! You can choose from the list of: " + EntityUtil.getCreatureNameList(requireSpawnable));
    }

    public static String getCreatureNameList(boolean requireSpawnable) {
        StringBuilder str = new StringBuilder();
        for (EntityType type : EntityType.values()) {
            Class entityClass = type.getEntityClass();
            if (entityClass == null || !LivingEntity.class.isAssignableFrom(entityClass) || requireSpawnable && !type.isSpawnable()) continue;
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(type.getName());
        }
        return str.toString();
    }
}

