/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.entity.EntityUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.commandbook.util.item.ItemUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@ComponentInformation(friendlyName="Fun", desc="Provides some fun commands to toy with users. (/rocket and /pong are two fun ones)")
public class FunComponent
extends BukkitComponent {
    private static final Random random = new Random();

    @Override
    public void enable() {
        this.registerCommands(Commands.class);
    }

    private static <T extends Enum<T>> String valueList(Class<T> clazz) {
        StringBuilder res = new StringBuilder();
        boolean first = true;
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!first) {
                res.append(", ");
            }
            res.append(e.toString());
            first = false;
        }
        return res.toString();
    }

    public LivingEntity spawn(Location loc, EntityType type, String specialTypes, CommandContext args, CommandSender sender) throws CommandException {
        Entity spawned = loc.getWorld().spawn(loc, type.getEntityClass());
        if (!(spawned instanceof LivingEntity)) {
            spawned.remove();
            throw new CommandException("Not a creature!");
        }
        LivingEntity creature = (LivingEntity)spawned;
        if (args.hasFlag('d')) {
            creature.setHealth(1.0);
        }
        if (args.hasFlag('i')) {
            creature.setFireTicks(500);
        }
        if (args.hasFlag('r')) {
            creature.setVelocity(new Vector(0, 2, 0));
        }
        if (args.hasFlag('b')) {
            if (creature instanceof Ageable) {
                ((Ageable)creature).setBaby();
            } else if (creature instanceof Zombie) {
                ((Zombie)creature).setBaby(true);
            }
        }
        if (args.hasFlag('p')) {
            creature.setCanPickupItems(true);
        }
        if (args.hasFlag('t') && creature instanceof Tameable) {
            if (sender instanceof AnimalTamer) {
                ((Tameable)creature).setOwner((AnimalTamer)sender);
            } else {
                ((Tameable)creature).setTamed(true);
            }
        }
        if (creature instanceof Skeleton) {
            creature.getEquipment().setItemInHand(new ItemStack(Material.BOW));
        } else if (creature instanceof PigZombie) {
            creature.getEquipment().setItemInHand(new ItemStack(Material.GOLD_SWORD));
        }
        String[] types = specialTypes.split(",");
        if (!specialTypes.isEmpty() && types.length > 0) {
            block25: for (String specialType : types) {
                switch (creature.getType()) {
                    case WOLF: {
                        if (specialType.matches("(?i)angry")) {
                            ((Wolf)creature).setAngry(true);
                            continue block25;
                        }
                        if (!specialType.matches("(?i)sit(ting)?")) continue block25;
                        ((Wolf)creature).setSitting(true);
                        continue block25;
                    }
                    case OCELOT: {
                        Ocelot.Type catType;
                        try {
                            catType = Ocelot.Type.valueOf((String)specialType.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            throw new CommandException("Unknown cat type '" + specialType + "'. Allowed values are: " + FunComponent.valueList(Ocelot.Type.class));
                        }
                        if (catType == null) break block25;
                        ((Ocelot)creature).setCatType(catType);
                        break block25;
                    }
                    case CREEPER: {
                        if (!specialType.matches("(?i)(power(ed)?|electric|lightning|shock(ed)?)")) break block25;
                        ((Creeper)creature).setPowered(true);
                        break block25;
                    }
                    case SHEEP: {
                        if (specialType.matches("(?i)shear(ed)?")) {
                            ((Sheep)creature).setSheared(true);
                            continue block25;
                        }
                        ((Sheep)creature).setColor(ItemUtil.matchDyeColor(specialType));
                        continue block25;
                    }
                    case PIG: {
                        if (!specialType.matches("(?i)saddle(d)?")) break block25;
                        ((Pig)creature).setSaddle(true);
                        break block25;
                    }
                    case SLIME: {
                        ((Slime)creature).setSize(Integer.parseInt(specialType));
                        break block25;
                    }
                    case SKELETON: {
                        if (!specialType.matches("(?i)wither")) break block25;
                        ((Skeleton)creature).setSkeletonType(Skeleton.SkeletonType.WITHER);
                        break block25;
                    }
                    case PIG_ZOMBIE: {
                        if (specialType.matches("(?i)angry")) {
                            ((PigZombie)creature).setAngry(true);
                            return creature;
                        }
                        ((PigZombie)creature).setAnger(Integer.parseInt(specialType));
                        break block25;
                    }
                    case ZOMBIE: {
                        if (!specialType.matches("(?i)villager")) continue block25;
                        ((Zombie)creature).setVillager(true);
                        continue block25;
                    }
                    case ENDERMAN: {
                        ItemStack item = ItemUtil.getItem(specialType);
                        if (item == null) {
                            return creature;
                        }
                        ((Enderman)creature).setCarriedMaterial(item.getData());
                        break block25;
                    }
                    case IRON_GOLEM: {
                        if (!specialType.matches("(?i)(friendly|player(-created)?)")) break block25;
                        ((IronGolem)creature).setPlayerCreated(true);
                        break block25;
                    }
                    case VILLAGER: {
                        Villager.Profession profession;
                        try {
                            profession = Villager.Profession.valueOf((String)specialType.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            throw new CommandException("Unknown profession '" + specialType + "'. Allowed values are: " + FunComponent.valueList(Villager.Profession.class));
                        }
                        if (profession == null) break block25;
                        ((Villager)creature).setProfession(profession);
                        break block25;
                    }
                    case HORSE: {
                        Horse.Color color = null;
                        Horse.Style style = null;
                        Horse.Variant variant = null;
                        try {
                            color = Horse.Color.valueOf((String)specialType.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        if (color != null) {
                            ((Horse)creature).setColor(color);
                            continue block25;
                        }
                        try {
                            style = Horse.Style.valueOf((String)specialType.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        if (style != null) {
                            ((Horse)creature).setStyle(style);
                            continue block25;
                        }
                        try {
                            variant = Horse.Variant.valueOf((String)specialType.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        if (variant != null) {
                            ((Horse)creature).setVariant(variant);
                            continue block25;
                        }
                        throw new CommandException("Unknown color, style, or variant '" + specialType + "'.");
                    }
                }
            }
        }
        return creature;
    }

    public class Commands {
        @Command(aliases={"ping"}, usage="", desc="A dummy command", flags="", min=0, max=0)
        public void ping(CommandContext args, CommandSender sender) throws CommandException {
            sender.sendMessage(ChatColor.YELLOW + "Pong!");
        }

        @Command(aliases={"pong"}, usage="", desc="A dummy command", flags="", min=0, max=0)
        @CommandPermissions(value={"commandbook.pong"})
        public void pong(CommandContext args, CommandSender sender) throws CommandException {
            sender.sendMessage(ChatColor.YELLOW + "I hear " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " likes cute Asian boys.");
        }

        @Command(aliases={"spawnmob"}, usage="<mob>[|rider] [count] [location]", desc="Spawn a mob", flags="dirbt", min=1, max=4)
        @CommandPermissions(value={"commandbook.spawnmob"})
        public void spawnMob(CommandContext args, CommandSender sender) throws CommandException {
            String creatureName;
            String[] nameParts;
            ArrayList locations = args.argsLength() >= 3 ? InputUtil.LocationParser.matchLocations(sender, args.getString(2)) : Lists.newArrayList((Object[])new Location[]{PlayerUtil.checkPlayer(sender).getLocation()});
            String[] creatureInput = args.getString(0).split("\\|");
            boolean hasRider = creatureInput.length == 2;
            String riderName = "";
            String specialType = "";
            String riderSpecialType = "";
            if (creatureInput[0].contains(":")) {
                nameParts = creatureInput[0].split(":", 2);
                creatureName = nameParts[0];
                specialType = nameParts[1].toLowerCase();
            } else {
                creatureName = creatureInput[0];
            }
            if (hasRider) {
                if (creatureInput[1].contains(":")) {
                    nameParts = creatureInput[1].split(":", 2);
                    riderName = nameParts[0];
                    riderSpecialType = nameParts[1].toLowerCase();
                } else {
                    riderName = creatureInput[1];
                }
            }
            int count = Math.max(1, args.getInteger(1, 1));
            int total = count * locations.size();
            EntityType type = EntityUtil.matchCreatureType(sender, creatureName, true);
            EntityType riderType = null;
            if (hasRider) {
                riderType = EntityUtil.matchCreatureType(sender, riderName, true);
                CommandBook.inst().checkPermission(sender, "commandbook.spawnmob." + riderType.getName());
            }
            CommandBook.inst().checkPermission(sender, "commandbook.spawnmob." + type.getName());
            if ((hasRider ? total * 2 : total) > 10) {
                CommandBook.inst().checkPermission(sender, "commandbook.spawnmob.many");
            }
            for (Location loc : locations) {
                for (int i = 0; i < count; ++i) {
                    LivingEntity ridee = FunComponent.this.spawn(loc, type, specialType, args, sender);
                    if (!hasRider) continue;
                    LivingEntity rider = FunComponent.this.spawn(loc, riderType, riderSpecialType, args, sender);
                    ridee.setPassenger((Entity)rider);
                }
            }
            sender.sendMessage(ChatColor.YELLOW + "" + total + " mob(s) spawned!");
        }

        @Command(aliases={"slap"}, usage="[target]", desc="Slap a player", flags="hdvs", min=0, max=1)
        @CommandPermissions(value={"commandbook.slap"})
        public void slap(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.slap.other");
                break;
            }
            for (Player player : targets) {
                if (args.hasFlag('v')) {
                    player.setVelocity(new Vector(random.nextDouble() * 10.0 - 5.0, random.nextDouble() * 10.0, random.nextDouble() * 10.0 - 5.0));
                } else if (args.hasFlag('h')) {
                    player.setVelocity(new Vector(random.nextDouble() * 5.0 - 2.5, random.nextDouble() * 5.0, random.nextDouble() * 5.0 - 2.5));
                } else {
                    player.setVelocity(new Vector(random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 1.0, random.nextDouble() * 2.0 - 1.0));
                }
                if (args.hasFlag('d')) {
                    player.setHealth(Math.max(0.0, player.getHealth() - 1.0));
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Slapped!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "You've been slapped by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " slapped " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                } else if (count == 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " slapped more people...");
                }
                ++count;
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players slapped.");
            }
        }

        @Command(aliases={"rocket"}, usage="[target]", desc="Rocket a player", flags="hs", min=0, max=1)
        @CommandPermissions(value={"commandbook.rocket"})
        public void rocket(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.rocket.other");
                break;
            }
            for (Player player : targets) {
                if (args.hasFlag('h')) {
                    player.setVelocity(new Vector(0, 4, 0));
                } else {
                    player.setVelocity(new Vector(0, 2, 0));
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Rocketed!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "You've been rocketed by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " rocketed " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                } else if (count == 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " rocketed more people...");
                }
                ++count;
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players rocketed.");
            }
        }

        @Command(aliases={"barrage"}, usage="[target]", desc="Send a barrage of arrows", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.barrage"})
        public void barrage(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.barrage.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.barrage");
            }
            for (Player player : targets) {
                EntityUtil.sendProjectilesFromEntity((LivingEntity)player, 24, 2.0f, Arrow.class);
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Barrage attack!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "BARRAGE attack from " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " used BARRAGE on " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                } else if (count == 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " used it on more people...");
                }
                ++count;
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Barrage attack sent.");
            }
        }

        @Command(aliases={"firebarrage"}, usage="[target]", desc="Send a attack of fireballs", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.firebarrage"})
        public void barragefire(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.firebarrage.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.firebarrage");
            }
            for (Player player : targets) {
                EntityUtil.sendProjectilesFromEntity((LivingEntity)player, 8, 10.0f, Fireball.class);
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Fireball attack!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "Fireball attack from " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " used Fireball attack on " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                } else if (count == 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " used it on more people...");
                }
                ++count;
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Fireball attack sent.");
            }
        }

        @Command(aliases={"cannon"}, usage="[target]", desc="Send a ball of fire to a face", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.cannon"})
        public void cannon(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.cannon.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.cannon");
            }
            for (Player player : targets) {
                double diff = 0.2617993877991494;
                for (double a = 0.0; a < Math.PI * 2; a += diff) {
                    player.getWorld().spawnEntity(player.getEyeLocation(), EntityType.FIREBALL);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Fireball attack!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "Fireball attack from " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " used Fireball attack on " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                } else if (count == 3) {
                    BasePlugin.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " used it more people...");
                }
                ++count;
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Fireball attack sent.");
            }
        }
    }
}

