/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util.entity;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Projectile;
import org.bukkit.util.Vector;

public class ProjectileUtil {
    public static <T extends Projectile> T sendProjectileFromLocation(Location loc, Vector dir, float speed, Class<T> clazz) {
        loc = loc.clone();
        Vector actualDir = dir.clone().normalize();
        Vector finalVecLoc = loc.toVector().add(actualDir.multiply(2));
        loc.setX(finalVecLoc.getX());
        loc.setY(finalVecLoc.getY());
        loc.setZ(finalVecLoc.getZ());
        Projectile projectile = (Projectile)loc.getWorld().spawn(loc, clazz);
        if (projectile instanceof Fireball) {
            ((Fireball)projectile).setDirection(dir.multiply(speed));
        } else {
            projectile.setVelocity(dir.multiply(speed));
        }
        return (T)projectile;
    }

    public static <T extends Projectile> Set<T> sendProjectilesFromLocation(Location loc, int amt, float speed, Class<T> clazz) {
        double tau = Math.PI * 2;
        double arc = Math.PI * 2 / (double)amt;
        HashSet<T> resultSet = new HashSet<T>();
        for (double a = 0.0; a < Math.PI * 2; a += arc) {
            resultSet.add(ProjectileUtil.sendProjectileFromLocation(loc, new Vector(Math.cos(a), 0.0, Math.sin(a)), speed, clazz));
        }
        return resultSet;
    }
}

