/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util.item;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.InventoryComponent;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.item.ItemUtil;
import com.sk89q.minecraft.util.commands.CommandException;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InventoryUtil {
    public static void giveItem(CommandSender sender, ItemStack item, int amt, Collection<Player> targets, InventoryComponent component, boolean drop, boolean overrideStackSize) throws CommandException {
        boolean infinite = false;
        int maxStackSize = overrideStackSize ? 64 : item.getType().getMaxStackSize();
        component.checkAllowedItem(sender, item.getTypeId(), item.getDurability());
        if (amt == 0 || amt < -1) {
            throw new CommandException("Invalid item amount!");
        }
        if (amt == -1) {
            CommandBook.inst().checkPermission(sender, "commandbook.give.infinite");
            infinite = true;
        } else if (overrideStackSize) {
            CommandBook.inst().checkPermission(sender, "commandbook.override.maxstacksize");
        } else if (amt > maxStackSize * 5) {
            if (!CommandBook.inst().hasPermission(sender, "commandbook.give.stacks.unlimited")) {
                throw new CommandException("More than 5 stacks is too excessive.");
            }
        } else if (amt > maxStackSize) {
            CommandBook.inst().checkPermission(sender, "commandbook.give.stacks");
        }
        int targetQuantity = targets.size();
        if (targetQuantity > 1 || !targets.contains(sender)) {
            sender.sendMessage(ChatColor.YELLOW.toString() + targetQuantity + " player(s)" + " have been given " + InventoryUtil.getAmountText(false, infinite, amt) + ' ' + ItemUtil.toItemName(item.getTypeId()) + '.');
        }
        for (Player player : targets) {
            int left = amt;
            while (left > 0 || infinite) {
                int givenAmt = Math.min(maxStackSize, left);
                item = item.clone();
                item.setAmount(givenAmt);
                left -= givenAmt;
                if (drop) {
                    player.getWorld().dropItemNaturally(player.getLocation(), item);
                } else {
                    Collection result = player.getInventory().addItem(new ItemStack[]{item}).values();
                    if (!result.isEmpty()) {
                        for (ItemStack stack : result) {
                            sender.sendMessage(ChatColor.RED + InventoryUtil.getAmountText(true, infinite, left += stack.getAmount()) + ' ' + ItemUtil.toItemName(stack.getTypeId()) + " could not be given to " + player.getName() + " (their inventory is probably full)!");
                        }
                        break;
                    }
                }
                if (amt != -1) continue;
                break;
            }
            player.updateInventory();
            String amtString = InventoryUtil.getAmountText(false, infinite, amt - left);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "You've been given " + amtString + " " + ItemUtil.toItemName(item.getTypeId()) + ".");
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "Given from " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ": " + amtString + " " + ItemUtil.toItemName(item.getTypeId()) + ".");
        }
    }

    private static String getAmountText(boolean sentenceStart, boolean infinite, int amount) {
        return infinite ? (sentenceStart ? "An" : "an") + " infinite stack of" : String.valueOf(amount);
    }

    public static void takeItem(CommandSender sender, ItemStack item, int amt, Player target) throws CommandException {
        if (amt <= 0) {
            throw new CommandException("Invalid item amount!");
        }
        item.setAmount(amt);
        if (target.getInventory().contains(item.getTypeId())) {
            target.getInventory().removeItem(new ItemStack[]{item});
            target.sendMessage(ChatColor.YELLOW + "Taken from " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ": " + amt + " " + ItemUtil.toItemName(item.getTypeId()) + ".");
            sender.sendMessage(ChatColor.YELLOW.toString() + amt + " " + ItemUtil.toItemName(item.getTypeId()) + " has been taken.");
        } else {
            sender.sendMessage(ChatColor.YELLOW.toString() + target.getName() + " has no " + ItemUtil.toItemName(item.getTypeId()) + ".");
        }
    }
}

