/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util.item;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ClothColor;
import com.sk89q.worldedit.blocks.ItemType;
import java.util.Random;
import org.bukkit.DyeColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    public static String toItemName(int id) {
        ItemType type = ItemType.fromID((int)id);
        if (type != null) {
            return type.getName();
        }
        return "#" + id;
    }

    public static ItemStack getItem(String name) {
        try {
            return ItemUtil.getCommandItem(name);
        }
        catch (CommandException e) {
            return null;
        }
    }

    public static ItemStack getCommandItem(String name) throws CommandException {
        int id;
        String[] parts;
        int dmg = 0;
        String dataName = null;
        String enchantmentName = null;
        if (name.contains("|")) {
            parts = name.split("\\|");
            name = parts[0];
            enchantmentName = parts[1];
        }
        if (name.contains(":")) {
            parts = name.split(":", 2);
            dataName = parts[1];
            name = parts[0];
        }
        try {
            id = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            Integer idTemp = CommandBook.inst().getItemNames().get(name.toLowerCase());
            if (idTemp != null) {
                id = idTemp;
            }
            ItemType type = ItemType.lookup((String)name);
            if (type == null) {
                throw new CommandException("No item type known by '" + name + "'");
            }
            id = type.getID();
        }
        if (dataName != null) {
            dmg = ItemUtil.matchItemData(id, dataName);
        }
        ItemStack stack = new ItemStack(id, 1, (short)dmg);
        if (enchantmentName != null) {
            String[] enchantments;
            for (String enchStr : enchantments = enchantmentName.split(",")) {
                int level = 1;
                if (enchStr.contains(":")) {
                    String[] parts2 = enchStr.split(":");
                    enchStr = parts2[0];
                    try {
                        level = Integer.parseInt(parts2[1]);
                    }
                    catch (NumberFormatException ignore) {
                        // empty catch block
                    }
                }
                Enchantment ench = null;
                String testName = enchStr.toLowerCase().replaceAll("[_\\-]", "");
                for (Enchantment possible : Enchantment.values()) {
                    if (!possible.getName().toLowerCase().replaceAll("[_\\-]", "").equals(testName)) continue;
                    ench = possible;
                    break;
                }
                if (ench == null) {
                    throw new CommandException("Unknown enchantment '" + enchStr + "'");
                }
                stack.addUnsafeEnchantment(ench, level);
            }
        }
        return stack;
    }

    public static void expandStack(ItemStack item, boolean infinite, boolean overrideStackSize) {
        int stackSize;
        if (item == null || item.getAmount() == 0 || item.getTypeId() <= 0) {
            return;
        }
        int n = stackSize = overrideStackSize ? 64 : item.getType().getMaxStackSize();
        if (item.getType().getMaxStackSize() == 1) {
            return;
        }
        if (infinite) {
            item.setAmount(-1);
        } else if (item.getAmount() < stackSize) {
            item.setAmount(stackSize);
        }
    }

    public static int matchItemData(int id, String filter) throws CommandException {
        try {
            return Integer.parseInt(filter);
        }
        catch (NumberFormatException ignored) {
            switch (id) {
                case 5: {
                    if (filter.equalsIgnoreCase("redwood")) {
                        return 1;
                    }
                    if (filter.equalsIgnoreCase("birch")) {
                        return 2;
                    }
                    throw new CommandException("Unknown wood type name of '" + filter + "'.");
                }
                case 43: 
                case 44: {
                    BlockType dataType = BlockType.lookup((String)filter);
                    if (dataType != null) {
                        if (dataType == BlockType.STONE) {
                            return 0;
                        }
                        if (dataType == BlockType.SANDSTONE) {
                            return 1;
                        }
                        if (dataType == BlockType.WOOD) {
                            return 2;
                        }
                        if (dataType == BlockType.COBBLESTONE) {
                            return 3;
                        }
                        throw new CommandException("Invalid slab material of '" + filter + "'.");
                    }
                    throw new CommandException("Unknown slab material of '" + filter + "'.");
                }
                case 35: 
                case 95: 
                case 159: 
                case 160: {
                    ClothColor col = ClothColor.lookup((String)filter);
                    if (col != null) {
                        return col.getID();
                    }
                    throw new CommandException("Unknown wool color name of '" + filter + "'.");
                }
                case 351: {
                    ClothColor dyeCol = ClothColor.lookup((String)filter);
                    if (dyeCol != null) {
                        return 15 - dyeCol.getID();
                    }
                    throw new CommandException("Unknown dye color name of '" + filter + "'.");
                }
            }
            throw new CommandException("Invalid data value of '" + filter + "'.");
        }
    }

    public static DyeColor matchDyeColor(String filter) throws CommandException {
        if (filter.equalsIgnoreCase("random")) {
            return DyeColor.getByData((byte)((byte)new Random().nextInt(15)));
        }
        try {
            DyeColor match = DyeColor.valueOf((String)filter.toUpperCase());
            if (match != null) {
                return match;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new CommandException("Unknown dye color name of '" + filter + "'.");
    }
}

