/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.session;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.session.AdministrativeSession;
import com.sk89q.commandbook.session.PersistentSession;
import com.sk89q.commandbook.session.ReflectiveSessionFactory;
import com.sk89q.commandbook.session.SessionFactory;
import com.sk89q.commandbook.session.UserSession;
import com.sk89q.commandbook.util.entity.player.UUIDUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLNode;
import com.sk89q.util.yaml.YAMLProcessor;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.bukkit.YAMLNodeConfigurationNode;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Sessions", desc="Handles player sessions")
public class SessionComponent
extends BukkitComponent
implements Runnable,
Listener {
    public static final long CHECK_FREQUENCY = 1200L;
    private final Map<Class<? extends CommandSender>, Map<String, Map<Class<? extends PersistentSession>, PersistentSession>>> sessions = new ConcurrentHashMap<Class<? extends CommandSender>, Map<String, Map<Class<? extends PersistentSession>, PersistentSession>>>();
    private final Map<Class<? extends PersistentSession>, SessionFactory<?>> sessionFactories = new ConcurrentHashMap();
    private File sessionsDir;
    private final Map<String, Map<String, YAMLProcessor>> sessionDataStores = new HashMap<String, Map<String, YAMLProcessor>>();

    @Override
    public void enable() {
        CommandBook.server().getScheduler().scheduleSyncRepeatingTask((Plugin)CommandBook.inst(), (Runnable)this, 1200L, 1200L);
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
        this.sessionsDir = new File(CommandBook.inst().getDataFolder(), "sessions");
        if (!this.sessionsDir.exists()) {
            this.sessionsDir.mkdirs();
        }
    }

    @Override
    public void disable() {
        for (Player player : CommandBook.server().getOnlinePlayers()) {
            String type = this.getType(player.getClass());
            for (PersistentSession session : this.getSessions((CommandSender)player)) {
                session.handleDisconnect();
                session.save(new YAMLNodeConfigurationNode(this.getSessionConfiguration(type, UUIDUtil.toUniqueString((CommandSender)player), session.getClass())));
            }
            YAMLProcessor proc = this.getUserConfiguration(type, UUIDUtil.toUniqueString((CommandSender)player), false);
            if (proc == null) continue;
            proc.save();
        }
    }

    @Deprecated
    public UserSession getSession(CommandSender user) {
        return this.getSession(UserSession.class, user);
    }

    @Deprecated
    public Map<String, UserSession> getSessions() {
        return this.getSessions(UserSession.class);
    }

    @Deprecated
    public AdministrativeSession getAdminSession(Player user) {
        return this.getSession(AdministrativeSession.class, (CommandSender)user);
    }

    @Deprecated
    public Map<String, AdministrativeSession> getAdminSessions() {
        return this.getSessions(AdministrativeSession.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PersistentSession> Map<String, T> getSessions(Class<T> type) {
        HashMap<String, T> ret = new HashMap<String, T>();
        Map<Class<? extends CommandSender>, Map<String, Map<Class<? extends PersistentSession>, PersistentSession>>> map = this.sessions;
        synchronized (map) {
            for (Map<String, Map<Class<? extends PersistentSession>, PersistentSession>> parent : this.sessions.values()) {
                for (Map.Entry<String, Map<Class<? extends PersistentSession>, PersistentSession>> entry : parent.entrySet()) {
                    PersistentSession session = entry.getValue().get(type);
                    if (session == null) continue;
                    ret.put(entry.getKey(), type.cast(session));
                }
            }
        }
        return ret;
    }

    public Collection<PersistentSession> getSessions(CommandSender user) {
        Map<Class<PersistentSession>, PersistentSession> ret = this.getSessionM(user.getClass()).get(UUIDUtil.toUniqueString(user));
        if (ret == null) {
            ret = Collections.emptyMap();
        }
        return Collections.unmodifiableCollection(ret.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PersistentSession> T getSession(Class<T> type, CommandSender user) {
        Map<Class<? extends CommandSender>, Map<String, Map<Class<? extends PersistentSession>, PersistentSession>>> map = this.sessions;
        synchronized (map) {
            PersistentSession session;
            Map<String, Map<Class<? extends PersistentSession>, PersistentSession>> typeMap = this.getSessionM(user.getClass());
            Map<Class<? extends PersistentSession>, PersistentSession> userSessions = typeMap.get(UUIDUtil.toUniqueString(user));
            if (userSessions == null) {
                userSessions = new HashMap<Class<? extends PersistentSession>, PersistentSession>();
                typeMap.put(UUIDUtil.toUniqueString(user), userSessions);
            }
            if ((session = (PersistentSession)type.cast(userSessions.get(type))) == null && (session = this.getSessionFactory(type).createSession(user)) != null) {
                YAMLNode node = this.getSessionConfiguration(this.getType(user.getClass()), UUIDUtil.toUniqueString(user), type, false);
                if (node != null) {
                    session.load(new YAMLNodeConfigurationNode(node));
                }
                session.handleReconnect(user);
                userSessions.put(type, session);
            }
            return (T)session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PersistentSession> SessionFactory<T> getSessionFactory(Class<T> type) {
        Map<Class<? extends PersistentSession>, SessionFactory<?>> map = this.sessionFactories;
        synchronized (map) {
            ReflectiveSessionFactory factory = this.sessionFactories.get(type);
            if (factory == null) {
                factory = new ReflectiveSessionFactory(type);
                this.sessionFactories.put(type, factory);
            }
            return factory;
        }
    }

    public <T extends PersistentSession> void registerSessionFactory(Class<T> type, SessionFactory<T> factory) {
        this.sessionFactories.put(type, factory);
    }

    public void addSession(PersistentSession session, CommandSender user) {
        Map<String, Map<Class<? extends PersistentSession>, PersistentSession>> typeMap = this.getSessionM(user.getClass());
        Map<Class<? extends PersistentSession>, PersistentSession> userSessions = typeMap.get(UUIDUtil.toUniqueString(user));
        if (userSessions == null) {
            userSessions = new HashMap<Class<? extends PersistentSession>, PersistentSession>();
            typeMap.put(UUIDUtil.toUniqueString(user), userSessions);
        }
        userSessions.put(session.getClass(), session);
    }

    private YAMLProcessor getUserConfiguration(String type, String commander, boolean create) {
        Map<String, YAMLProcessor> typeMap = this.getDataStore(type);
        YAMLProcessor processor = typeMap.get(commander);
        if (processor == null) {
            File userFile = new File(this.sessionsDir.getPath() + File.separator + type + File.separator + commander + ".yml");
            if (!userFile.exists()) {
                File dir = userFile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!this.migrate(commander, userFile)) {
                    if (!create) {
                        return null;
                    }
                    try {
                        userFile.createNewFile();
                    }
                    catch (IOException e) {
                        CommandBook.logger().log(Level.WARNING, "Could not create sessions persistence file for user " + commander, e);
                    }
                }
            }
            processor = new YAMLProcessor(userFile, false, YAMLFormat.COMPACT);
            try {
                processor.load();
            }
            catch (IOException e) {
                CommandBook.logger().log(Level.WARNING, "Error loading sessions persistence file for user " + commander, e);
            }
            typeMap.put(commander, processor);
        }
        return processor;
    }

    private YAMLNode getSessionConfiguration(String type, String commander, Class<? extends PersistentSession> sessType) {
        return this.getSessionConfiguration(type, commander, sessType, true);
    }

    private YAMLNode getSessionConfiguration(String type, String commander, Class<? extends PersistentSession> sessType, boolean create) {
        YAMLProcessor proc = this.getUserConfiguration(type, commander, create);
        if (proc == null) {
            return null;
        }
        String className = sessType.getCanonicalName().replaceAll("\\.", "/");
        YAMLNode sessionNode = proc.getNode(className);
        if (sessionNode == null && create) {
            sessionNode = proc.addNode(className);
        }
        return sessionNode;
    }

    private boolean migrate(String commander, File dest) {
        boolean result = false;
        try {
            File oldUserFile;
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(commander));
            if (player != null && (oldUserFile = new File(this.sessionsDir.getPath() + File.separator + player.getName() + ".yml")).exists() && !(result = oldUserFile.renameTo(dest))) {
                CommandBook.logger().warning("Could not update a player's session file to use UUID: " + commander);
            }
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        return result;
    }

    private String getType(Class<? extends CommandSender> clazz) {
        String[] split = clazz.getName().split("\\.");
        return split[split.length - 1];
    }

    private Map<String, Map<Class<? extends PersistentSession>, PersistentSession>> getSessionM(Class<? extends CommandSender> clazz) {
        Map<String, Map<Class<? extends PersistentSession>, PersistentSession>> typeMapping = this.sessions.get(clazz);
        if (typeMapping == null) {
            typeMapping = new HashMap<String, Map<Class<? extends PersistentSession>, PersistentSession>>();
            this.sessions.put(clazz, typeMapping);
        }
        return typeMapping;
    }

    private Map<String, YAMLProcessor> getDataStore(String type) {
        Map<String, YAMLProcessor> typeMap = this.sessionDataStores.get(type);
        if (typeMap == null) {
            typeMap = new HashMap<String, YAMLProcessor>();
            this.sessionDataStores.put(type, typeMap);
        }
        return typeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<Class<? extends CommandSender>, Map<String, Map<Class<? extends PersistentSession>, PersistentSession>>> map = this.sessions;
        synchronized (map) {
            for (Map.Entry<Class<? extends CommandSender>, Map<String, Map<Class<? extends PersistentSession>, PersistentSession>>> parent : this.sessions.entrySet()) {
                Iterator<Map.Entry<String, Map<Class<? extends PersistentSession>, PersistentSession>>> i = parent.getValue().entrySet().iterator();
                block4: while (i.hasNext()) {
                    Map.Entry<String, Map<Class<? extends PersistentSession>, PersistentSession>> entry = i.next();
                    Iterator<PersistentSession> i2 = entry.getValue().values().iterator();
                    while (i2.hasNext()) {
                        YAMLProcessor processor;
                        PersistentSession sess = i2.next();
                        if (sess.getOwner() != null) continue block4;
                        if (sess.isRecent()) continue;
                        i2.remove();
                        String sender = sess.getUniqueName();
                        if (sender == null || (processor = this.getUserConfiguration(this.getType(parent.getKey()), sender, false)) == null) continue;
                        processor.removeProperty(sess.getClass().getCanonicalName().replaceAll("\\.", "/"));
                    }
                    if (entry.getValue().size() != 0) continue;
                    i.remove();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        String type = this.getType(player.getClass());
        for (PersistentSession session : this.getSessions((CommandSender)player)) {
            session.load(new YAMLNodeConfigurationNode(this.getSessionConfiguration(type, UUIDUtil.toUniqueString((CommandSender)player), session.getClass())));
            session.handleReconnect((CommandSender)event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String type = this.getType(player.getClass());
        for (PersistentSession session : this.getSessions((CommandSender)event.getPlayer())) {
            session.handleDisconnect();
            session.save(new YAMLNodeConfigurationNode(this.getSessionConfiguration(type, UUIDUtil.toUniqueString((CommandSender)player), session.getClass())));
        }
        YAMLProcessor proc = this.getUserConfiguration(type, UUIDUtil.toUniqueString((CommandSender)player), false);
        if (proc != null) {
            proc.save();
        }
    }

    public class Commands {
        @Command(aliases={"confirm", "conf"}, desc="Confirm an action", max=0, flags="vc")
        public void confirm(CommandContext args, CommandSender sender) throws CommandException {
            UserSession session = SessionComponent.this.getSession(UserSession.class, sender);
            String cmd = session.getCommandToConfirm(false);
            if (cmd == null) {
                throw new CommandException("No command to confirm!");
            }
            if (args.hasFlag('v')) {
                sender.sendMessage(ChatColor.YELLOW + "Current command to confirm: " + cmd);
            } else if (args.hasFlag('c')) {
                session.getCommandToConfirm(true);
                sender.sendMessage(ChatColor.YELLOW + "Cleared command to confirm");
            } else {
                sender.sendMessage(ChatColor.YELLOW + "Command confirmed: " + cmd);
                CommandBook.server().dispatchCommand(sender, cmd);
                session.getCommandToConfirm(true);
            }
        }
    }
}

