/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jinglenote;

import com.sk89q.jinglenote.Instrument;
import com.sk89q.jinglenote.JingleNotePlayer;
import com.sk89q.jinglenote.JingleSequencer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;

public class MidiJingleSequencer
implements JingleSequencer {
    private static final int[] instruments = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 2, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 1, 1, 1, 5, 1, 1, 1, 1, 1, 2, 4, 3};
    private static final int[] percussion = new int[]{3, 3, 4, 4, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 3, 3, 3, 0, 3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 2, 2, 0, 0, 2, 2, 0, 0, 3, 3, 3, 3, 3, 3, 5, 5, 3, 3};
    protected final File midiFile;
    private Sequencer sequencer = null;

    public MidiJingleSequencer(File midiFile, boolean loop) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        this.midiFile = midiFile;
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.open();
            Sequence seq = MidiSystem.getSequence(midiFile);
            this.sequencer.setSequence(seq);
            if (loop) {
                this.sequencer.setLoopCount(-1);
            }
        }
        catch (MidiUnavailableException e) {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.close();
            }
            throw e;
        }
        catch (InvalidMidiDataException e) {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.close();
            }
            throw e;
        }
        catch (IOException e) {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(final JingleNotePlayer notePlayer) throws InterruptedException {
        final HashMap patches = new HashMap();
        try {
            if (this.sequencer.getSequence() == null) {
                return;
            }
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            this.sequencer.getTransmitter().setReceiver(new Receiver(){

                @Override
                public void send(MidiMessage message, long timeStamp) {
                    if ((message.getStatus() & 0xF0) == 192) {
                        ShortMessage msg = (ShortMessage)message;
                        int chan = msg.getChannel();
                        int patch = msg.getData1();
                        patches.put(chan, patch);
                    } else if ((message.getStatus() & 0xF0) == 144) {
                        ShortMessage msg = (ShortMessage)message;
                        int chan = msg.getChannel();
                        int n = msg.getData1();
                        if (chan != 9) {
                            notePlayer.play(new JingleSequencer.Note(MidiJingleSequencer.this.toMCSound(MidiJingleSequencer.toMCInstrument((Integer)patches.get(chan))), MidiJingleSequencer.toMCNote(n), 10.0f * ((float)msg.getData2() / 127.0f)));
                        }
                    }
                }

                @Override
                public void close() {
                }
            });
            try {
                if (this.sequencer.isOpen()) {
                    this.sequencer.start();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            while (this.sequencer.isRunning()) {
                Thread.sleep(1000L);
            }
            if (this.sequencer.isRunning()) {
                this.sequencer.stop();
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        finally {
            if (this.sequencer.isOpen()) {
                this.sequencer.close();
            }
        }
    }

    @Override
    public void stop() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.close();
        }
    }

    protected static byte toMCNote(int n) {
        if (n < 54) {
            return (byte)((n - 6) % 12);
        }
        if (n > 78) {
            return (byte)((n - 6) % 12 + 12);
        }
        return (byte)(n - 54);
    }

    protected static byte toMCInstrument(Integer patch) {
        if (patch == null) {
            return 0;
        }
        if (patch < 0 || patch >= instruments.length) {
            return 0;
        }
        return (byte)instruments[patch];
    }

    protected Instrument toMCSound(byte instrument) {
        switch (instrument) {
            case 1: {
                return Instrument.BASS_GUITAR;
            }
            case 2: {
                return Instrument.SNARE_DRUM;
            }
            case 3: {
                return Instrument.STICKS;
            }
            case 4: {
                return Instrument.BASS_DRUM;
            }
            case 5: {
                return Instrument.GUITAR;
            }
            case 6: {
                return Instrument.BASS;
            }
        }
        return Instrument.PIANO;
    }

    protected static byte toMCPercussion(Integer patch) {
        if (patch == null) {
            return 0;
        }
        int i = patch - 33;
        if (i < 0 || i >= percussion.length) {
            return 1;
        }
        return (byte)percussion[i];
    }

    public boolean isSongPlaying() {
        return this.sequencer.isRunning();
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }
}

