/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jinglenote;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.jinglenote.Instrument;
import com.sk89q.jinglenote.JingleNotePlayer;
import com.sk89q.jinglenote.JingleSequencer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class StringJingleSequencer
implements JingleSequencer {
    String tune;
    int delay;
    int position;
    int taskID;
    boolean isPlaying = false;
    List<JingleSequencer.Note> song;

    public StringJingleSequencer(String tune, int delay) {
        this.tune = tune;
        this.delay = delay;
        this.song = this.parseTune(tune);
    }

    @Override
    public void run(final JingleNotePlayer player) throws InterruptedException {
        this.position = 0;
        if (this.song == null) {
            return;
        }
        this.isPlaying = true;
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)CommandBook.inst(), new Runnable(){

            @Override
            public void run() {
                if (StringJingleSequencer.this.position >= StringJingleSequencer.this.song.size()) {
                    Bukkit.getScheduler().cancelTask(StringJingleSequencer.this.taskID);
                    StringJingleSequencer.this.isPlaying = false;
                    return;
                }
                player.play(StringJingleSequencer.this.song.get(StringJingleSequencer.this.position));
                ++StringJingleSequencer.this.position;
            }
        }, (long)this.delay, (long)this.delay);
    }

    public ArrayList<JingleSequencer.Note> parseTune(String tune) {
        if (tune == null) {
            return null;
        }
        ArrayList<JingleSequencer.Note> musicKeys = new ArrayList<JingleSequencer.Note>();
        byte instrument = -1;
        for (int i = 0; i < tune.length(); ++i) {
            int octave;
            char first = tune.charAt(i);
            if (first >= '0' && first <= '9') {
                instrument = this.getTypeFromChar(first);
                continue;
            }
            if (i + 1 >= tune.length()) continue;
            if (instrument == -1) {
                return null;
            }
            int pitch = this.getPitchFromChar(first);
            boolean skip = false;
            if (pitch == -1) {
                switch (first) {
                    case ' ': 
                    case '-': {
                        skip = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            try {
                octave = Integer.parseInt(Character.toString(tune.charAt(i + 1)));
            }
            catch (NumberFormatException e) {
                octave = 2;
            }
            if (skip) {
                musicKeys.add(new JingleSequencer.Note(Instrument.PIANO, 0, 0.0f));
                if (octave == 0) {
                    octave = 10;
                }
            } else {
                if (octave < 2) {
                    octave = 2;
                }
                if ((pitch += (octave - 2) * 12) < 0) {
                    pitch = 0;
                } else if (pitch > 24) {
                    pitch = 24;
                }
                musicKeys.add(new JingleSequencer.Note(this.toMCSound(instrument), (byte)pitch, 60.0f));
            }
            ++i;
        }
        if (musicKeys.size() == 0) {
            return null;
        }
        return musicKeys;
    }

    public byte getTypeFromChar(char type) {
        byte instrument = -1;
        switch (type) {
            case '0': 
            case '7': 
            case '8': 
            case '9': {
                instrument = 0;
                break;
            }
            case '1': {
                instrument = 1;
                break;
            }
            case '2': {
                instrument = 2;
                break;
            }
            case '3': {
                instrument = 3;
                break;
            }
            case '4': {
                instrument = 4;
                break;
            }
            case '5': {
                instrument = 5;
                break;
            }
            case '6': {
                instrument = 6;
            }
        }
        return instrument;
    }

    public int getPitchFromChar(char charPitch) {
        int pitch = 0;
        switch (charPitch) {
            case 'f': {
                ++pitch;
            }
            case 'e': {
                ++pitch;
            }
            case 'D': {
                ++pitch;
            }
            case 'd': {
                ++pitch;
            }
            case 'C': {
                ++pitch;
            }
            case 'c': {
                ++pitch;
            }
            case 'b': {
                ++pitch;
            }
            case 'A': {
                ++pitch;
            }
            case 'a': {
                ++pitch;
            }
            case 'G': {
                ++pitch;
            }
            case 'g': {
                ++pitch;
            }
            case 'F': {
                break;
            }
            default: {
                pitch = -1;
            }
        }
        return pitch;
    }

    protected Instrument toMCSound(byte instrument) {
        switch (instrument) {
            case 1: {
                return Instrument.BASS_GUITAR;
            }
            case 2: {
                return Instrument.SNARE_DRUM;
            }
            case 3: {
                return Instrument.STICKS;
            }
            case 4: {
                return Instrument.BASS_DRUM;
            }
            case 5: {
                return Instrument.GUITAR;
            }
            case 6: {
                return Instrument.BASS;
            }
        }
        return Instrument.PIANO;
    }

    @Override
    public void stop() {
    }

    public boolean isSongPlaying() {
        return this.isPlaying;
    }
}

