/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jinglenote.bukkit;

import com.sk89q.jinglenote.Instrument;
import com.sk89q.jinglenote.JingleNotePlayer;
import com.sk89q.jinglenote.JingleSequencer;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class BukkitJingleNotePlayer
extends JingleNotePlayer {
    Player p = null;

    public BukkitJingleNotePlayer(String player, JingleSequencer seq) {
        super(player, seq);
    }

    @Override
    public void play(JingleSequencer.Note note) {
        if (this.p == null || !this.p.isOnline()) {
            this.p = Bukkit.getPlayerExact((String)this.player);
        }
        if (this.p == null || !this.p.isOnline() || note == null) {
            return;
        }
        this.p.playSound(this.p.getLocation(), this.toSound(note.getInstrument()), note.getVelocity(), note.getNote());
    }

    public Sound toSound(Instrument instrument) {
        switch (instrument) {
            case PIANO: {
                return Sound.NOTE_PIANO;
            }
            case GUITAR: {
                return Sound.NOTE_PLING;
            }
            case BASS: {
                return Sound.NOTE_BASS;
            }
            case BASS_GUITAR: {
                return Sound.NOTE_BASS_GUITAR;
            }
            case STICKS: {
                return Sound.NOTE_STICKS;
            }
            case BASS_DRUM: {
                return Sound.NOTE_BASS_DRUM;
            }
            case SNARE_DRUM: {
                return Sound.NOTE_SNARE_DRUM;
            }
        }
        return Sound.NOTE_PIANO;
    }
}

