/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.time;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.time.TimeLocker;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Time Control", desc="Commands to manage and lock time for a world.")
public class TimeComponent
extends BukkitComponent
implements Listener {
    protected final Map<String, Integer> tasks = new HashMap<String, Integer>();
    protected final Map<String, Integer> lockedTimes = new HashMap<String, Integer>();
    protected LocalConfiguration config;

    @Override
    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        if (this.config.timeLockDelay == 0) {
            this.config.timeLockDelay = 20;
            this.saveConfig(this.config);
        }
        this.configureWorldLocks();
        this.registerCommands(Commands.class);
        CommandBook.registerEvents(this);
    }

    private void configureWorldLocks() {
        if (this.config.timeLocks != null) {
            for (Map.Entry<String, Object> entry : this.config.timeLocks.entrySet()) {
                int time = 0;
                try {
                    time = InputUtil.TimeParser.matchMCWorldTime(String.valueOf(entry.getValue()));
                }
                catch (CommandException e) {
                    CommandBook.logger().warning("Time lock: Failed to parse time '" + entry.getValue() + "'");
                    continue;
                }
                this.lockedTimes.put(entry.getKey(), time);
                World world = CommandBook.server().getWorld(entry.getKey());
                if (world == null) {
                    CommandBook.logger().info("Could not time-lock unknown world '" + entry.getKey() + "'");
                    continue;
                }
                world.setTime((long)time);
                this.lock(world);
                CommandBook.logger().info("Time locked to '" + ChatUtil.getTimeString(time) + "' for world '" + world.getName() + "'");
            }
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.configureWorldLocks();
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        Integer lockedTime = this.getLockedTimes().get(world.getName());
        if (lockedTime != null) {
            world.setTime((long)lockedTime.intValue());
            this.lock(world);
            CommandBook.logger().info("Time locked to '" + ChatUtil.getTimeString(lockedTime.intValue()) + "' for world '" + world.getName() + "'");
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        this.unlock(event.getWorld());
    }

    public Map<String, Integer> getLockedTimes() {
        return this.lockedTimes;
    }

    public synchronized void unlock(World world) {
        Integer id = this.tasks.get(world.getName());
        if (id != null) {
            CommandBook.server().getScheduler().cancelTask(id.intValue());
        }
    }

    public synchronized void lock(World world) {
        long time = world.getFullTime();
        this.unlock(world);
        int id = CommandBook.server().getScheduler().scheduleSyncRepeatingTask((Plugin)CommandBook.inst(), (Runnable)new TimeLocker(world, time), 20L, (long)this.config.timeLockDelay);
        this.tasks.put(world.getName(), id);
    }

    @Deprecated
    public static int matchTime(String timeStr) throws CommandException {
        return InputUtil.TimeParser.matchMCWorldTime(timeStr);
    }

    public class Commands {
        @Command(aliases={"time"}, usage="[world] <time|\"current\">", desc="Get/change the world time", flags="ls", min=0, max=2)
        public void time(CommandContext args, CommandSender sender) throws CommandException {
            String timeStr;
            World world;
            boolean onlyLock = false;
            if (args.argsLength() == 0) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
                timeStr = "current";
            } else if (args.argsLength() == 1) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
                timeStr = args.getString(0);
            } else {
                world = InputUtil.LocationParser.matchWorld(sender, args.getString(0));
                timeStr = args.getString(1);
            }
            boolean broadcastChanges = CommandBook.inst().broadcastChanges;
            if (broadcastChanges && args.hasFlag('s')) {
                CommandBook.inst().checkPermission(sender, "commandbook.time.silent");
                broadcastChanges = false;
            }
            if (timeStr.equalsIgnoreCase("current") || timeStr.equalsIgnoreCase("cur") || timeStr.equalsIgnoreCase("now")) {
                if (!args.hasFlag('l')) {
                    CommandBook.inst().checkPermission(sender, "commandbook.time.check");
                    sender.sendMessage(ChatColor.YELLOW + "Time: " + ChatUtil.getTimeString(world.getTime()));
                    return;
                }
                onlyLock = true;
            }
            CommandBook.inst().checkPermission(sender, "commandbook.time");
            if (!onlyLock) {
                TimeComponent.this.unlock(world);
                world.setTime((long)InputUtil.TimeParser.matchMCWorldTime(timeStr));
            }
            String verb = "set";
            if (args.hasFlag('l')) {
                CommandBook.inst().checkPermission(sender, "commandbook.time.lock");
                TimeComponent.this.lock(world);
                verb = "locked";
            }
            if (broadcastChanges) {
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " " + verb + " the time of '" + world.getName() + "' to " + ChatUtil.getTimeString(world.getTime()) + ".");
            } else {
                sender.sendMessage(ChatColor.YELLOW + "Time " + verb + " to " + ChatUtil.getTimeString(world.getTime()) + ".");
            }
        }

        @Command(aliases={"playertime"}, usage="[filter] <time|\"current\">", desc="Get/change a player's time", flags="rsw", min=0, max=2)
        public void playertime(CommandContext args, CommandSender sender) throws CommandException {
            ArrayList players = null;
            String timeStr = "current";
            boolean included = false;
            boolean reset = args.hasFlag('r');
            if (args.argsLength() < 2) {
                if (args.argsLength() == 1) {
                    timeStr = args.getString(0);
                    if (reset) {
                        players = InputUtil.PlayerParser.matchPlayers(sender, timeStr);
                    }
                }
                if (players == null) {
                    players = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
                }
            } else {
                players = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
                timeStr = args.getString(1);
            }
            for (Player player : players) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.time.player.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.time.player");
            }
            if (args.hasFlag('r')) {
                for (Player player : players) {
                    player.resetPlayerTime();
                    if (!args.hasFlag('s')) {
                        player.sendMessage(ChatColor.YELLOW + "Your time was reset to world time");
                    }
                    if (!(sender instanceof Player) || !sender.equals(player)) continue;
                    included = true;
                }
                if (!included) {
                    sender.sendMessage(ChatColor.YELLOW + "Player times reset");
                }
                return;
            }
            if (timeStr.equalsIgnoreCase("current") || timeStr.equalsIgnoreCase("cur") || timeStr.equalsIgnoreCase("now")) {
                CommandBook.inst().checkPermission(sender, "commandbook.time.player.check");
                sender.sendMessage(ChatColor.YELLOW + "Player Time: " + ChatUtil.getTimeString(InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0, PlayerUtil.checkPlayer(sender).getName())).getPlayerTime()));
                return;
            }
            int time = InputUtil.TimeParser.matchMCWorldTime(timeStr);
            for (Player player : players) {
                if (player.equals(sender)) {
                    included = true;
                }
                player.setPlayerTime(args.hasFlag('w') ? (long)Integer.parseInt(timeStr) : (long)time, args.hasFlag('w'));
                player.sendMessage(ChatColor.YELLOW + "Your time set to " + ChatUtil.getTimeString(player.getPlayerTime()));
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW + "Player times set to " + ChatUtil.getTimeString(time));
            }
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="time-lock")
        public Map<String, Object> timeLocks;
        @Setting(value="time-lock-delay")
        public int timeLockDelay = 20;

        private LocalConfiguration() {
        }
    }
}

