/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.commandbook.locations.NamedLocation;
import com.sk89q.commandbook.locations.RootLocationManager;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.blocks.BlockType;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LocationUtil {
    public static Location findFreePosition(Location searchPos) {
        int y;
        World world = searchPos.getWorld();
        Location loc = searchPos.clone();
        int x = searchPos.getBlockX();
        int origY = y = Math.max(0, searchPos.getBlockY());
        int z = searchPos.getBlockZ();
        int free = 0;
        while (y <= world.getMaxHeight() + 2) {
            free = BlockType.canPassThrough((int)world.getBlockTypeIdAt(x, y, z)) ? (int)((byte)(free + 1)) : 0;
            if (free == 2) {
                if (y - 1 != origY) {
                    loc.setX((double)x + 0.5);
                    loc.setY((double)(y - 1));
                    loc.setZ((double)z + 0.5);
                }
                return loc;
            }
            ++y;
        }
        return null;
    }

    public static World extractWorld(CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getWorld();
        }
        if (sender instanceof BlockCommandSender) {
            return ((BlockCommandSender)sender).getBlock().getWorld();
        }
        return (World)BasePlugin.server().getWorlds().get(0);
    }

    public static Location getManagedLocation(RootLocationManager<NamedLocation> manager, World world, String id) throws CommandException {
        NamedLocation loc = manager.get(world, id);
        if (loc == null) {
            throw new CommandException("A location by that name could not be found.");
        }
        return loc.getLocation();
    }

    public static double distanceSquared2D(Location a, Location b) {
        return Math.pow(a.getX() - b.getX(), 2.0) + Math.pow(a.getZ() - b.getZ(), 2.0);
    }
}

