/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jinglenote;

import com.sk89q.jinglenote.JingleNotePlayer;
import com.sk89q.jinglenote.JingleSequencer;
import com.sk89q.jinglenote.bukkit.BukkitJingleNotePlayer;
import java.util.HashMap;
import java.util.Map;

public class JingleNoteManager {
    protected final Map<String, JingleNotePlayer> instances = new HashMap<String, JingleNotePlayer>();

    public void play(String player, JingleSequencer sequencer) {
        if (this.instances.containsKey(player)) {
            JingleNotePlayer existing = this.instances.get(player);
            existing.stop();
            this.instances.remove(player);
        }
        BukkitJingleNotePlayer notePlayer = new BukkitJingleNotePlayer(player, sequencer);
        Thread thread = new Thread(notePlayer);
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.setName("JingleNotePlayer for " + player);
        thread.start();
        this.instances.put(player, notePlayer);
    }

    public boolean stop(String player) {
        if (this.instances.containsKey(player)) {
            JingleNotePlayer existing = this.instances.get(player);
            existing.stop();
            this.instances.remove(player);
            return true;
        }
        return false;
    }

    public void stopAll() {
        for (JingleNotePlayer notePlayer : this.instances.values()) {
            notePlayer.stop();
        }
        this.instances.clear();
    }
}

