/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import java.io.Serializable;

public class ClassReferenceMirror<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;

    public static ClassReferenceMirror fromClass(Class c) {
        return new ClassReferenceMirror(ClassUtils.getJVMName(c));
    }

    public ClassReferenceMirror(String name) {
        this.name = name;
    }

    public String getJVMName() {
        return this.name;
    }

    public Class<T> loadClass() throws ClassNotFoundException {
        return this.loadClass(ClassDiscovery.getDefaultInstance().getDefaultClassLoader(), true);
    }

    public Class<T> loadClass(ClassLoader loader, boolean initialize) throws ClassNotFoundException {
        return ClassUtils.forCanonicalName(ClassUtils.getCommonNameFromJVMName(this.name), initialize, loader);
    }

    public boolean isArray() {
        return this.name.startsWith("[");
    }

    public ClassReferenceMirror getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return new ClassReferenceMirror<T>(this.name.substring(1));
    }

    public String toString() {
        return ClassUtils.getCommonNameFromJVMName(this.name);
    }

    public int hashCode() {
        int hash2 = 3;
        hash2 = 23 * hash2 + (this.name != null ? this.name.hashCode() : 0);
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassReferenceMirror other = (ClassReferenceMirror)obj;
        return !(this.name != null ? !this.name.equals(other.name) : other.name != null);
    }
}

