/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class Color
implements Serializable {
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color LIGHT_GRAY = new Color(192, 192, 192);
    public static final Color GRAY = new Color(128, 128, 128);
    public static final Color DARK_GRAY = new Color(64, 64, 64);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color PINK = new Color(255, 175, 175);
    public static final Color ORANGE = new Color(255, 200, 0);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color MAGENTA = new Color(255, 0, 255);
    public static final Color CYAN = new Color(0, 255, 255);
    public static final Color BLUE = new Color(0, 0, 255);
    int value;
    private float[] frgbvalue = null;
    private float[] fvalue = null;
    private float falpha = 0.0f;
    private static final long serialVersionUID = 118526816881161077L;
    private static final double FACTOR = 0.7;

    private static void testColorValueRange(int r, int g2, int b, int a) {
        boolean rangeError = false;
        String badComponentString = "";
        if (a < 0 || a > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Alpha";
        }
        if (r < 0 || r > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Red";
        }
        if (g2 < 0 || g2 > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Green";
        }
        if (b < 0 || b > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + badComponentString);
        }
    }

    private static void testColorValueRange(float r, float g2, float b, float a) {
        boolean rangeError = false;
        String badComponentString = "";
        if ((double)a < 0.0 || (double)a > 1.0) {
            rangeError = true;
            badComponentString = badComponentString + " Alpha";
        }
        if ((double)r < 0.0 || (double)r > 1.0) {
            rangeError = true;
            badComponentString = badComponentString + " Red";
        }
        if ((double)g2 < 0.0 || (double)g2 > 1.0) {
            rangeError = true;
            badComponentString = badComponentString + " Green";
        }
        if ((double)b < 0.0 || (double)b > 1.0) {
            rangeError = true;
            badComponentString = badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + badComponentString);
        }
    }

    public Color(int r, int g2, int b) {
        this(r, g2, b, 255);
    }

    @ConstructorProperties(value={"red", "green", "blue", "alpha"})
    public Color(int r, int g2, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | b & 0xFF;
        Color.testColorValueRange(r, g2, b, a);
    }

    public Color(int rgb) {
        this.value = 0xFF000000 | rgb;
    }

    public Color(int rgba, boolean hasalpha) {
        this.value = hasalpha ? rgba : 0xFF000000 | rgba;
    }

    public Color(float r, float g2, float b) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g2 * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
        Color.testColorValueRange(r, g2, b, 1.0f);
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = r;
        this.frgbvalue[1] = g2;
        this.frgbvalue[2] = b;
        this.falpha = 1.0f;
        this.fvalue = this.frgbvalue;
    }

    public Color(float r, float g2, float b, float a) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g2 * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5), (int)((double)(a * 255.0f) + 0.5));
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = r;
        this.frgbvalue[1] = g2;
        this.frgbvalue[2] = b;
        this.falpha = a;
        this.fvalue = this.frgbvalue;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int r = this.getRed();
        int g2 = this.getGreen();
        int b = this.getBlue();
        int alpha = this.getAlpha();
        int i = 3;
        if (r == 0 && g2 == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g2 > 0 && g2 < i) {
            g2 = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.7), 255), Math.min((int)((double)g2 / 0.7), 255), Math.min((int)((double)b / 0.7), 255), alpha);
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0), this.getAlpha());
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Color && ((Color)obj).getRGB() == this.getRGB();
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public static Color decode(String nm) throws NumberFormatException {
        Integer intval = Integer.decode(nm);
        int i = intval;
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public static Color getColor(String nm) {
        return Color.getColor(nm, null);
    }

    public static Color getColor(String nm, Color v) {
        Integer intval = Integer.getInteger(nm);
        if (intval == null) {
            return v;
        }
        int i = intval;
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public static Color getColor(String nm, int v) {
        Integer intval = Integer.getInteger(nm);
        int i = intval != null ? intval : v;
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g2 = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g2 = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p2 = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(t * 255.0f + 0.5f);
                    b = (int)(p2 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p2 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p2 * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p2 * 255.0f + 0.5f);
                    g2 = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g2 = (int)(p2 * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(p2 * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g2 << 8 | b;
    }

    public static float[] RGBtoHSB(int r, int g2, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g2 ? r : g2;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g2 ? r : g2;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g2) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g2 == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static Color getHSBColor(float h, float s, float b) {
        return new Color(Color.HSBtoRGB(h, s, b));
    }

    public float[] getRGBComponents(float[] compArray) {
        float[] f = compArray == null ? new float[4] : compArray;
        if (this.frgbvalue == null) {
            f[0] = (float)this.getRed() / 255.0f;
            f[1] = (float)this.getGreen() / 255.0f;
            f[2] = (float)this.getBlue() / 255.0f;
            f[3] = (float)this.getAlpha() / 255.0f;
        } else {
            f[0] = this.frgbvalue[0];
            f[1] = this.frgbvalue[1];
            f[2] = this.frgbvalue[2];
            f[3] = this.falpha;
        }
        return f;
    }

    public float[] getRGBColorComponents(float[] compArray) {
        float[] f = compArray == null ? new float[3] : compArray;
        if (this.frgbvalue == null) {
            f[0] = (float)this.getRed() / 255.0f;
            f[1] = (float)this.getGreen() / 255.0f;
            f[2] = (float)this.getBlue() / 255.0f;
        } else {
            f[0] = this.frgbvalue[0];
            f[1] = this.frgbvalue[1];
            f[2] = this.frgbvalue[2];
        }
        return f;
    }

    public float[] getComponents(float[] compArray) {
        if (this.fvalue == null) {
            return this.getRGBComponents(compArray);
        }
        int n = this.fvalue.length;
        float[] f = compArray == null ? new float[n + 1] : compArray;
        System.arraycopy(this.fvalue, 0, f, 0, n);
        f[n] = this.falpha;
        return f;
    }

    public float[] getColorComponents(float[] compArray) {
        if (this.fvalue == null) {
            return this.getRGBColorComponents(compArray);
        }
        int n = this.fvalue.length;
        float[] f = compArray == null ? new float[n] : compArray;
        System.arraycopy(this.fvalue, 0, f, 0, n);
        return f;
    }

    public java.awt.Color toJavaAWTColor() {
        return new java.awt.Color(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }
}

