/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class UIUtils {
    public static void centerWindow(Window w) {
        GraphicsEnvironment g2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = g2.getScreenDevices();
        Point mousePoint = MouseInfo.getPointerInfo().getLocation();
        Rectangle primary = null;
        for (GraphicsDevice gg : devices) {
            Rectangle r;
            primary = r = gg.getDefaultConfiguration().getBounds();
            if (mousePoint.x <= r.x || mousePoint.x >= r.x + r.width || mousePoint.y <= r.y || mousePoint.y >= r.y + r.height) continue;
            primary = r;
            break;
        }
        assert (primary != null);
        Point center = new Point(primary.width / 2 + primary.x, primary.height / 2 + primary.y);
        Point offset = new Point(center.x - w.getWidth() / 2, center.y - w.getHeight() / 2);
        w.setLocation(offset);
    }

    public static void centerWindowOnWindow(Window windowToCenter, Window windowUponWhichToCenterOn) {
        windowToCenter.setLocationRelativeTo(windowUponWhichToCenterOn);
    }

    public static void setEnabled(boolean enabled, Component ... components) {
        for (Component component : components) {
            component.setEnabled(enabled);
        }
    }

    public static boolean openWebpage(URI uri) throws IOException {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(uri);
            return true;
        }
        return false;
    }

    public static boolean openWebpage(URL url) throws IOException, URISyntaxException {
        return UIUtils.openWebpage(url.toURI());
    }
}

