/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCEnchantment;
import com.laytonsmith.abstraction.MCItemMeta;
import com.laytonsmith.abstraction.bukkit.BukkitMCEnchantment;
import com.laytonsmith.abstraction.enums.MCItemFlag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class BukkitMCItemMeta
implements MCItemMeta {
    ItemMeta im;

    public BukkitMCItemMeta(ItemMeta im) {
        this.im = im;
    }

    public BukkitMCItemMeta(AbstractionObject o) {
        this.im = (ItemMeta)o;
    }

    @Override
    public boolean hasDisplayName() {
        return this.im.hasDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.im.getDisplayName();
    }

    @Override
    public void setDisplayName(String name) {
        this.im.setDisplayName(name);
    }

    @Override
    public boolean hasLore() {
        return this.im.hasLore();
    }

    @Override
    public List<String> getLore() {
        return this.im.getLore();
    }

    @Override
    public void setLore(List<String> lore) {
        this.im.setLore(lore);
    }

    @Override
    public boolean hasEnchants() {
        return this.im.hasEnchants();
    }

    @Override
    public Map<MCEnchantment, Integer> getEnchants() {
        HashMap<MCEnchantment, Integer> map = new HashMap<MCEnchantment, Integer>();
        for (Map.Entry entry : this.im.getEnchants().entrySet()) {
            map.put(new BukkitMCEnchantment((Enchantment)entry.getKey()), (Integer)entry.getValue());
        }
        return map;
    }

    @Override
    public boolean addEnchant(MCEnchantment ench, int level, boolean ignoreLevelRestriction) {
        return this.im.addEnchant(((BukkitMCEnchantment)ench).__Enchantment(), level, ignoreLevelRestriction);
    }

    @Override
    public boolean removeEnchant(MCEnchantment ench) {
        return this.im.removeEnchant(((BukkitMCEnchantment)ench).__Enchantment());
    }

    @Override
    public Object getHandle() {
        return this.im;
    }

    public ItemMeta asItemMeta() {
        return this.im;
    }

    public boolean equals(Object obj) {
        return obj instanceof MCItemMeta && this.im.equals(((MCItemMeta)obj).getHandle());
    }

    public int hashCode() {
        return this.im.hashCode();
    }

    public String toString() {
        return this.im.toString();
    }

    @Override
    public boolean hasRepairCost() {
        return ((Repairable)this.im).hasRepairCost();
    }

    @Override
    public int getRepairCost() {
        return ((Repairable)this.im).getRepairCost();
    }

    @Override
    public void setRepairCost(int cost) {
        ((Repairable)this.im).setRepairCost(cost);
    }

    @Override
    public void addItemFlags(MCItemFlag ... flags) {
        for (MCItemFlag flag : flags) {
            this.im.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag.name())});
        }
    }

    @Override
    public Set<MCItemFlag> getItemFlags() {
        Set flags = this.im.getItemFlags();
        HashSet<MCItemFlag> ret = new HashSet<MCItemFlag>(flags.size());
        for (ItemFlag flag : flags) {
            ret.add(MCItemFlag.valueOf(flag.name()));
        }
        return ret;
    }

    @Override
    public boolean isUnbreakable() {
        return this.im.isUnbreakable();
    }

    @Override
    public void setUnbreakable(boolean unbreakable2) {
        this.im.setUnbreakable(unbreakable2);
    }

    @Override
    public int getDamage() {
        return ((Damageable)this.im).getDamage();
    }

    @Override
    public void setDamage(int damage) {
        ((Damageable)this.im).setDamage(damage);
    }

    @Override
    public boolean hasCustomModelData() {
        return this.im.hasCustomModelData();
    }

    @Override
    public int getCustomModelData() {
        return this.im.getCustomModelData();
    }

    @Override
    public void setCustomModelData(int id) {
        this.im.setCustomModelData(Integer.valueOf(id));
    }
}

