/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCShapelessRecipe;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCRecipe;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;

public class BukkitMCShapelessRecipe
extends BukkitMCRecipe
implements MCShapelessRecipe {
    ShapelessRecipe r;

    public BukkitMCShapelessRecipe(ShapelessRecipe recipe) {
        super((Recipe)recipe);
        this.r = recipe;
    }

    @Override
    public String getKey() {
        return this.r.getKey().getKey();
    }

    @Override
    public MCRecipeType getRecipeType() {
        return MCRecipeType.SHAPELESS;
    }

    @Override
    public Object getHandle() {
        return this.r;
    }

    @Override
    public MCItemStack getResult() {
        return new BukkitMCItemStack(this.r.getResult());
    }

    @Override
    public List<MCItemStack> getIngredients() {
        ArrayList<MCItemStack> ret = new ArrayList<MCItemStack>();
        for (ItemStack is : this.r.getIngredientList()) {
            ret.add(new BukkitMCItemStack(is));
        }
        return ret;
    }

    @Override
    public MCShapelessRecipe addIngredient(MCItemStack ingredient) {
        this.r.addIngredient(ingredient.getAmount(), ((ItemStack)ingredient.getHandle()).getType());
        return this;
    }

    @Override
    public MCShapelessRecipe addIngredient(MCMaterial ingredient) {
        this.r.addIngredient((Material)ingredient.getHandle());
        return this;
    }
}

