/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events.drivers;

import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.events.BukkitEntityEvents;
import com.laytonsmith.abstraction.bukkit.events.BukkitPlayerEvents;
import com.laytonsmith.annotations.EventIdentifier;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class BukkitEntityListener
implements Listener {
    @EventIdentifier(event=Driver.CREATURE_SPAWN, className="org.bukkit.event.entity.CreatureSpawnEvent")
    public void onSpawn(Event event) {
        BukkitEntityEvents.BukkitMCCreatureSpawnEvent cse = new BukkitEntityEvents.BukkitMCCreatureSpawnEvent(event);
        EventUtils.TriggerListener(Driver.CREATURE_SPAWN, "creature_spawn", cse);
    }

    @EventIdentifier(event=Driver.PLAYER_INTERACT_ENTITY, className="org.bukkit.event.player.PlayerInteractEntityEvent")
    public void onClickEnt(Event event) {
        BukkitEntityEvents.BukkitMCPlayerInteractEntityEvent piee = new BukkitEntityEvents.BukkitMCPlayerInteractEntityEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_INTERACT_ENTITY, "player_interact_entity", piee);
    }

    @EventIdentifier(event=Driver.PLAYER_INTERACT_AT_ENTITY, className="org.bukkit.event.player.PlayerInteractAtEntityEvent")
    public void onClickAtEnt(Event event) {
        BukkitEntityEvents.BukkitMCPlayerInteractAtEntityEvent piaee = new BukkitEntityEvents.BukkitMCPlayerInteractAtEntityEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_INTERACT_AT_ENTITY, "player_interact_at_entity", piaee);
    }

    @EventIdentifier(event=Driver.ITEM_DROP, className="org.bukkit.event.player.PlayerDropItemEvent")
    public void onItemDrop(Event event) {
        BukkitEntityEvents.BukkitMCPlayerDropItemEvent pdie = new BukkitEntityEvents.BukkitMCPlayerDropItemEvent(event);
        EventUtils.TriggerListener(Driver.ITEM_DROP, "item_drop", pdie);
    }

    @EventIdentifier(event=Driver.ITEM_PICKUP, className="org.bukkit.event.entity.EntityPickupItemEvent")
    public void onItemPickup(Event event) {
        if (((EntityEvent)event).getEntity() instanceof Player) {
            BukkitEntityEvents.BukkitMCPlayerPickupItemEvent ppie = new BukkitEntityEvents.BukkitMCPlayerPickupItemEvent(event);
            EventUtils.TriggerListener(Driver.ITEM_PICKUP, "item_pickup", ppie);
        }
    }

    @EventIdentifier(event=Driver.ENTITY_DEATH, className="org.bukkit.event.entity.EntityDeathEvent")
    public void onEntityDeath(Event event) {
        BukkitEntityEvents.BukkitMCEntityDeathEvent ede = event instanceof PlayerDeathEvent ? new BukkitPlayerEvents.BukkitMCPlayerDeathEvent(event) : new BukkitEntityEvents.BukkitMCEntityDeathEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_DEATH, "entity_death", ede);
        if (event instanceof PlayerDeathEvent) {
            EventUtils.TriggerListener(Driver.PLAYER_DEATH, "player_death", ede);
        }
    }

    @EventIdentifier(event=Driver.TARGET_ENTITY, className="org.bukkit.event.entity.EntityTargetEvent")
    public void onTargetLiving(Event event) {
        BukkitEntityEvents.BukkitMCTargetEvent ete = new BukkitEntityEvents.BukkitMCTargetEvent(event);
        MCEntity target = ete.getTarget();
        if (target == null || !(target instanceof MCPlayer)) {
            return;
        }
        EventUtils.TriggerListener(Driver.TARGET_ENTITY, "target_player", ete);
    }

    @EventIdentifier(event=Driver.ENTITY_DAMAGE, className="org.bukkit.event.entity.EntityDamageEvent")
    public void onEntityDamage(Event event) {
        if (event instanceof EntityDamageByEntityEvent) {
            BukkitEntityEvents.BukkitMCEntityDamageByEntityEvent ede = new BukkitEntityEvents.BukkitMCEntityDamageByEntityEvent(event);
            EventUtils.TriggerListener(Driver.ENTITY_DAMAGE, "entity_damage", ede);
            if (ede.getEntity() instanceof MCPlayer) {
                EventUtils.TriggerListener(Driver.ENTITY_DAMAGE_PLAYER, "entity_damage_player", ede);
            }
        } else {
            BukkitEntityEvents.BukkitMCEntityDamageEvent ede = new BukkitEntityEvents.BukkitMCEntityDamageEvent(event);
            EventUtils.TriggerListener(Driver.ENTITY_DAMAGE, "entity_damage", ede);
        }
    }

    @EventIdentifier(event=Driver.PROJECTILE_HIT, className="org.bukkit.event.entity.ProjectileHitEvent")
    public void onPHit(Event event) {
        BukkitEntityEvents.BukkitMCProjectileHitEvent phe = new BukkitEntityEvents.BukkitMCProjectileHitEvent(event);
        EventUtils.TriggerListener(Driver.PROJECTILE_HIT, "projectile_hit", phe);
    }

    @EventIdentifier(event=Driver.PROJECTILE_LAUNCH, className="org.bukkit.event.entity.ProjectileLaunchEvent")
    public void onProjectileLaunch(Event event) {
        BukkitEntityEvents.BukkitMCProjectileLaunchEvent ple = new BukkitEntityEvents.BukkitMCProjectileLaunchEvent(event);
        EventUtils.TriggerListener(Driver.PROJECTILE_LAUNCH, "projectile_launch", ple);
    }

    @EventIdentifier(event=Driver.ENTITY_ENTER_PORTAL, className="org.bukkit.event.entity.EntityPortalEnterEvent")
    public void onPortalEnter(Event event) {
        BukkitEntityEvents.BukkitMCEntityEnterPortalEvent pe = new BukkitEntityEvents.BukkitMCEntityEnterPortalEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_ENTER_PORTAL, "entity_enter_portal", pe);
    }

    @EventIdentifier(event=Driver.ENTITY_EXPLODE, className="org.bukkit.event.entity.EntityExplodeEvent")
    public void onExplode(Event event) {
        BukkitEntityEvents.BukkitMCEntityExplodeEvent ee = new BukkitEntityEvents.BukkitMCEntityExplodeEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_EXPLODE, "entity_explode", ee);
    }

    @EventIdentifier(event=Driver.ITEM_DESPAWN, className="org.bukkit.event.entity.ItemDespawnEvent")
    public void onItemDespawn(Event event) {
        BukkitEntityEvents.BukkitMCItemDespawnEvent id = new BukkitEntityEvents.BukkitMCItemDespawnEvent(event);
        EventUtils.TriggerListener(Driver.ITEM_DESPAWN, "item_despawn", id);
    }

    @EventIdentifier(event=Driver.ITEM_SPAWN, className="org.bukkit.event.entity.ItemSpawnEvent")
    public void onItemSpawn(Event event) {
        BukkitEntityEvents.BukkitMCItemSpawnEvent is = new BukkitEntityEvents.BukkitMCItemSpawnEvent(event);
        EventUtils.TriggerListener(Driver.ITEM_SPAWN, "item_spawn", is);
    }

    @EventIdentifier(event=Driver.ENTITY_CHANGE_BLOCK, className="org.bukkit.event.entity.EntityChangeBlockEvent")
    public void onChangeBlock(Event event) {
        BukkitEntityEvents.BukkitMCEntityChangeBlockEvent ecbe = new BukkitEntityEvents.BukkitMCEntityChangeBlockEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_CHANGE_BLOCK, "entity_change_block", ecbe);
    }

    @EventIdentifier(event=Driver.ENTITY_INTERACT, className="org.bukkit.event.entity.EntityInteractEvent")
    public void onInteract(Event event) {
        BukkitEntityEvents.BukkitMCEntityInteractEvent eie = new BukkitEntityEvents.BukkitMCEntityInteractEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_INTERACT, "entity_interact", eie);
    }

    @EventIdentifier(event=Driver.HANGING_BREAK, className="org.bukkit.event.hanging.HangingBreakEvent")
    public void onHangingBreak(Event event) {
        BukkitEntityEvents.BukkitMCHangingBreakEvent hbe = new BukkitEntityEvents.BukkitMCHangingBreakEvent(event);
        EventUtils.TriggerListener(Driver.HANGING_BREAK, "hanging_break", hbe);
    }

    @EventIdentifier(event=Driver.ENTITY_TOGGLE_GLIDE, className="org.bukkit.event.entity.EntityToggleGlideEvent")
    public void onEntityToggleGlide(Event event) {
        BukkitEntityEvents.BukkitMCEntityToggleGlideEvent etge = new BukkitEntityEvents.BukkitMCEntityToggleGlideEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_TOGGLE_GLIDE, "entity_toggle_glide", etge);
    }

    @EventIdentifier(event=Driver.FIREWORK_EXPLODE, className="org.bukkit.event.entity.FireworkExplodeEvent")
    public void onFireworkExplode(Event event) {
        BukkitEntityEvents.BukkitMCFireworkExplodeEvent fee = new BukkitEntityEvents.BukkitMCFireworkExplodeEvent(event);
        EventUtils.TriggerListener(Driver.FIREWORK_EXPLODE, "firework_explode", fee);
    }

    @EventIdentifier(event=Driver.ENTITY_REGAIN_HEALTH, className="org.bukkit.event.entity.EntityRegainHealthEvent")
    public void onRegainHealth(Event event) {
        BukkitEntityEvents.BukkitMCEntityRegainHealthEvent erhe = new BukkitEntityEvents.BukkitMCEntityRegainHealthEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_REGAIN_HEALTH, "entity_regain_health", erhe);
    }

    @EventIdentifier(event=Driver.ENTITY_PORTAL_TRAVEL, className="org.bukkit.event.entity.EntityPortalEvent")
    public void onPortalTravel(Event event) {
        BukkitEntityEvents.BukkitMCEntityPortalEvent epe = new BukkitEntityEvents.BukkitMCEntityPortalEvent(event);
        EventUtils.TriggerListener(Driver.ENTITY_PORTAL_TRAVEL, "entity_portal_travel", epe);
    }
}

