/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events.drivers;

import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.events.BukkitServerEvents;
import com.laytonsmith.abstraction.events.MCRedstoneChangedEvent;
import com.laytonsmith.annotations.EventIdentifier;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.events.drivers.ServerEvents;
import java.util.Map;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.server.ServerListPingEvent;

public class BukkitServerListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPing(ServerListPingEvent event) {
        BukkitServerEvents.BukkitMCServerPingEvent pe = new BukkitServerEvents.BukkitMCServerPingEvent(event);
        EventUtils.TriggerListener(Driver.SERVER_PING, "server_ping", pe);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        boolean isPowered;
        boolean wasPowered;
        Map<MCLocation, Boolean> locations = ServerEvents.getRedstoneMonitors();
        if (locations.isEmpty()) {
            return;
        }
        final BukkitMCLocation blockLocation = new BukkitMCLocation(event.getBlock().getLocation());
        if (locations.containsKey(blockLocation) && (wasPowered = locations.get(blockLocation).booleanValue()) != (isPowered = blockLocation.getBlock().isBlockPowered())) {
            locations.put(blockLocation, isPowered);
            EventUtils.TriggerListener(Driver.REDSTONE_CHANGED, "redstone_changed", new MCRedstoneChangedEvent(){

                @Override
                public boolean isActive() {
                    return isPowered;
                }

                @Override
                public MCLocation getLocation() {
                    return blockLocation;
                }

                @Override
                public Object _GetObject() {
                    return null;
                }
            });
        }
    }

    @EventIdentifier(event=Driver.BROADCAST_MESSAGE, className="org.bukkit.event.server.BroadcastMessageEvent")
    public void onBroadcast(Event event) {
        EventUtils.TriggerListener(Driver.BROADCAST_MESSAGE, "broadcast_message", new BukkitServerEvents.BukkitMCBroadcastMessageEvent(event));
    }
}

