/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events.drivers;

import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.events.BukkitVehicleEvents;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.events.drivers.VehicleEvents;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Animals;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleCollisionEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;

public class BukkitVehicleListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onEnter(VehicleEnterEvent event) {
        BukkitVehicleEvents.BukkitMCVehicleEnterEvent vee = new BukkitVehicleEvents.BukkitMCVehicleEnterEvent(event);
        EventUtils.TriggerListener(Driver.VEHICLE_ENTER, "vehicle_enter", vee);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExit(VehicleExitEvent event) {
        BukkitVehicleEvents.BukkitMCVehicleExitEvent vee = new BukkitVehicleEvents.BukkitMCVehicleExitEvent(event);
        EventUtils.TriggerListener(Driver.VEHICLE_LEAVE, "vehicle_leave", vee);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockCollide(VehicleBlockCollisionEvent event) {
        if (event.getVehicle() instanceof Animals && event.getVehicle().getPassengers().isEmpty()) {
            return;
        }
        BukkitVehicleEvents.BukkitMCVehicleBlockCollideEvent vbc = new BukkitVehicleEvents.BukkitMCVehicleBlockCollideEvent((VehicleCollisionEvent)event);
        EventUtils.TriggerListener(Driver.VEHICLE_COLLIDE, "vehicle_collide", vbc);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityCollide(VehicleEntityCollisionEvent event) {
        List passengers = event.getVehicle().getPassengers();
        if (passengers.isEmpty() || passengers.get(0) != event.getEntity()) {
            BukkitVehicleEvents.BukkitMCVehicleEntityCollideEvent vec = new BukkitVehicleEvents.BukkitMCVehicleEntityCollideEvent((VehicleCollisionEvent)event);
            EventUtils.TriggerListener(Driver.VEHICLE_COLLIDE, "vehicle_collide", vec);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onVehicleMove(VehicleMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        UUID id = event.getVehicle().getUniqueId();
        for (Integer threshold : VehicleEvents.GetThresholdList()) {
            Map<UUID, MCLocation> lastLocations = VehicleEvents.GetLastLocations(threshold);
            if (!lastLocations.containsKey(id)) {
                lastLocations.put(id, new BukkitMCLocation(from));
                continue;
            }
            MCLocation last = lastLocations.get(id);
            if (!to.getWorld().getName().equals(last.getWorld().getName())) {
                lastLocations.put(id, new BukkitMCLocation(to));
                continue;
            }
            BukkitMCLocation movedTo = new BukkitMCLocation(to);
            if (!(last.distance(movedTo) > (double)threshold.intValue())) continue;
            BukkitVehicleEvents.BukkitMCVehicleMoveEvent vme = new BukkitVehicleEvents.BukkitMCVehicleMoveEvent(event, threshold, last);
            EventUtils.TriggerListener(Driver.VEHICLE_MOVE, "vehicle_move", vme);
            if (!vme.isCancelled()) {
                lastLocations.put(id, movedTo);
                continue;
            }
            event.getVehicle().setVelocity(new Vector(0, 0, 0));
            event.getVehicle().teleport(from);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        BukkitVehicleEvents.BukkitMCVehicleDestroyEvent vee = new BukkitVehicleEvents.BukkitMCVehicleDestroyEvent(event);
        EventUtils.TriggerListener(Driver.VEHICLE_DESTROY, "vehicle_destroy", vee);
    }
}

