/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.commandhelper;

import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.bukkit.events.BukkitPlayerEvents;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.commandhelper.BukkitDirtyRegisteredListener;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.AliasCore;
import com.laytonsmith.core.InternalException;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.persistence.DataSourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public class CommandHelperListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("Minecraft");
    private AliasCore ac;
    private final CommandHelperPlugin plugin;

    public CommandHelperListener(CommandHelperPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadGlobalAliases() {
        this.ac = CommandHelperPlugin.getCore();
    }

    public boolean runAlias(String command, MCPlayer player2) throws DataSourceException {
        return CommandHelperPlugin.getCore().alias(command, player2);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (CommandHelperPlugin.self.interpreterListener.isInInterpreterMode(event.getPlayer().getName())) {
            return;
        }
        BukkitPlayerEvents.BukkitMCPlayerCommandEvent mpce = new BukkitPlayerEvents.BukkitMCPlayerCommandEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_COMMAND, "player_command", mpce);
        if (mpce.isCancelled()) {
            return;
        }
        String cmd = event.getMessage();
        BukkitMCPlayer player2 = new BukkitMCPlayer((Entity)event.getPlayer());
        BukkitDirtyRegisteredListener.PlayDirty();
        if (!Prefs.PlayDirty().booleanValue() && event.isCancelled()) {
            return;
        }
        try {
            if (this.runAlias(event.getMessage(), player2)) {
                event.setCancelled(true);
                if (Prefs.PlayDirty().booleanValue()) {
                    BukkitDirtyRegisteredListener.setCancelled((Event)event);
                }
            }
        }
        catch (InternalException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        catch (ConfigRuntimeException e) {
            LOGGER.log(Level.WARNING, e.getMessage());
        }
        catch (Throwable e) {
            player2.sendMessage((Object)((Object)MCChatColor.RED) + "Command failed with following reason: " + e.getMessage());
            event.setCancelled(true);
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Static.HostnameCache(event.getPlayer().getName(), event.getPlayer().getAddress());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLogin(PlayerLoginEvent event) {
        Static.SetPlayerHost(event.getPlayer().getName(), event.getHostname());
    }
}

