/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.Globals;
import com.laytonsmith.core.Installer;
import com.laytonsmith.core.InternalException;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.MethodScriptComplete;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.ProfilesImpl;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.functions.Scheduling;
import com.laytonsmith.core.profiler.ProfilePoint;
import com.laytonsmith.core.profiler.Profiler;
import com.laytonsmith.core.taskmanager.TaskManagerImpl;
import com.laytonsmith.persistence.DataSourceFactory;
import com.laytonsmith.persistence.MemoryDataSource;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class AliasCore {
    private final File aliasConfig;
    private final File auxAliases;
    private final File prefFile;
    private final File mainFile;
    private List<Script> scripts;
    static final Logger LOGGER = Logger.getLogger("Minecraft");
    private final Set<String> echoCommand = new HashSet<String>();
    private CompilerEnvironment compilerEnv;
    public List<File> autoIncludes;
    public static CommandHelperPlugin parent;

    public AliasCore(File aliasConfig, File auxAliases, File prefFile, File mainFile, CommandHelperPlugin parent) {
        this.aliasConfig = aliasConfig;
        this.auxAliases = auxAliases;
        this.prefFile = prefFile;
        AliasCore.parent = parent;
        this.mainFile = mainFile;
    }

    public List<Script> getScripts() {
        return new ArrayList<Script>(this.scripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alias(String command, final MCCommandSender player2) {
        if (this.scripts == null) {
            throw ConfigRuntimeException.CreateUncatchableException("Cannot run alias commands, no config file is loaded", Target.UNKNOWN);
        }
        boolean match = false;
        try {
            if (player2 != null && player2 instanceof MCPlayer && this.echoCommand.contains(((MCPlayer)player2).getName())) {
                return false;
            }
            for (Script s : this.scripts) {
                try {
                    if (!s.match(command)) continue;
                    this.addPlayerReference(player2);
                    if (Prefs.ConsoleLogCommands().booleanValue() && s.doLog()) {
                        StringBuilder b = new StringBuilder("CH: Running original command ");
                        if (player2 instanceof MCPlayer) {
                            b.append("on player ").append(((MCPlayer)player2).getName());
                        } else {
                            b.append("from a MCCommandSender");
                        }
                        b.append(" ----> ").append(command);
                        Static.getLogger().log(Level.INFO, b.toString());
                    }
                    GlobalEnv gEnv = new GlobalEnv(AliasCore.parent.executionQueue, AliasCore.parent.profiler, AliasCore.parent.persistenceNetwork, MethodScriptFileLocations.getDefault().getConfigDirectory(), AliasCore.parent.profiles, new TaskManagerImpl());
                    CommandHelperEnvironment cEnv = new CommandHelperEnvironment();
                    cEnv.SetCommandSender(player2);
                    Environment env = Environment.createEnvironment(gEnv, cEnv, this.compilerEnv);
                    try {
                        env.getEnv(CommandHelperEnvironment.class).SetCommand(command);
                        ProfilePoint alias = env.getEnv(GlobalEnv.class).GetProfiler().start("Global Alias - \"" + command + "\"", LogLevel.ERROR);
                        try {
                            s.run(s.getVariables(command), env, new MethodScriptComplete(){

                                @Override
                                public void done(String output) {
                                    try {
                                        if (output != null && !output.trim().isEmpty() && output.trim().startsWith("/")) {
                                            if (Prefs.DebugMode().booleanValue()) {
                                                if (player2 instanceof MCPlayer) {
                                                    Static.getLogger().log(Level.INFO, "[CommandHelper]: Executing command on " + ((MCPlayer)player2).getName() + ": " + output.trim());
                                                } else {
                                                    Static.getLogger().log(Level.INFO, "[CommandHelper]: Executing command from console equivalent: " + output.trim());
                                                }
                                            }
                                            if (player2 instanceof MCPlayer) {
                                                ((MCPlayer)player2).chat(output.trim());
                                            } else {
                                                Static.getServer().dispatchCommand(player2, output.trim().substring(1));
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        StreamUtils.GetSystemErr().println(e.getMessage());
                                        player2.sendMessage((Object)((Object)MCChatColor.RED) + e.getMessage());
                                    }
                                    finally {
                                        Static.getAliasCore().removePlayerReference(player2);
                                    }
                                }
                            });
                        }
                        finally {
                            alias.stop();
                        }
                    }
                    catch (ConfigRuntimeException ex) {
                        ex.setEnv(env);
                        ConfigRuntimeException.HandleUncaughtException(ex, env);
                    }
                    catch (Throwable e) {
                        StreamUtils.GetSystemErr().println("An unexpected exception occured: " + e.getClass().getSimpleName());
                        player2.sendMessage("An unexpected exception occured: " + (Object)((Object)MCChatColor.RED) + e.getClass().getSimpleName());
                        e.printStackTrace();
                    }
                    finally {
                        Static.getAliasCore().removePlayerReference(player2);
                    }
                    match = true;
                    break;
                }
                catch (Exception e) {
                    StreamUtils.GetSystemErr().println("An unexpected exception occured inside the command " + s.toString());
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            throw new InternalException(TermColors.RED + "An unexpected error occured in the CommandHelper plugin. Further, this is likely an error with the error handler, so it may be caused by your script, however, there is no more information at this point. Check your script, but also report this as a bug in CommandHelper. Also, it's possible that some commands will no longer work. As a temporary workaround, restart the server, and avoid doing whatever it is you did to make this happen.\nThe error is as follows: " + e.toString() + "\n" + TermColors.reset() + "Stack Trace:\n" + StringUtils.Join(Arrays.asList(e.getStackTrace()), "\n"));
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload(MCPlayer player2, String[] settings, boolean firstLoad) {
        block72: {
            ReloadOptions options;
            try {
                options = new ReloadOptions(settings);
            }
            catch (Exception ex) {
                if (player2 != null) {
                    player2.sendMessage(ex.getMessage());
                } else {
                    StreamUtils.GetSystemOut().println(ex.getMessage());
                }
                return;
            }
            try {
                this.compilerEnv = new CompilerEnvironment();
                if (Prefs.AllowDynamicShell().booleanValue()) {
                    MSLog.GetLogger().Log(MSLog.Tags.GENERAL, LogLevel.WARNING, "allow-dynamic-shell is set to true in " + CommandHelperFileLocations.getDefault().getProfilerConfigFile().getName() + " you should set this to false, except during development.", Target.UNKNOWN);
                }
                if (AliasCore.parent.profiler == null || options.reloadProfiler()) {
                    AliasCore.parent.profiler = new Profiler(MethodScriptFileLocations.getDefault().getProfilerConfigFile());
                }
                ProfilePoint extensionPreReload = AliasCore.parent.profiler.start("Extension PreReloadAliases call", LogLevel.VERBOSE);
                try {
                    ExtensionManager.PreReloadAliases(options);
                }
                finally {
                    extensionPreReload.stop();
                }
                ProfilePoint shutdownHooks = AliasCore.parent.profiler.start("Shutdown hooks call", LogLevel.VERBOSE);
                try {
                    StaticLayer.GetConvertor().runShutdownHooks();
                }
                finally {
                    shutdownHooks.stop();
                }
                if (!firstLoad && options.reloadExtensions()) {
                    ProfilePoint extensionManagerShutdown = AliasCore.parent.profiler.start("Extension manager shutdown", LogLevel.VERBOSE);
                    try {
                        ExtensionManager.Shutdown();
                    }
                    finally {
                        extensionManagerShutdown.stop();
                    }
                }
                MSLog.initialize(MethodScriptFileLocations.getDefault().getConfigDirectory());
                DataSourceFactory.DisconnectAll();
                if (options.reloadExtensions()) {
                    ProfilePoint extensionManagerStartup = AliasCore.parent.profiler.start("Extension manager startup", LogLevel.VERBOSE);
                    try {
                        ExtensionManager.Startup();
                    }
                    finally {
                        extensionManagerStartup.stop();
                    }
                }
                MSLog.GetLogger().Log(MSLog.Tags.GENERAL, LogLevel.VERBOSE, "Scripts reloading...", Target.UNKNOWN);
                if (AliasCore.parent.persistenceNetwork == null || options.reloadPersistenceConfig()) {
                    ProfilePoint persistenceConfigReload = AliasCore.parent.profiler.start("Reloading persistence configuration", LogLevel.VERBOSE);
                    try {
                        MemoryDataSource.ClearDatabases();
                        ConnectionMixinFactory.ConnectionMixinOptions mixinOptions = new ConnectionMixinFactory.ConnectionMixinOptions();
                        mixinOptions.setWorkingDirectory(MethodScriptFileLocations.getDefault().getConfigDirectory());
                        AliasCore.parent.persistenceNetwork = new PersistenceNetworkImpl(MethodScriptFileLocations.getDefault().getPersistenceConfig(), new URI("sqlite:/" + MethodScriptFileLocations.getDefault().getDefaultPersistenceDBFile().getCanonicalFile().toURI().getRawSchemeSpecificPart().replace('\\', '/')), mixinOptions);
                    }
                    finally {
                        persistenceConfigReload.stop();
                    }
                }
                try {
                    AliasCore.parent.profiles = new ProfilesImpl(MethodScriptFileLocations.getDefault().getProfilesFile());
                }
                catch (Profiles.InvalidProfileException | IOException ex) {
                    MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, ex.getMessage(), Target.UNKNOWN);
                    return;
                }
                GlobalEnv gEnv = new GlobalEnv(AliasCore.parent.executionQueue, AliasCore.parent.profiler, AliasCore.parent.persistenceNetwork, MethodScriptFileLocations.getDefault().getConfigDirectory(), AliasCore.parent.profiles, new TaskManagerImpl());
                gEnv.SetLabel("*");
                if (options.reloadExecutionQueue()) {
                    ProfilePoint stoppingExecutionQueue = AliasCore.parent.profiler.start("Stopping execution queues", LogLevel.VERBOSE);
                    try {
                        AliasCore.parent.executionQueue.stopAllNow();
                    }
                    finally {
                        stoppingExecutionQueue.stop();
                    }
                }
                CommandHelperEnvironment cEnv = new CommandHelperEnvironment();
                Environment env = Environment.createEnvironment(gEnv, cEnv, this.compilerEnv);
                if (options.reloadGlobals()) {
                    ProfilePoint clearingGlobals = AliasCore.parent.profiler.start("Clearing globals", LogLevel.VERBOSE);
                    try {
                        Globals.clear();
                    }
                    finally {
                        clearingGlobals.stop();
                    }
                }
                if (options.reloadTimeouts()) {
                    ProfilePoint clearingTimeouts = AliasCore.parent.profiler.start("Clearing timeouts/intervals", LogLevel.VERBOSE);
                    try {
                        Scheduling.ClearScheduledRunners();
                    }
                    finally {
                        clearingTimeouts.stop();
                    }
                }
                if (!this.aliasConfig.exists()) {
                    this.aliasConfig.getParentFile().mkdirs();
                    this.aliasConfig.createNewFile();
                    try {
                        String sampAliases = AliasCore.getStringResource(AliasCore.class.getResourceAsStream("/samp_aliases.txt"));
                        sampAliases = sampAliases.replaceAll("\n|\r\n", System.getProperty("line.separator"));
                        AliasCore.file_put_contents(this.aliasConfig, sampAliases, "o");
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "CommandHelper: Could not write sample config file");
                    }
                }
                if (!this.mainFile.exists()) {
                    this.mainFile.getParentFile().mkdirs();
                    this.mainFile.createNewFile();
                    try {
                        String sampMain = AliasCore.getStringResource(AliasCore.class.getResourceAsStream("/samp_main.txt"));
                        sampMain = sampMain.replaceAll("\n|\r\n", System.getProperty("line.separator"));
                        AliasCore.file_put_contents(this.mainFile, sampMain, "o");
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "CommandHelper: Could not write sample main file");
                    }
                }
                if (!Prefs.isInitialized()) {
                    Prefs.init(this.prefFile);
                }
                if (!options.reloadScripts()) break block72;
                ProfilePoint unregisteringEvents = AliasCore.parent.profiler.start("Unregistering events", LogLevel.VERBOSE);
                try {
                    EventUtils.UnregisterAll();
                }
                finally {
                    unregisteringEvents.stop();
                }
                ProfilePoint runningExtensionHooks = AliasCore.parent.profiler.start("Running event hooks", LogLevel.VERBOSE);
                try {
                    ExtensionManager.RunHooks();
                }
                finally {
                    runningExtensionHooks.stop();
                }
                IncludeCache.clearCache();
                Static.getServer().getMessenger().closeAllChannels();
                this.scripts = new ArrayList<Script>();
                LocalPackage localPackages = new LocalPackage();
                String main = AliasCore.file_get_contents(this.mainFile.getAbsolutePath());
                localPackages.appendMS(main, this.mainFile);
                String aliasConfigStr = AliasCore.file_get_contents(this.aliasConfig.getAbsolutePath());
                localPackages.appendMSA(aliasConfigStr, this.aliasConfig);
                File autoInclude = new File(env.getEnv(GlobalEnv.class).GetRootFolder(), "auto_include.ms");
                if (autoInclude.exists()) {
                    localPackages.addAutoInclude(autoInclude);
                }
                AliasCore.GetAuxAliases(this.auxAliases, localPackages);
                this.autoIncludes = localPackages.getAutoIncludes();
                ProfilePoint compilerMS = AliasCore.parent.profiler.start("Compilation of MS files in Local Packages", LogLevel.VERBOSE);
                try {
                    env.getEnv(CommandHelperEnvironment.class).SetCommandSender(Static.getServer().getConsole());
                    MethodScriptCompiler.registerAutoIncludes(env, null);
                    localPackages.compileMS(player2, env);
                }
                finally {
                    env.getEnv(CommandHelperEnvironment.class).SetCommandSender(null);
                    compilerMS.stop();
                }
                ProfilePoint compilerMSA = AliasCore.parent.profiler.start("Compilation of MSA files in Local Packages", LogLevel.VERBOSE);
                try {
                    localPackages.compileMSA(this.scripts, player2);
                }
                finally {
                    compilerMSA.stop();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "[CommandHelper]: Path to config file is not correct/accessable. Please check the location and try loading the plugin again.");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ProfilePoint postReloadAliases = AliasCore.parent.profiler.start("Extension manager post reload aliases", LogLevel.VERBOSE);
        try {
            ExtensionManager.PostReloadAliases();
        }
        finally {
            postReloadAliases.stop();
        }
    }

    public static String file_get_contents(String fileLocation) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileLocation), Charset.forName("UTF-8")));){
            String str;
            while ((str = in.readLine()) != null) {
                ret.append(str).append('\n');
            }
        }
        return ret.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean file_put_contents(File fileLocation, String contents, String mode) throws Exception {
        BufferedWriter out;
        block6: {
            block7: {
                out = null;
                File f = fileLocation;
                if (!f.exists()) break block7;
                if (mode.equalsIgnoreCase("o")) {
                    out = new BufferedWriter(new FileWriter(fileLocation));
                    break block6;
                } else if (mode.equalsIgnoreCase("a")) {
                    out = new BufferedWriter(new FileWriter(fileLocation, true));
                    break block6;
                } else {
                    if (mode.equalsIgnoreCase("c")) {
                        return false;
                    }
                    throw new RuntimeException("Undefined mode in file_put_contents: " + mode);
                }
            }
            out = new BufferedWriter(new FileWriter(fileLocation));
        }
        if (out != null) {
            out.write(contents);
            out.close();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringResource(InputStream is) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return ((Object)writer).toString();
    }

    public void removePlayerReference(MCCommandSender p2) {
        if (p2 instanceof MCPlayer) {
            this.echoCommand.remove(((MCPlayer)p2).getName());
        }
    }

    public void addPlayerReference(MCCommandSender p2) {
        if (p2 instanceof MCPlayer) {
            this.echoCommand.add(((MCPlayer)p2).getName());
        }
    }

    public boolean hasPlayerReference(MCCommandSender p2) {
        if (p2 instanceof MCPlayer) {
            return this.echoCommand.contains(((MCPlayer)p2).getName());
        }
        return false;
    }

    public static void GetAuxAliases(File start, LocalPackage pack) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        if (!start.isDirectory() || start.getName().endsWith(".disabled") || start.getName().endsWith(".library")) break block10;
                        for (File f : start.listFiles()) {
                            AliasCore.GetAuxAliases(f, pack);
                        }
                        break block11;
                    }
                    if (!start.isFile()) break block11;
                    if (!start.getName().endsWith(".msa")) break block12;
                    try {
                        pack.appendMSA(AliasCore.file_get_contents(start.getAbsolutePath()), start);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block11;
                }
                if (!start.getName().endsWith(".ms")) break block13;
                if (start.getName().equals("auto_include.ms")) {
                    pack.addAutoInclude(start);
                } else {
                    try {
                        pack.appendMS(AliasCore.file_get_contents(start.getAbsolutePath()), start);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                break block11;
            }
            if (!start.getName().endsWith(".mslp")) break block11;
            try {
                AliasCore.GetAuxZipAliases(new ZipFile(start), pack);
            }
            catch (ZipException ex) {
                Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void GetAuxZipAliases(ZipFile file, LocalPackage pack) {
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (ze.getName().endsWith(".ms")) {
                if (ze.getName().equals("auto_include.ms")) {
                    pack.addAutoInclude(new File(file.getName() + File.separator + ze.getName()));
                    continue;
                }
                try {
                    pack.appendMS(Installer.parseISToString(file.getInputStream(ze)), new File(file.getName() + File.separator + ze.getName()));
                }
                catch (IOException ex) {
                    Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (!ze.getName().endsWith(".msa")) continue;
            try {
                pack.appendMSA(Installer.parseISToString(file.getInputStream(ze)), new File(file.getName() + File.separator + ze.getName()));
            }
            catch (IOException ex) {
                Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static class LocalPackage {
        private final List<File> autoIncludes = new ArrayList<File>();
        private final List<FileInfo> ms = new ArrayList<FileInfo>();
        private final List<FileInfo> msa = new ArrayList<FileInfo>();

        public List<FileInfo> getMSFiles() {
            return new ArrayList<FileInfo>(this.ms);
        }

        public List<FileInfo> getMSAFiles() {
            return new ArrayList<FileInfo>(this.msa);
        }

        private List<File> getAutoIncludes() {
            return this.autoIncludes;
        }

        private void addAutoInclude(File f) {
            this.autoIncludes.add(f);
        }

        public void appendMSA(String s, File path) {
            this.msa.add(new FileInfo(s, path));
        }

        public void appendMS(String s, File path) {
            this.ms.add(new FileInfo(s, path));
        }

        public void compileMSA(List<Script> scripts, MCPlayer player2) {
            for (FileInfo fi : this.msa) {
                try {
                    List<Script> tempScripts = MethodScriptCompiler.preprocess(MethodScriptCompiler.lex(fi.contents, fi.file, false));
                    for (Script s : tempScripts) {
                        try {
                            try {
                                s.compile();
                                s.checkAmbiguous((ArrayList)scripts);
                                scripts.add(s);
                            }
                            catch (ConfigCompileException e) {
                                ConfigRuntimeException.HandleUncaughtException(e, "Compile error in script. Compilation will attempt to continue, however.", player2);
                            }
                            catch (ConfigCompileGroupException ex) {
                                for (ConfigCompileException e : ex.getList()) {
                                    ConfigRuntimeException.HandleUncaughtException(e, "Compile error in script. Compilation will attempt to continue, however.", player2);
                                }
                            }
                        }
                        catch (RuntimeException ee) {
                            throw new RuntimeException("While processing a script, (" + fi.file() + ") an unexpected exception occurred. (No further information is available, unfortunately.)", ee);
                        }
                    }
                }
                catch (ConfigCompileException e) {
                    ConfigRuntimeException.HandleUncaughtException(e, "Could not compile file " + fi.file + " compilation will halt.", player2);
                    return;
                }
            }
            int errors = 0;
            for (Script s : scripts) {
                if (!s.compilerError) continue;
                ++errors;
            }
            if (errors > 0) {
                StreamUtils.GetSystemOut().println(TermColors.YELLOW + "[CommandHelper]: " + (scripts.size() - errors) + " alias(es) defined, " + TermColors.RED + "with " + errors + " aliases with compile errors." + TermColors.reset());
                if (player2 != null) {
                    player2.sendMessage((Object)((Object)MCChatColor.YELLOW) + "[CommandHelper]: " + (scripts.size() - errors) + " alias(es) defined, " + (Object)((Object)MCChatColor.RED) + "with " + errors + " aliases with compile errors.");
                }
            } else {
                StreamUtils.GetSystemOut().println(TermColors.YELLOW + "[CommandHelper]: " + scripts.size() + " alias(es) defined." + TermColors.reset());
                if (player2 != null) {
                    player2.sendMessage((Object)((Object)MCChatColor.YELLOW) + "[CommandHelper]: " + scripts.size() + " alias(es) defined.");
                }
            }
        }

        public void compileMS(MCPlayer player2, Environment env) {
            for (FileInfo fi : this.ms) {
                boolean exception = false;
                try {
                    MethodScriptCompiler.execute(MethodScriptCompiler.compile(MethodScriptCompiler.lex(fi.contents, fi.file, true), env), env, null, null);
                }
                catch (ConfigCompileGroupException e) {
                    exception = true;
                    ConfigRuntimeException.HandleUncaughtException(e, fi.file.getAbsolutePath() + " could not be compiled, due to compile errors.", player2);
                }
                catch (ConfigCompileException e) {
                    exception = true;
                    ConfigRuntimeException.HandleUncaughtException(e, fi.file.getAbsolutePath() + " could not be compiled, due to a compile error.", player2);
                }
                catch (ConfigRuntimeException e) {
                    exception = true;
                    ConfigRuntimeException.HandleUncaughtException(e, env);
                }
                catch (CancelCommandException e) {
                    if (e.getMessage() != null && !"".equals(e.getMessage().trim())) {
                        LOGGER.log(Level.INFO, e.getMessage());
                    }
                }
                catch (ProgramFlowManipulationException e) {
                    exception = true;
                    ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("Cannot break program flow in main files.", e.getTarget()), env);
                }
                if (!exception || !Prefs.HaltOnFailure().booleanValue()) continue;
                LOGGER.log(Level.SEVERE, TermColors.RED + "[CommandHelper]: Compilation halted due to unrecoverable failure." + TermColors.reset());
                return;
            }
            LOGGER.log(Level.INFO, TermColors.YELLOW + "[CommandHelper]: MethodScript files processed" + TermColors.reset());
            if (player2 != null) {
                player2.sendMessage((Object)((Object)MCChatColor.YELLOW) + "[CommandHelper]: MethodScript files processed");
            }
        }

        public static final class FileInfo {
            String contents;
            File file;

            private FileInfo(String contents, File file) {
                this.contents = contents;
                this.file = file;
            }

            public String contents() {
                return this.contents;
            }

            public File file() {
                return this.file;
            }
        }
    }

    public class ReloadOptions {
        boolean globals = true;
        boolean timeouts = true;
        boolean executionQueue = true;
        boolean persistenceConfig = true;
        boolean profiler = true;
        boolean scripts = true;
        boolean extensions = true;
        private final ArgumentParser options = ArgumentParser.GetParser().addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the list of arguments to be a whitelist, that is, only the specified modules get reloaded, the rest will be skipped. Without this option, the specified modules don't get reloaded.").asFlag().setName("whitelist")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that globals memory (values stored with export/import) should be preserved.").asFlag().setName('g', "globals")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that tasks registered with set_interval/set_timeout should be preserved.").asFlag().setName('t', "tasks")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that tasks registered in execution queues should be preserved.").asFlag().setName('e', "execution-queue")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that the persistence config file should not be reloaded.").asFlag().setName('r', "persistence-config")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that the profiler config should not be reloaded.").asFlag().setName('f', "profiler")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that scripts should not be reloaded.").asFlag().setName('s', "scripts")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that extensions should not be reloaded.").asFlag().setName('x', "extensions")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Prints this list and returns. Nothing is reloaded if this option is set.").asFlag().setName('h', "help"));

        public ReloadOptions(String[] settings) throws ArgumentParser.ValidationException {
            if (settings != null) {
                ArgumentParser.ArgumentParserResults results = this.options.match(settings);
                if (results.isFlagSet(Character.valueOf('h'))) {
                    throw new CancelCommandException(this.options.getBuiltDescription(), Target.UNKNOWN);
                }
                if (results.isFlagSet("whitelist")) {
                    this.globals = false;
                    this.timeouts = false;
                    this.executionQueue = false;
                    this.persistenceConfig = false;
                    this.profiler = false;
                    this.scripts = false;
                    this.extensions = false;
                }
                if (results.isFlagSet(Character.valueOf('g'))) {
                    boolean bl = this.globals = !this.globals;
                }
                if (results.isFlagSet(Character.valueOf('t'))) {
                    boolean bl = this.timeouts = !this.timeouts;
                }
                if (results.isFlagSet(Character.valueOf('e'))) {
                    boolean bl = this.executionQueue = !this.executionQueue;
                }
                if (results.isFlagSet(Character.valueOf('r')) || results.isFlagSet("persistence-config")) {
                    boolean bl = this.persistenceConfig = !this.persistenceConfig;
                }
                if (results.isFlagSet(Character.valueOf('f'))) {
                    boolean bl = this.profiler = !this.profiler;
                }
                if (results.isFlagSet(Character.valueOf('s'))) {
                    boolean bl = this.scripts = !this.scripts;
                }
                if (results.isFlagSet(Character.valueOf('x'))) {
                    this.extensions = !this.extensions;
                }
            }
        }

        public boolean reloadGlobals() {
            return this.globals;
        }

        public boolean reloadTimeouts() {
            return this.timeouts;
        }

        public boolean reloadExecutionQueue() {
            return this.executionQueue;
        }

        public boolean reloadPersistenceConfig() {
            return this.persistenceConfig;
        }

        public boolean reloadProfiler() {
            return this.profiler;
        }

        public boolean reloadScripts() {
            return this.scripts;
        }

        public boolean reloadExtensions() {
            return this.extensions;
        }
    }
}

