/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.ArgumentSuite;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryCache;
import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.RSAEncrypt;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Common.UIUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.XMLDocument;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.AbstractCommandLineTool;
import com.laytonsmith.core.CommandLineTool;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Security;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.OptimizationUtilities;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.functions.Meta;
import com.laytonsmith.core.functions.Scheduling;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.tool;
import com.laytonsmith.persistence.PersistenceNetwork;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import com.laytonsmith.tools.ExampleLocalPackageInstaller;
import com.laytonsmith.tools.Interpreter;
import com.laytonsmith.tools.MSLPMaker;
import com.laytonsmith.tools.Manager;
import com.laytonsmith.tools.ProfilerSummary;
import com.laytonsmith.tools.SyntaxHighlighters;
import com.laytonsmith.tools.UILauncher;
import com.laytonsmith.tools.docgen.DocGen;
import com.laytonsmith.tools.docgen.DocGenExportTool;
import com.laytonsmith.tools.docgen.ExtensionDocGen;
import com.laytonsmith.tools.docgen.sitedeploy.APIBuilder;
import com.laytonsmith.tools.docgen.sitedeploy.SiteDeploy;
import com.laytonsmith.tools.pnviewer.PNViewer;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import org.fusesource.jansi.AnsiConsole;
import org.json.simple.JSONValue;

public class Main {
    public static final ArgumentSuite ARGUMENT_SUITE;
    private static final ArgumentParser HELP_MODE;
    private static final ArgumentParser PRINT_DB_MODE;
    private static final ArgumentParser DOCS_MODE;
    private static final ArgumentParser VERIFY_MODE;
    private static final ArgumentParser UNINSTALL_CMDLINE_MODE;
    private static final ArgumentParser SYNTAX_MODE;
    private static final ArgumentParser DOCGEN_MODE;
    private static final ArgumentParser API_MODE;
    private static final ArgumentParser EXAMPLES_MODE;
    private static final ArgumentParser OPTIMIZER_TEST_MODE;
    private static final ArgumentParser CMDLINE_MODE;
    private static final ArgumentParser EXTENSION_DOCS_MODE;
    private static final ArgumentParser DOC_EXPORT_MODE;
    private static final ArgumentParser PROFILER_SUMMARY_MODE;
    private static final ArgumentParser RSA_KEY_GEN_MODE;
    private static final ArgumentParser PM_VIEWER_MODE;
    private static final ArgumentParser CORE_FUNCTIONS_MODE;
    private static final ArgumentParser UI_MODE;
    private static final ArgumentParser SITE_DEPLOY;
    private static final ArgumentParser EXTENSION_BUILDER_MODE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        block102: {
            try {
                File extensionDir;
                ArgumentParser.ArgumentParserResults parsedArgs;
                ArgumentParser mode;
                ClassDiscovery cd2 = ClassDiscovery.getDefaultInstance();
                cd2.addDiscoveryLocation(ClassDiscovery.GetClassContainer(Main.class));
                ClassDiscoveryCache cdcCache = new ClassDiscoveryCache(MethodScriptFileLocations.getDefault().getCacheDirectory());
                cd2.setClassDiscoveryCache(cdcCache);
                MSLog.initialize(MethodScriptFileLocations.getDefault().getJarDirectory());
                Prefs.init(MethodScriptFileLocations.getDefault().getPreferencesFile());
                Prefs.SetColors();
                if (Prefs.UseColors().booleanValue()) {
                    AnsiConsole.systemInstall();
                }
                cd2.addAllJarsInFolder(MethodScriptFileLocations.getDefault().getExtensionsDirectory());
                ExtensionManager.AddDiscoveryLocation(MethodScriptFileLocations.getDefault().getExtensionsDirectory());
                ExtensionManager.Cache(MethodScriptFileLocations.getDefault().getExtensionCacheDirectory(), new Class[0]);
                ExtensionManager.Initialize(cd2);
                ExtensionManager.Startup();
                if (args.length == 0) {
                    args = new String[]{"help"};
                }
                HashMap<ArgumentParser, CommandLineTool> dynamicTools = new HashMap<ArgumentParser, CommandLineTool>();
                for (Class<CommandLineTool> clazz : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(tool.class, CommandLineTool.class)) {
                    CommandLineTool tool2 = clazz.newInstance();
                    ArgumentParser ap = tool2.getArgumentParser();
                    String string = clazz.getAnnotation(tool.class).value();
                    ARGUMENT_SUITE.addMode(string, ap);
                    String[] aliases = clazz.getAnnotation(tool.class).aliases();
                    if (aliases != null) {
                        for (String alias : aliases) {
                            ARGUMENT_SUITE.addModeAlias(alias, string);
                        }
                    }
                    dynamicTools.put(ap, tool2);
                }
                try {
                    ArgumentSuite.ArgumentSuiteResults results = ARGUMENT_SUITE.match(args, "help");
                    mode = results.getMode();
                    parsedArgs = results.getResults();
                }
                catch (ArgumentParser.ResultUseException | ArgumentParser.ValidationException e) {
                    StreamUtils.GetSystemOut().println(TermColors.RED + e.getMessage() + TermColors.RESET);
                    mode = HELP_MODE;
                    parsedArgs = null;
                }
                if (mode == HELP_MODE) {
                    String modeForHelp = null;
                    if (parsedArgs != null) {
                        modeForHelp = parsedArgs.getStringArgument();
                    }
                    if ((modeForHelp = ARGUMENT_SUITE.getModeFromAlias(modeForHelp)) == null) {
                        StreamUtils.GetSystemOut().println(ARGUMENT_SUITE.getBuiltDescription());
                        System.exit(0);
                        return;
                    }
                    StreamUtils.GetSystemOut().println(ARGUMENT_SUITE.getModeFromName(modeForHelp).getBuiltDescription());
                    return;
                }
                assert (parsedArgs != null);
                if (mode == CORE_FUNCTIONS_MODE) {
                    ArrayList<String> core2 = new ArrayList<String>();
                    for (api.Platforms platforms : api.Platforms.values()) {
                        for (FunctionBase f : FunctionList.getFunctionList(platforms)) {
                            if (!f.isCore()) continue;
                            core2.add(f.getName());
                        }
                    }
                    Collections.sort(core2);
                    StreamUtils.GetSystemOut().println(StringUtils.Join(core2, ", "));
                    System.exit(0);
                    break block102;
                }
                if (mode == UNINSTALL_CMDLINE_MODE) {
                    Interpreter.uninstall();
                    System.exit(0);
                    break block102;
                }
                if (mode == PRINT_DB_MODE) {
                    ConnectionMixinFactory.ConnectionMixinOptions options = new ConnectionMixinFactory.ConnectionMixinOptions();
                    options.setWorkingDirectory(MethodScriptFileLocations.getDefault().getConfigDirectory());
                    PersistenceNetworkImpl persistenceNetworkImpl = new PersistenceNetworkImpl(MethodScriptFileLocations.getDefault().getPersistenceConfig(), new URI("sqlite://" + MethodScriptFileLocations.getDefault().getDefaultPersistenceDBFile().getCanonicalPath().replace('\\', '/')), options);
                    Map<String[], String> values = persistenceNetworkImpl.getNamespace(new String[0]);
                    for (Object[] objectArray : values.keySet()) {
                        StreamUtils.GetSystemOut().println(StringUtils.Join(objectArray, ".") + "=" + values.get(objectArray));
                    }
                    System.exit(0);
                    break block102;
                }
                if (mode == DOCS_MODE) {
                    DocGen.MarkupType docs;
                    try {
                        docs = DocGen.MarkupType.valueOf(parsedArgs.getStringArgument().toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        StreamUtils.GetSystemOut().println("The type of documentation must be one of the following: " + StringUtils.Join((Object[])DocGen.MarkupType.values(), ", ", ", or "));
                        System.exit(1);
                        return;
                    }
                    StreamUtils.GetSystemErr().print("Creating " + (Object)((Object)docs) + " documentation...");
                    StreamUtils.GetSystemOut().println(DocGen.functions(docs, api.Platforms.INTERPRETER_JAVA, true));
                    StreamUtils.GetSystemErr().println("Done.");
                    System.exit(0);
                    break block102;
                }
                if (mode == EXAMPLES_MODE) {
                    ExampleLocalPackageInstaller.run(MethodScriptFileLocations.getDefault().getJarDirectory(), parsedArgs.getStringArgument());
                    break block102;
                }
                if (mode == VERIFY_MODE) {
                    String file = parsedArgs.getStringArgument();
                    if ("".equals(file)) {
                        StreamUtils.GetSystemErr().println("File parameter is required.");
                        System.exit(1);
                    }
                    File file2 = new File(file);
                    String script = FileUtil.read(file2);
                    try {
                        try {
                            MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, file2, file.endsWith("ms")), null);
                            break block102;
                        }
                        catch (ConfigCompileException ex) {
                            HashSet<ConfigCompileException> hashSet = new HashSet<ConfigCompileException>(1);
                            hashSet.add(ex);
                            throw new ConfigCompileGroupException(hashSet);
                        }
                    }
                    catch (ConfigCompileGroupException ex) {
                        ArrayList arrayList = new ArrayList();
                        for (ConfigCompileException e : ex.getList()) {
                            HashMap<String, Object> error = new HashMap<String, Object>();
                            error.put("msg", e.getMessage());
                            error.put("file", e.getFile().getAbsolutePath());
                            error.put("line", e.getLineNum());
                            error.put("col", e.getColumn());
                            error.put("len", 0);
                            arrayList.add(error);
                        }
                        String serr = JSONValue.toJSONString(arrayList);
                        StreamUtils.GetSystemOut().println(serr);
                    }
                    break block102;
                }
                if (mode == API_MODE) {
                    String function = parsedArgs.getStringArgument();
                    boolean bl = parsedArgs.isFlagSet(Character.valueOf('e'));
                    if ("".equals(function)) {
                        StreamUtils.GetSystemErr().println("Usage: java -jar CommandHelper.jar api <function name>");
                        System.exit(1);
                    }
                    ArrayList<FunctionBase> fl = new ArrayList<FunctionBase>();
                    for (FunctionBase functionBase : FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA)) {
                        if (!functionBase.getName().matches("^" + function + "$")) continue;
                        fl.add(functionBase);
                    }
                    if (fl.isEmpty()) {
                        StreamUtils.GetSystemErr().println("The function '" + function + "' was not found.");
                        System.exit(1);
                    } else if (fl.size() == 1) {
                        FunctionBase f = (FunctionBase)fl.get(0);
                        if (parsedArgs.isFlagSet("online")) {
                            String string = String.format("https://methodscript.com/docs/%s/API/functions/%s", MSVersion.LATEST.toString(), f.getName());
                            System.out.println("Launching browser to " + string);
                            if (!UIUtils.openWebpage(new URL(string))) {
                                System.err.println("Could not launch browser");
                            }
                        } else {
                            StreamUtils.GetSystemOut().println(Interpreter.formatDocsForCmdline(f.getName(), bl));
                        }
                    } else {
                        StreamUtils.GetSystemOut().println("Multiple function matches found:");
                        for (FunctionBase functionBase : fl) {
                            StreamUtils.GetSystemOut().println(functionBase.getName());
                        }
                    }
                    System.exit(0);
                    break block102;
                }
                if (mode == SYNTAX_MODE) {
                    List<String> syntax = parsedArgs.getStringListArgument();
                    String string = syntax.size() >= 1 ? syntax.get(0) : null;
                    String theme = syntax.size() >= 2 ? syntax.get(1) : null;
                    StreamUtils.GetSystemOut().println(SyntaxHighlighters.generate(string, theme));
                    System.exit(0);
                    break block102;
                }
                if (mode == OPTIMIZER_TEST_MODE) {
                    String optimized;
                    String path = parsedArgs.getStringArgument();
                    File file = new File(path);
                    String plain = FileUtil.read(file);
                    Security.setSecurityEnabled(false);
                    try {
                        try {
                            optimized = OptimizationUtilities.optimize(plain, file);
                        }
                        catch (ConfigCompileException configCompileException) {
                            HashSet<ConfigCompileException> group = new HashSet<ConfigCompileException>();
                            group.add(configCompileException);
                            throw new ConfigCompileGroupException(group);
                        }
                    }
                    catch (ConfigCompileGroupException configCompileGroupException) {
                        ConfigRuntimeException.HandleUncaughtException(configCompileGroupException, null);
                        System.exit(1);
                        return;
                    }
                    StreamUtils.GetSystemOut().println(optimized);
                    System.exit(0);
                    break block102;
                }
                if (mode == CMDLINE_MODE) {
                    ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(args));
                    allArgs.remove(0);
                    if (allArgs.isEmpty()) {
                        StreamUtils.GetSystemErr().println("Usage: path/to/file.ms [arg1 arg2]");
                        System.exit(1);
                    }
                    String string = (String)allArgs.get(0);
                    allArgs.remove(0);
                    try {
                        Interpreter.startWithTTY(string, allArgs);
                    }
                    catch (Profiles.InvalidProfileException ex) {
                        StreamUtils.GetSystemErr().println("Invalid profile file at " + MethodScriptFileLocations.getDefault().getProfilesFile() + ": " + ex.getMessage());
                        System.exit(1);
                    }
                    StaticLayer.GetConvertor().runShutdownHooks();
                    System.exit(0);
                    break block102;
                }
                if (mode == EXTENSION_DOCS_MODE) {
                    String inputJarS = parsedArgs.getStringArgument("input-jar");
                    String string = parsedArgs.getStringArgument("output-file");
                    if (inputJarS == null) {
                        StreamUtils.GetSystemOut().println("Usage: --input-jar extension-docs path/to/extension.jar [--output-file path/to/output.md]\n\tIf the output is blank, it is printed to stdout.");
                        System.exit(1);
                    }
                    File inputJar = new File(inputJarS);
                    OutputStream outputFile = StreamUtils.GetSystemOut();
                    if (string != null) {
                        outputFile = new FileOutputStream(new File(string));
                    }
                    ExtensionDocGen.generate(inputJar, outputFile);
                    break block102;
                }
                if (mode == DOC_EXPORT_MODE) {
                    String extensionDirS = parsedArgs.getStringArgument("extension-dir");
                    String string = parsedArgs.getStringArgument("output-file");
                    OutputStream outputFile = StreamUtils.GetSystemOut();
                    if (string != null) {
                        outputFile = new FileOutputStream(new File(string));
                    }
                    Implementation.forceServerType(Implementation.Type.BUKKIT);
                    extensionDir = new File(extensionDirS);
                    if (extensionDir.exists()) {
                        for (File f : extensionDir.listFiles()) {
                            if (!f.getName().endsWith(".jar")) continue;
                            cd2.addDiscoveryLocation(f.toURI().toURL());
                        }
                    } else {
                        StreamUtils.GetSystemErr().println("Extension directory specificed doesn't exist: " + extensionDirS + ". Continuing anyways.");
                    }
                    new DocGenExportTool(cd2, outputFile).export();
                    break block102;
                }
                if (mode == PROFILER_SUMMARY_MODE) {
                    String input = parsedArgs.getStringArgument();
                    if ("".equals(input)) {
                        StreamUtils.GetSystemErr().println(TermColors.RED + "No input file specified! Run `help profiler-summary' for usage." + TermColors.RESET);
                        System.exit(1);
                    }
                    double d = parsedArgs.getNumberArgument("ignore-percentage");
                    ProfilerSummary summary = new ProfilerSummary(new FileInputStream(input));
                    try {
                        summary.setIgnorePercentage(d);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        StreamUtils.GetSystemErr().println(TermColors.RED + illegalArgumentException.getMessage() + TermColors.RESET);
                        System.exit(1);
                    }
                    StreamUtils.GetSystemOut().println(summary.getAnalysis());
                    System.exit(0);
                    break block102;
                }
                if (mode == RSA_KEY_GEN_MODE) {
                    String outputFileString = parsedArgs.getStringArgument(Character.valueOf('o'));
                    File file = new File(outputFileString);
                    File pubOutputFile = new File(outputFileString + ".pub");
                    String label = parsedArgs.getStringArgument(Character.valueOf('l'));
                    if (file.exists() || pubOutputFile.exists()) {
                        StreamUtils.GetSystemErr().println("Either the public key or private key file already exists. This utility will not overwrite any existing files.");
                        System.exit(1);
                    }
                    RSAEncrypt rSAEncrypt = RSAEncrypt.generateKey(label);
                    FileUtil.write(rSAEncrypt.getPrivateKey(), file);
                    FileUtil.write(rSAEncrypt.getPublicKey(), pubOutputFile);
                    System.exit(0);
                    break block102;
                }
                if (mode == PM_VIEWER_MODE) {
                    if (parsedArgs.isFlagSet("server")) {
                        void var7_26;
                        String string;
                        int port;
                        if (parsedArgs.getNumberArgument("port") == null) {
                            StreamUtils.GetSystemErr().println("When running as a server, port is required.");
                            System.exit(1);
                        }
                        if ((port = parsedArgs.getNumberArgument("port").intValue()) > 65535 || port < 1) {
                            StreamUtils.GetSystemErr().println("Port must be between 1 and 65535.");
                            System.exit(1);
                        }
                        if ("".equals(string = parsedArgs.getStringArgument("password"))) {
                            try (ConsoleReader reader = null;){
                                reader = new ConsoleReader();
                                reader.setExpandEvents(false);
                                Character cha = new Character('\u0000');
                                String string2 = reader.readLine("Enter password: ", cha);
                            }
                        }
                        if (var7_26 == null) {
                            StreamUtils.GetSystemErr().println("Warning! Running server with no password, anyone will be able to connect!");
                            String string3 = "";
                        }
                        try {
                            void var7_28;
                            PNViewer.startServer(port, (String)var7_28);
                        }
                        catch (IOException ex) {
                            StreamUtils.GetSystemErr().println(ex.getMessage());
                            System.exit(1);
                        }
                        break block102;
                    }
                    try {
                        PNViewer.main(parsedArgs.getStringListArgument().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
                    }
                    catch (HeadlessException ex) {
                        StreamUtils.GetSystemErr().println("The Persistence Network Viewer may not be run from a headless environment.");
                        System.exit(1);
                    }
                    break block102;
                }
                if (mode == UI_MODE) {
                    if (parsedArgs.isFlagSet("in-shell")) {
                        UILauncher.main(args);
                    } else {
                        void var7_31;
                        ArrayList<Object> largs = new ArrayList<Object>();
                        largs.add("java");
                        largs.add("-jar");
                        String string = ClassDiscovery.GetClassContainer(Main.class).getPath();
                        if (OSUtils.GetOS().isWindows() && string.startsWith("/")) {
                            String string4 = string.substring(1);
                        }
                        largs.add(var7_31);
                        largs.addAll(Arrays.asList(args));
                        largs.add("--in-shell");
                        CommandExecutor ce = new CommandExecutor(largs.toArray(new String[largs.size()]));
                        ce.start();
                        System.exit(0);
                    }
                    break block102;
                }
                if (mode == SITE_DEPLOY) {
                    boolean clearLocalCache = parsedArgs.isFlagSet("clear-local-cache");
                    if (clearLocalCache) {
                        PersistenceNetwork persistenceNetwork = SiteDeploy.getPersistenceNetwork();
                        if (persistenceNetwork == null) {
                            System.out.println("Cannot get reference to persistence network");
                            System.exit(1);
                            return;
                        }
                        DaemonManager dm = new DaemonManager();
                        persistenceNetwork.clearKey(dm, new String[]{"site_deploy", "local_cache"});
                        dm.waitForThreads();
                        System.out.println("Local cache cleared");
                        System.exit(0);
                    }
                    boolean bl = parsedArgs.isFlagSet("generate-prefs");
                    boolean useLocalCache = parsedArgs.isFlagSet("use-local-cache");
                    boolean doValidation = parsedArgs.isFlagSet("do-validation");
                    boolean bl2 = parsedArgs.isFlagSet("no-progress-clear");
                    String configString = parsedArgs.getStringArgument("config");
                    if ("".equals(configString)) {
                        System.err.println("Config file missing, check command and try again");
                        System.exit(1);
                    }
                    File config = new File(configString);
                    SiteDeploy.run(bl, useLocalCache, config, "", doValidation, !bl2);
                    break block102;
                }
                if (mode == EXTENSION_BUILDER_MODE) {
                    try {
                        new CommandExecutor("git --version").start().waitFor();
                        new CommandExecutor("mvn --version").start().waitFor();
                    }
                    catch (IOException e) {
                        System.err.println("Git and Maven are required (and Maven requires the JDK). These three components must be already installed to use this tool.");
                        System.exit(1);
                    }
                    String branch = parsedArgs.getStringArgument("branch");
                    String string = parsedArgs.getStringArgument("source");
                    boolean force = parsedArgs.isFlagSet("force");
                    extensionDir = new File(parsedArgs.getStringArgument("extension-dir"));
                    File file = new File(MethodScriptFileLocations.getDefault().getTempDir(), string.replaceAll("^.*/(.*?)(?:.git)*?$", "$1"));
                    System.out.println("Cloning " + string);
                    System.out.println("Using branch " + branch);
                    System.out.println("Checkout path is " + file);
                    System.out.println("Deploying to " + extensionDir);
                    System.out.println("------------------------------------------------");
                    if (!extensionDir.exists()) {
                        if (force) {
                            extensionDir.mkdirs();
                        } else {
                            System.err.println("Extension directory does not exist, refusing to continue. If " + extensionDir.getAbsolutePath() + " is the correct directory, manually create it and try again, or use --force.");
                            System.exit(1);
                        }
                    }
                    try {
                        if (file.exists()) {
                            if (!force) {
                                System.err.println("Checkout path already exists (" + file.getAbsolutePath() + "), refusing to continue.");
                                System.exit(1);
                            } else {
                                System.out.println("Deleting " + file + " directory...");
                                if (!FileUtil.recursiveDelete(file)) {
                                    System.err.println("Could not fully delete checkout path, refusing to continue. Please manually delete " + file + ", and try again.");
                                    System.exit(1);
                                }
                            }
                        }
                        new CommandExecutor(new String[]{"git", "clone", "--single-branch", "--branch", branch, "--depth=1", string, file.getAbsolutePath()}).setSystemInputsAndOutputs().start().waitFor();
                        System.out.println("Building extension...");
                        int mvnBuild = new CommandExecutor(new String[]{"mvn", "package", "-DskipTests"}).setSystemInputsAndOutputs().setWorkingDir(file).start().waitFor();
                        if (mvnBuild != 0) {
                            System.err.println("Something went wrong in the maven build, unable to continue. Please correct the listed error, and then try again.");
                            System.err.flush();
                            System.exit(1);
                        }
                        System.out.println("Extension built, moving artifact to extension directory...");
                        XMLDocument pom = new XMLDocument(new FileInputStream(new File(file, "pom.xml")));
                        String artifactId = pom.getNode("/project/artifactId");
                        String version = pom.getNode("/project/version");
                        String artifactName = artifactId + "-" + version + ".jar";
                        System.out.println("Identified " + artifactName + " as the artifact to use");
                        FileUtil.copy(new File(file, "target/" + artifactName), new File(extensionDir, artifactName), null);
                        System.out.println("Build complete, cleaning up...");
                        if (!FileUtil.recursiveDelete(file)) {
                            System.err.println("Could not delete " + file + ", but build completed successfully.");
                            System.exit(1);
                        }
                        System.exit(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    break block102;
                }
                if (dynamicTools.containsKey(mode)) {
                    ((CommandLineTool)dynamicTools.get(mode)).execute(parsedArgs);
                    System.exit(0);
                    break block102;
                }
                throw new Error("Should not have gotten here");
            }
            catch (NoClassDefFoundError error) {
                StreamUtils.GetSystemErr().println(Static.getNoClassDefFoundErrorMessage(error));
            }
        }
    }

    static {
        Implementation.setServerType(Implementation.Type.SHELL);
        MethodScriptFileLocations.setDefault(new MethodScriptFileLocations());
        ArgumentSuite suite = new ArgumentSuite().addDescription("These are the command line tools for CommandHelper. For more information about a particular mode, run help <mode name>. To run a command, in general, use the command:\n\n\tjava -jar " + MethodScriptFileLocations.getDefault().getJarFile().getName() + " <mode name> <[mode specific arguments]>\n");
        HELP_MODE = ArgumentParser.GetParser().addDescription("Displays help for all modes, or the given mode if one is provided.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Displays help for the given mode.").setUsageName("mode name").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).setErrorOnUnknownArgs(false);
        suite.addMode("help", HELP_MODE).addModeAlias("--help", "help").addModeAlias("-help", "help").addModeAlias("/?", "help");
        PRINT_DB_MODE = ArgumentParser.GetParser().addDescription("Prints out the built in database in a human readable form, then exits.");
        suite.addMode("print-db", PRINT_DB_MODE);
        DOCS_MODE = ArgumentParser.GetParser().addDescription("Prints documentation for the functions that CommandHelper knows about, then exits.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The type of the documentation, defaulting to html. It may be one of the following: " + StringUtils.Join((Object[])DocGen.MarkupType.values(), ", ", ", or ")).setUsageName("type").setOptionalAndDefault().setDefaultVal("html"));
        suite.addMode("docs", DOCS_MODE);
        VERIFY_MODE = ArgumentParser.GetParser().addDescription("Compiles the given file, returning a json describing the errors in the file, or returning nothing if the file compiles cleanly.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The file to check").setUsageName("file").setRequiredAndDefault());
        suite.addMode("verify", VERIFY_MODE);
        UNINSTALL_CMDLINE_MODE = ArgumentParser.GetParser().addDescription("Uninstalls the MethodScript interpreter from your system.");
        suite.addMode("uninstall-cmdline", UNINSTALL_CMDLINE_MODE);
        SYNTAX_MODE = ArgumentParser.GetParser().addDescription("Generates the syntax highlighter for the specified editor (if available).").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The type of the syntax file to generate. Don't specify a type to see the available options.").setUsageName("type").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        suite.addMode("syntax", SYNTAX_MODE);
        DOCGEN_MODE = ArgumentParser.GetParser().addDescription("Starts the automatic wiki uploader GUI.");
        suite.addMode("docgen", DOCGEN_MODE);
        API_MODE = ArgumentParser.GetParser().addDescription("Prints documentation for the function specified, then exits. The argument is actually a regex, with ^ and $ added to it, so if you would like to search the function list, you can instead provide the rest of the regex. If multiple matches are found, the full list of matches is printed out. For instance \"array.*\" will return all the functions that start with the word \"array\".").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The name of the function to print the information for").setUsageName("functionRegex").setRequiredAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Instead of displaying the results in the console, launches the website with this function highlighted. The local documentation is guaranteed to be consistent with your local version of MethodScript, while the online results may be slightly stale, or may be from a different build, but the results are generally richer.").asFlag().setName('o', "online")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Also prints out the examples for the function (if any).").asFlag().setName('e', "examples"));
        suite.addMode("api", API_MODE);
        EXAMPLES_MODE = ArgumentParser.GetParser().addDescription("Installs one of the built in LocalPackage examples, which may in and of itself be useful.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The name of the package to install. Leave blank to see a list of examples to choose from.").setUsageName("packageName").setOptionalAndDefault());
        suite.addMode("examples", EXAMPLES_MODE);
        OPTIMIZER_TEST_MODE = ArgumentParser.GetParser().addDescription("Given a source file, reads it in and outputs the \"optimized\" version. This is meant as a debug tool, but could be used as an obfuscation tool as well.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("File path").setUsageName("file").setRequiredAndDefault());
        suite.addMode("optimizer-test", OPTIMIZER_TEST_MODE);
        CMDLINE_MODE = ArgumentParser.GetParser().addDescription("Given a source file, runs it in cmdline mode. This is similar to the interpreter mode, but allows for tty input (which is required for some functions, like the prompt_* functions) and provides better information for errors, as the file is known.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("File path/arguments").setUsageName("file and args").setRequiredAndDefault());
        suite.addMode("cmdline", CMDLINE_MODE);
        EXTENSION_DOCS_MODE = ArgumentParser.GetParser().addDescription("Generates markdown documentation for the specified extension utilizing its code, to be used most likely on the extensions github page.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The extension jar to generate documentation for.").setUsageName("path to jar file").setRequired().setName('i', "input-jar").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The file to output the generated documentation to. (Should probably end in .md, but is not required to.) This argument is optional, and if left off, the output will instead print to stdout.").setUsageName("output file name").setOptional().setName('o', "output-file"));
        suite.addMode("extension-docs", EXTENSION_DOCS_MODE);
        DOC_EXPORT_MODE = ArgumentParser.GetParser().addDescription("Outputs all known function documentation as a json. This includes known extensions as well as the built in functions.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Provides the path to your extension directory.").setUsageName("extension folder").setOptional().setName("extension-dir").setDefaultVal("./CommandHelper/extensions").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The file to output the generated json to. If this parameter is missing, it is simply printed to screen.").setUsageName("output file").setOptional().setName('o', "output-file").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        suite.addMode("doc-export", DOC_EXPORT_MODE);
        PROFILER_SUMMARY_MODE = ArgumentParser.GetParser().addDescription("Analyzes the output file for a profiler session, and generates a summary report of the results.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("This value dictates how much of the lower end data is ignored. If the function took less time than this percentage of the total time, it is omitted from the results.").setUsageName("ignore-percentage").setOptional().setName('i', "ignore-percentage").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.NUMBER).setDefaultVal("0")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Path to the profiler file to use.").setUsageName("input-file").setRequiredAndDefault());
        suite.addMode("profiler-summary", PROFILER_SUMMARY_MODE);
        RSA_KEY_GEN_MODE = ArgumentParser.GetParser().addDescription("Creates an ssh compatible rsa key pair. This is used with the Federation system, but is useful with other tools as well.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Output file for the keys. For instance, \"/home/user/.ssh/id_rsa\". The public key will have the same name, with \".pub\" appended.").setUsageName("file").setRequired().setName('o', "output-file").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Label for the public key. For instance, \"user@localhost\" or an email address.").setUsageName("label").setRequired().setName('l', "label").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        suite.addMode("key-gen", RSA_KEY_GEN_MODE);
        PM_VIEWER_MODE = ArgumentParser.GetParser().addDescription("Launches the Persistence Network viewer. This is a GUI tool that can help you visualize your databases.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets up a server running on this machine, that can be accessed by remote Persistence Network Viewers. If this is set, you must also provide the --port and --password options.").asFlag().setName("server")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The port for the server to listen on.").setUsageName("port").setOptional().setName("port").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.NUMBER)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The password that remote clients will need to provide to connect. Leave the field blank to be prompted for a password.").setUsageName("password").setOptional().setName("password").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        suite.addMode("pn-viewer", PM_VIEWER_MODE);
        CORE_FUNCTIONS_MODE = ArgumentParser.GetParser().addDescription("Prints a list of functions tagged with the @core annotation, then exits.");
        suite.addMode("core-functions", CORE_FUNCTIONS_MODE);
        UI_MODE = ArgumentParser.GetParser().addDescription("Launches a GUI that provides a list of all the sub GUI tools provided, and allows selection of a module. This command creates a subshell to run the launcher in, so that the original cmdline shell returns.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Runs the launcher in the same shell process. By default, it creates a new process and causes the initial shell to return.").asFlag().setName("in-shell"));
        suite.addMode("ui", UI_MODE);
        SITE_DEPLOY = ArgumentParser.GetParser().addDescription("Deploys the documentation site, using the preferences specified in the configuration file. This mechanism completely re-writes the remote site, so that builds are totally reproduceable.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The path to the config file for deployment").setUsageName("config file").setOptional().setName('c', "config").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal(MethodScriptFileLocations.getDefault().getSiteDeployFile().getAbsolutePath())).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Generates the preferences file initially, which you can then fill in.").asFlag().setName("generate-prefs")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Generally, when the uploader runs, it checks the remote server to see if the file already exists there (and is unchanged compared to the local file). If it is unchanged, the upload is skipped. However, even checking with the remote to see what the status of the remote file is takes time. If you are the only one uploading files, then we can simply use a local cache of what the remote system has, and we can skip the step of checking with the remote server for any given file. The cache is always populated, whether or not this flag is set, so if you aren't sure if you can trust the cache, run once without this flag, then for future runs, you can be sure that the local cache is up to date.").asFlag().setName("use-local-cache")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Clears the local cache of all entries, then exits.").asFlag().setName("clear-local-cache")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Validates all of the uploaded web pages, and prints out a summary of the results. This uses the value defined in the config file for validation.").asFlag().setName('d', "do-validation")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("When set, does not clear the progress bar line. This is mostly useful when debugging the site-deploy tool itself.").asFlag().setName("no-progress-clear"));
        suite.addMode("site-deploy", SITE_DEPLOY);
        EXTENSION_BUILDER_MODE = ArgumentParser.GetParser().addDescription("Given a path to the git source repo, pulls down the code, builds the extension with maven, and places the artifact in the extension folder. Git, Maven, and the JDK must all be pre-installed on your system for this to work, but once those are configued and working so you can run git and mvn from the cmdline, the rest of the build system should work.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The path to the git repo (ending in .git usually). May be either http or ssh, this parameter is just passed through to git.").setUsageName("git repo path").setRequired().setName('s', "source").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The branch to check out. Defaults to \"master\".").setUsageName("branch").setOptional().setName('b', "branch").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("master")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The extension directory you want to install the built artifact to, by default, this installation's extension directory.").setUsageName("dir").setOptional().setName('e', "extension-dir").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal(MethodScriptFileLocations.getDefault().getExtensionsDirectory().getAbsolutePath())).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("If the checkout folder already exists, it is first deleted, then cloned again.").asFlag().setName('f', "force"));
        suite.addMode("build-extension", EXTENSION_BUILDER_MODE);
        ARGUMENT_SUITE = suite;
    }

    @tool(value="json-api")
    public static class JsonTool
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints the api.json file to stdout. This takes no parameters.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            APIBuilder.main(null);
            System.exit(0);
        }
    }

    @tool(value="new-type")
    public static class NewTypeTool
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Creates a new type. This command should only be run at the root of a classLibrary, and given the class name, will create the appropriate folder structure (as necessary) as well as providing a default file prepopulated with a reasonable template. If the file already exists, will refuse to continue.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The template type to use").setUsageName("template").setOptional().setName('t', "type").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("class")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The class name to create. This should be the fully qualified class name.").setUsageName("fully qualified class name").setRequiredAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String clazz = parsedArgs.getStringArgument();
            String template = parsedArgs.getStringArgument(Character.valueOf('t')).toLowerCase();
            List<String> validTemplates = Arrays.asList("annotation", "class", "enum", "interface");
            if (!validTemplates.contains(template)) {
                System.err.println("Invalid template type specified. Valid template types are: " + validTemplates.toString());
            }
            String[] split2 = clazz.split("\\.");
            String classSimpleName = split2[split2.length - 1];
            String author = StaticLayer.GetConvertor().GetUser(null);
            String created = new Scheduling.simple_date().exec(Target.UNKNOWN, null, new CString("yyyy-MM-dd", Target.UNKNOWN)).val();
            File file = new File(clazz.replace(".", "/") + ".ms");
            if (file.exists()) {
                System.err.println("File " + file + " already exists. Refusing to continue.");
                System.exit(1);
            }
            file.getParentFile().mkdirs();
            String allTemplate = split2[0].equals("ms") ? StreamUtils.GetResource("/templates/new-type-templates/native-all.ms") : StreamUtils.GetResource("/templates/new-type-templates/all.ms");
            String typeTemplate = StreamUtils.GetResource("/templates/new-type-templates/" + template + ".ms");
            allTemplate = String.format(allTemplate, classSimpleName, author, created, clazz);
            typeTemplate = String.format(typeTemplate, clazz);
            FileUtil.write(allTemplate + typeTemplate, file);
        }
    }

    @tool(value="new")
    public static class NewMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Creates a blank, executable script in the specified location with the appropriate permissions, having the correct hashbang, and ready to be executed. If the specified file already exists, it will refuse to create it, unless --force is set.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Location and name to create the script as. Multiple arguments can be provided, and they will create multiple files.").setUsageName("file").setRequiredAndDefault()).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Forces the file to be overwritten, even if it already exists.").asFlag().setName('f', "force"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws IOException {
            String li = OSUtils.GetLineEnding();
            for (String file : parsedArgs.getStringListArgument()) {
                File f = new File(file);
                if (f.exists() && !parsedArgs.isFlagSet(Character.valueOf('f'))) {
                    System.out.println(file + " already exists, refusing to create");
                    continue;
                }
                f.createNewFile();
                f.setExecutable(true);
                FileUtil.write("#!/usr/bin/env /usr/local/bin/mscript" + li + "<!" + li + "\tstrict;" + li + "\tname: " + f.getName() + ";" + li + "\tauthor: " + StaticLayer.GetConvertor().GetUser(null) + ";" + li + "\tcreated: " + new Scheduling.simple_date().exec(Target.UNKNOWN, null, new CString("yyyy-MM-dd", Target.UNKNOWN)).val() + ";" + li + "\tdescription: ;" + li + ">" + li + li, f, true);
            }
        }
    }

    @tool(value="interpreter")
    public static class InterpreterMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Launches the minimal cmdline interpreter.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the initial working directory of the interpreter. This is optional, but is automatically set by the mscript program. The option name is strange, to avoid any conflicts with script arguments.").setUsageName("location").setOptional().setName("location-----").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("."));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            new Interpreter(parsedArgs.getStringListArgument(), parsedArgs.getStringArgument("location-----"));
        }
    }

    @tool(value="mslp")
    public static class MSLPMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Creates an MSLP file based on the directory specified.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The path to the folder").setUsageName("path/to/folder").setRequiredAndDefault());
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String mslp = parsedArgs.getStringArgument();
            if (mslp.isEmpty()) {
                StreamUtils.GetSystemOut().println("Usage: --mslp path/to/folder");
                System.exit(1);
            }
            MSLPMaker.start(mslp);
        }
    }

    @tool(value="manager")
    public static class ManagerMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Launches the built in interactive data manager, which will allow command line access to the full persistence database.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Manager.start();
        }
    }

    @tool(value="version", aliases={"-v", "--v", "-version", "--version"})
    public static class VersionMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints the version of CommandHelper, and exits.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            StreamUtils.GetSystemOut().println("You are running " + Implementation.GetServerType().getBranding() + " version " + Static.loadSelfVersion());
            for (ExtensionTracker e : ExtensionManager.getTrackers().values()) {
                StreamUtils.GetSystemOut().println(e.getIdentifier() + ": " + e.getVersion());
            }
        }
    }

    @tool(value="install-cmdline")
    public static class InstallCmdlineMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Installs MethodScript to your system, so that commandline scripts work. (Currently only unix is supported.)").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the name of the command. This allows support for multiple installations per system.").setUsageName("command name").setOptional().setName("command").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("mscript"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String commandName = parsedArgs.getStringArgument("command");
            Interpreter.install(commandName);
            System.exit(0);
        }
    }

    @tool(value="copyright")
    public static class CopyrightMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints the copyright and exits.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String buildYear = new Scheduling.simple_date().exec(Target.UNKNOWN, null, new CString("yyyy", Target.UNKNOWN), new Meta.engine_build_date().exec(Target.UNKNOWN, null, new Mixed[0])).val();
            StreamUtils.GetSystemOut().println("The MIT License (MIT)\n\nCopyright (c) 2012-" + buildYear + " Methodscript Contributors\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of \nthis software and associated documentation files (the \"Software\"), to deal in \nthe Software without restriction, including without limitation the rights to \nuse, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of \nthe Software, and to permit persons to whom the Software is furnished to do so, \nsubject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all \ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR \nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS \nFOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR \nCOPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER \nIN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN \nCONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
            System.exit(0);
        }
    }
}

