/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.IVariableList;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREStackOverflowError;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.LoopManipulationException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Procedure
implements Cloneable {
    private final String name;
    private Map<String, IVariable> varList;
    private final Map<String, Mixed> originals = new HashMap<String, Mixed>();
    private final List<IVariable> varIndex = new ArrayList<IVariable>();
    private ParseTree tree;
    private CClassType returnType;
    private boolean possiblyConstant = false;
    private static final Pattern PROCEDURE_NAME_REGEX = Pattern.compile("^_[\\p{L}0-9]+[\\p{L}_0-9]*");
    private final Target definedAt;

    public Procedure(String name, CClassType returnType, List<IVariable> varList, ParseTree tree, Target t) {
        this.name = name;
        this.definedAt = t;
        this.varList = new HashMap<String, IVariable>();
        for (IVariable var : varList) {
            try {
                this.varList.put(var.getVariableName(), var.clone());
            }
            catch (CloneNotSupportedException e) {
                this.varList.put(var.getVariableName(), var);
            }
            this.varIndex.add(var);
            this.originals.put(var.getVariableName(), var.ival());
        }
        this.tree = tree;
        if (!PROCEDURE_NAME_REGEX.matcher(name).matches()) {
            throw new CREFormatException("Procedure names must start with an underscore, and may only contain letters, underscores, and digits. (Found " + this.name + ")", t);
        }
        this.possiblyConstant = this.checkPossiblyConstant(tree);
        this.returnType = returnType;
    }

    private boolean checkPossiblyConstant(ParseTree tree) {
        return false;
    }

    public boolean isPossiblyConstant() {
        return this.possiblyConstant;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(" + StringUtils.Join(this.varList.keySet(), ", ") + ")";
    }

    public Mixed cexecute(List<ParseTree> args, Environment env, Target t) {
        ArrayList<Mixed> list = new ArrayList<Mixed>();
        for (ParseTree arg : args) {
            list.add(env.getEnv(GlobalEnv.class).GetScript().seval(arg, env));
        }
        return this.execute(list, env, t);
    }

    public Mixed execute(List<Mixed> args, Environment env, Target t) {
        Object c;
        env.getEnv(GlobalEnv.class).SetVarList(new IVariableList());
        CArray arguments = new CArray(Target.UNKNOWN);
        for (String key : this.originals.keySet()) {
            c = this.originals.get(key);
            env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(Auto.TYPE, key, (Mixed)c, Target.UNKNOWN, env));
            arguments.push((Mixed)c, t);
        }
        Script fakeScript = Script.GenerateScript(this.tree, env.getEnv(GlobalEnv.class).GetLabel());
        for (int i = 0; i < args.size(); ++i) {
            c = args.get(i);
            arguments.set(i, (Mixed)c, t);
            if (this.varIndex.size() <= i) continue;
            String varname = this.varIndex.get(i).getVariableName();
            if (c instanceof CNull || InstanceofUtil.isInstanceof((Mixed)c, this.varIndex.get(i).getDefinedType(), env) || this.varIndex.get(i).getDefinedType().equals(Auto.TYPE)) {
                env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(this.varIndex.get(i).getDefinedType(), varname, (Mixed)c, c.getTarget(), env));
                continue;
            }
            throw new CRECastException("Procedure \"" + this.name + "\" expects a value of type " + this.varIndex.get(i).getDefinedType().val() + " in argument " + (i + 1) + ", but a value of type " + c.typeof() + " was found instead.", c.getTarget());
        }
        env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, "@arguments", arguments, Target.UNKNOWN, env));
        StackTraceManager stManager = env.getEnv(GlobalEnv.class).GetStackTraceManager();
        stManager.addStackTraceElement(new ConfigRuntimeException.StackTraceElement("proc " + this.name, this.getTarget()));
        try {
            if (this.tree.getData() instanceof CFunction && "sconcat".equals(this.tree.getData().val())) {
                for (ParseTree child : this.tree.getChildren()) {
                    fakeScript.eval(child, env);
                }
            } else {
                fakeScript.eval(this.tree, env);
            }
        }
        catch (FunctionReturnException e) {
            Mixed ret = e.getReturn();
            if (!InstanceofUtil.isInstanceof(ret, this.returnType, env)) {
                throw new CRECastException("Expected procedure \"" + this.name + "\" to return a value of type " + this.returnType.val() + " but a value of type " + ret.typeof() + " was returned instead", ret.getTarget());
            }
            Mixed mixed = ret;
            return mixed;
        }
        catch (LoopManipulationException ex) {
            throw ConfigRuntimeException.CreateUncatchableException("Loop manipulation operations (e.g. break() or continue()) cannot bubble up past procedures.", t);
        }
        catch (ConfigRuntimeException e) {
            if (e instanceof AbstractCREException) {
                ((AbstractCREException)e).freezeStackTraceElements(stManager);
            }
            throw e;
        }
        catch (StackOverflowError e) {
            throw new CREStackOverflowError(null, t, e);
        }
        finally {
            stManager.popStackTraceElement();
        }
        if (!this.returnType.equals(Auto.TYPE) && !this.returnType.equals(CVoid.TYPE)) {
            throw new CRECastException("Expecting procedure \"" + this.name + "\" to return a value of type " + this.returnType.val() + ", but no value was returned.", this.tree.getTarget());
        }
        return CVoid.VOID;
    }

    public Target getTarget() {
        return this.definedAt;
    }

    public Procedure clone() throws CloneNotSupportedException {
        Procedure clone = (Procedure)super.clone();
        if (this.varList != null) {
            clone.varList = new HashMap<String, IVariable>(this.varList);
        }
        if (this.tree != null) {
            clone.tree = this.tree.clone();
        }
        return clone;
    }

    public void definitelyNotConstant() {
        this.possiblyConstant = false;
    }
}

