/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.compiler.keywords.ImplementsKeyword;
import com.laytonsmith.core.constructs.CBareString;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CSymbol;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.natives.interfaces.MAnnotation;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ObjectModifier;
import com.laytonsmith.core.objects.ObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ObjectDefinitionKeyword
extends Keyword {
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        int startRemovalFrom = keywordPosition;
        ParseTree className = ObjectDefinitionKeyword.getClassName(list, keywordPosition + 1);
        ArrayList<ParseTree> implementsTypes = new ArrayList<ParseTree>();
        boolean inImplementsKeyword = false;
        for (int i = keywordPosition + 2; i < list.size(); ++i) {
            ParseTree l = list.get(i);
            Keyword k = null;
            if (l.getData() instanceof CKeyword) {
                k = ((CKeyword)l.getData()).getKeyword();
            }
            if (inImplementsKeyword) {
                if (l.getData() instanceof CSymbol && ((CSymbol)l.getData()).convert().equals(",")) continue;
                if (k != null || CFunction.IsFunction(l.getData(), Compiler.__cbrace__.class)) break;
                if (l.getData() instanceof CBareString) {
                    implementsTypes.add(ObjectDefinitionKeyword.getClassName(list, i));
                    continue;
                }
                throw new ConfigCompileException("Unexpected value: " + l.getData(), l.getTarget());
            }
            if (k == null || !(k instanceof ImplementsKeyword)) continue;
            inImplementsKeyword = true;
        }
        Target objectDeclaration = list.get(keywordPosition).getTarget();
        ParseTree cbrace = null;
        for (int i = startRemovalFrom; i < list.size(); ++i) {
            if (CFunction.IsFunction(list.get(i).getData(), Compiler.__cbrace__.class)) {
                cbrace = list.get(i);
                break;
            }
            list.remove(--i);
        }
        if (cbrace == null) {
            throw new ConfigCompileException("Invalid object declaration", objectDeclaration);
        }
        return keywordPosition;
    }

    private static ParseTree getClassName(List<ParseTree> list, int start) throws ConfigCompileException {
        ArrayList<ParseTree> ret = new ArrayList<ParseTree>();
        for (int i = start; i < list.size(); ++i) {
            ParseTree one = list.get(i);
            ParseTree two = new ParseTree(CNull.NULL, null);
            if (list.size() > i + 1) {
                two = list.get(i + 1);
            }
            if (!(one.getData() instanceof CKeyword) && one.getData() instanceof CBareString) {
                ret.add(one);
                continue;
            }
            if (!(two.getData() instanceof CSymbol)) break;
            CSymbol s = (CSymbol)two.getData();
            if (s.convert().equals(".")) {
                ret.add(two);
                continue;
            }
            throw new ConfigCompileException("Unexpected symbol in object definition: " + one.getData(), one.getTarget());
        }
        if (ret.size() == 1) {
            return (ParseTree)ret.get(0);
        }
        ParseTree p2 = new ParseTree(new CFunction("__autoconcat__", Target.UNKNOWN), ((ParseTree)ret.get(0)).getFileOptions());
        for (ParseTree m : ret) {
            p2.addChild(m);
        }
        return p2;
    }

    protected List<ParseTree> processInternals(List<MAnnotation> annotations, AccessModifier accessModifier, Set<ObjectModifier> objectModifiers, CClassType objectName, CClassType[] superclasses, CClassType[] interfaces, ParseTree contents) {
        return null;
    }

    protected abstract ObjectType getObjectType(Set<ObjectModifier> var1);

    protected abstract Set<ObjectModifier> illegalModifiers();
}

