/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.DataHandling;
import java.util.List;

@Keyword.keyword(value="proc")
public class ProcKeyword
extends Keyword {
    private static final String PROC = new DataHandling.proc().getName();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        if (list.get(keywordPosition).getData() instanceof CKeyword) {
            if (!(list.get(keywordPosition + 1).getData() instanceof CFunction)) throw new ConfigCompileException("Unexpected use of \"proc\" keyword", list.get(keywordPosition).getTarget());
            ParseTree proc2 = new ParseTree(new CFunction(PROC, list.get(keywordPosition).getTarget()), list.get(keywordPosition).getFileOptions());
            proc2.addChild(new ParseTree(new CString(list.get(keywordPosition + 1).getData().val(), list.get(keywordPosition + 1).getTarget()), list.get(keywordPosition + 1).getFileOptions()));
            for (ParseTree child : list.get(keywordPosition + 1).getChildren()) {
                proc2.addChild(child);
            }
            if (list.size() <= keywordPosition + 2) {
                throw new ConfigCompileException("Expected braces to follow proc definition", list.get(keywordPosition + 1).getTarget());
            }
            this.validateCodeBlock(list.get(keywordPosition + 2), "Expected braces to follow proc definition");
            proc2.addChild(ProcKeyword.getArgumentOrNull(list.get(keywordPosition + 2)));
            list.remove(keywordPosition);
            list.remove(keywordPosition);
            list.remove(keywordPosition);
            list.add(keywordPosition, proc2);
            return keywordPosition;
        } else {
            if (!this.nodeIsProcFunction(list.get(keywordPosition))) throw new ConfigCompileException("Unexpected use of \"proc\" keyword", list.get(keywordPosition).getTarget());
            if (list.size() <= keywordPosition + 1 || !this.isValidCodeBlock(list.get(keywordPosition + 1))) return keywordPosition;
            list.get(keywordPosition).addChild(ProcKeyword.getArgumentOrNull(list.get(keywordPosition + 1)));
            list.remove(keywordPosition + 1);
        }
        return keywordPosition;
    }

    private boolean nodeIsProcFunction(ParseTree node) {
        return node.getData() instanceof CFunction && node.getData().val().equals(PROC);
    }

    @Override
    public String docs() {
        return "Defines a procedure, which can be called from elsewhere in code.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

