/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.natives.interfaces.Mixed;

public class IVariable
extends Construct
implements Cloneable {
    public static final long serialVersionUID = 1L;
    private Mixed varValue;
    private final String name;
    private final CClassType type;
    private final Target definedTarget;
    public static final String VARIABLE_NAME_REGEX = "@[\\p{L}0-9_]+";

    public IVariable(String name, Target t) throws ConfigCompileException {
        super(name, Construct.ConstructType.IVARIABLE, t);
        if (!name.matches(VARIABLE_NAME_REGEX)) {
            throw new ConfigCompileException("IVariables must match the regex: @[\\p{L}0-9_]+", t);
        }
        this.varValue = new CString("", t);
        this.name = name;
        this.type = Auto.TYPE;
        this.definedTarget = t;
    }

    public IVariable(CClassType type, String name, Mixed value, Target t, Environment env) {
        super(name, Construct.ConstructType.IVARIABLE, t);
        if (!(type.equals(Auto.TYPE) || value instanceof CNull || InstanceofUtil.isInstanceof(value, type, env))) {
            throw new CRECastException(name + " is of type " + type.val() + ", but a value of type " + value.typeof() + " was assigned to it.", t);
        }
        if (type.equals(CVoid.TYPE)) {
            throw new CRECastException("Variables may not be of type void", t);
        }
        this.type = type;
        if (value == null) {
            throw new NullPointerException();
        }
        this.varValue = value;
        this.name = name;
        this.definedTarget = t;
    }

    @Override
    public String val() {
        return this.varValue.val();
    }

    public Mixed ival() {
        this.varValue.setTarget(this.getTarget());
        return this.varValue;
    }

    public String getVariableName() {
        return this.name;
    }

    public void setIval(Mixed c) {
        this.varValue = c;
    }

    @Override
    public String toString() {
        return this.name + ":(" + this.ival().getClass().getSimpleName() + ") '" + this.ival().val() + "'";
    }

    @Override
    public IVariable clone() throws CloneNotSupportedException {
        IVariable clone = (IVariable)super.clone();
        if (this.varValue != null) {
            clone.varValue = this.varValue.clone();
        }
        return clone;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public CClassType getDefinedType() {
        return this.type;
    }

    public Target getDefinedTarget() {
        return this.definedTarget;
    }

    @Override
    public Version since() {
        return super.since();
    }

    @Override
    public String docs() {
        return super.docs();
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[0];
    }
}

