/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.noprofile;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.SimpleDocumentation;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.IVariableList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.snapins.PackagePermission;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFunction
implements Function {
    private boolean shouldProfile = !this.getClass().isAnnotationPresent(noprofile.class);
    private static final Class[] EMPTY_CLASS = new Class[0];

    protected AbstractFunction() {
    }

    @Override
    public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
        return CVoid.VOID;
    }

    @Override
    public boolean useSpecialExec() {
        return false;
    }

    @Override
    public final boolean appearInDocumentation() {
        return this.getClass().getAnnotation(hide.class) == null;
    }

    public Mixed optimize(Target t, Environment env, Mixed ... args) throws ConfigCompileException {
        return null;
    }

    public ParseTree optimizeDynamic(Target t, Environment env, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
        return null;
    }

    public void varList(IVariableList varList) {
    }

    @Override
    public boolean preResolveVariables() {
        return true;
    }

    @Override
    public ExampleScript[] examples() throws ConfigCompileException {
        return null;
    }

    @Override
    public boolean shouldProfile() {
        return this.shouldProfile;
    }

    @Override
    public LogLevel profileAt() {
        return LogLevel.VERBOSE;
    }

    @Override
    public String profileMessage(Mixed ... args) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Mixed ccc : args) {
            if (!first) {
                b.append(", ");
            }
            first = false;
            if (ccc.isInstanceOf(CArray.class)) {
                b.append("<arrayNotShown size:").append(((CArray)ccc).size()).append(">");
                continue;
            }
            if (ccc.isInstanceOf(CClosure.class)) {
                b.append("<closureNotShown>");
                continue;
            }
            if (ccc.isInstanceOf(CString.class)) {
                String val = ccc.val().replace("\\", "\\\\").replace("'", "\\'");
                int max2 = 1000;
                if (val.length() > max2) {
                    val = val.substring(0, max2) + "... (" + (val.length() - max2) + " more characters hidden)";
                }
                b.append("'").append(val).append("'");
                continue;
            }
            if (ccc instanceof IVariable) {
                b.append(((IVariable)ccc).getVariableName());
                continue;
            }
            b.append(ccc.val());
        }
        return "Executing function: " + this.getName() + "(" + b.toString() + ")";
    }

    protected String getBundledDocs() {
        try {
            return this.getBundledDocs(null);
        }
        catch (DocGenTemplates.Generator.GenerateException ex) {
            return "";
        }
    }

    protected String getBundledDocs(Map<String, DocGenTemplates.Generator> map) throws DocGenTemplates.Generator.GenerateException {
        String template = StreamUtils.GetString(AbstractFunction.class.getResourceAsStream("/functionDocs/" + this.getName()));
        if (map == null) {
            map = new HashMap<String, DocGenTemplates.Generator>();
        }
        return DocGenTemplates.DoTemplateReplacement(template, map);
    }

    protected <T extends Enum<?>> String createEnumTable(Class<T> c) {
        Enum[] elist;
        StringBuilder b = new StringBuilder();
        MEnum me = c.getAnnotation(MEnum.class);
        String title2 = me == null ? c.getSimpleName() : me.value();
        b.append("<br>'''").append(title2).append("'''<br>\n");
        b.append("{|\n");
        b.append("|-\n! Name\n! Docs\n! Since\n");
        for (Enum e : elist = (Enum[])c.getEnumConstants()) {
            SimpleDocumentation d = (SimpleDocumentation)((Object)e);
            b.append("|-\n").append("| ").append(d.getName()).append("\n").append("| ").append(d.docs()).append("\n").append("| ").append(d.since()).append("\n");
        }
        b.append("|}\n");
        return b.toString();
    }

    @Override
    public String profileMessageS(List<ParseTree> args) {
        return "Executing function: " + this.getName() + "(<" + args.size() + " child" + (args.size() == 1 ? "" : "ren") + " not shown>)";
    }

    @Override
    public PackagePermission getPermission() {
        return PackagePermission.NO_PERMISSIONS_NEEDED;
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public final Class<? extends Documentation>[] seeAlso() {
        seealso see = this.getClass().getAnnotation(seealso.class);
        if (see == null) {
            return EMPTY_CLASS;
        }
        return see.value();
    }

    @Override
    public final boolean isCore() {
        Class<?> c = this.getClass();
        do {
            if (c.getAnnotation(core.class) == null) continue;
            return true;
        } while ((c = c.getDeclaringClass()) != null);
        return false;
    }

    public void link(Target t, List<ParseTree> children) throws ConfigCompileException {
    }

    @Override
    public int compareTo(Function o) {
        return this.getName().compareTo(o.getName());
    }
}

