/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.nolinking;
import com.laytonsmith.annotations.noprofile;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.annotations.unbreakable;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.Globals;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Procedure;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.BranchStatement;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.VariableScope;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CIClosure;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CMutablePrimitive;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CSlice;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.IVariableList;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREIncludeException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientPermissionException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidProcedureException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREStackOverflowError;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ArrayHandling;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.tools.docgen.templates.ArrayIteration;
import com.laytonsmith.tools.docgen.templates.Arrays;
import com.laytonsmith.tools.docgen.templates.Closures;
import com.laytonsmith.tools.docgen.templates.Variables;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@core
public class DataHandling {
    private static final String array_get = new ArrayHandling.array_get().getName();
    private static final String array_set = new ArrayHandling.array_set().getName();
    private static final String array_push = new ArrayHandling.array_push().getName();

    public static String docs() {
        return "This class provides various methods to control script data and program flow.";
    }

    private static String GetNamespace(CArray array2, Target t) {
        boolean first = true;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while ((long)i < array2.size()) {
            if (!first) {
                b.append(".");
            }
            first = false;
            b.append(array2.get(i, t).val());
            ++i;
        }
        return b.toString();
    }

    @api
    public static class _instanceof
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args[0] instanceof CNull) {
                return CBoolean.FALSE;
            }
            if (!args[1].isInstanceOf(CClassType.class)) {
                throw new RuntimeException("This should have been optimized out, this is a bug in instanceof, please report it");
            }
            CClassType type = (CClassType)args[1];
            boolean b = InstanceofUtil.isInstanceof(args[0], type, environment);
            return CBoolean.get(b);
        }

        @Override
        public String getName() {
            return "instanceof";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "boolean {value, type} Checks to see if the value is, extends, or implements the given type. Keyword usage is preferred: <code>@value instanceof int</code>. The opposite operation is <code>@value notinstanceof int</code>. ---- Null is a special value, while any type may be assigned null, it does not extend any type, and therefore \"null instanceof AnyType\" will always return false. Likewise, other than null, all values extend \"mixed\", and therefore \"anyNonNullValue instanceof mixed\" will always return true. There is no (single) functional equivalent to the notinstanceof keyword. <code>@value notinstanceof int</code> simply compiles to not(instanceof(@value, int)).";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.get(1).getData().isInstanceOf(CString.class)) {
                throw new ConfigCompileException("Unexpected string type passed to \"instanceof\"", t);
            }
            if (children.get(1).getData() instanceof IVariable) {
                throw new ConfigCompileException("Variable types are not allowed in \"instanceof\"", t);
            }
            if (!children.get(1).getData().isInstanceOf(CClassType.class)) {
                throw new ConfigCompileException("Unexpected type for \"instanceof\": " + children.get(1).getData(), t);
            }
            if (children.get(1).getData().val().equals("null")) {
                throw new ConfigCompileException("\"null\" cannot be compared against with instanceof. Use <value> === null.", t);
            }
            if (children.get(0).isConst()) {
                return new ParseTree(this.exec(t, null, children.get(0).getData(), children.get(1).getData()), fileOptions);
            }
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "mixed @a = 5; // Actually an int\nmsg(@a instanceof int); // true\nmsg(@a instanceof string); // false\n"), new ExampleScript("Functional usage", "instanceof(5, int)"), new ExampleScript("Inverted usage", "mixed @a = 5;\nmsg(@a notinstanceof int); // false\nmsg(@a notinstanceof string); // true\n"), new ExampleScript("Inverted functional usage", "!instanceof(5, int)")};
        }
    }

    @api
    @hide(value="This is still experimental")
    public static class mutable_primitive
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Mixed val = CNull.NULL;
            if (args.length > 0) {
                val = args[0];
            }
            return new CMutablePrimitive(val, t);
        }

        @Override
        public String getName() {
            return "mutable_primitive";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "mutable_primitive {[primitive_value]} Creates a mutable primitive object, initially setting the value of the object to null, or the specified value. The value must be a primitive value, and cannot be an array or object. ---- The underlying primitive value is used in all cases where a value can be inferred. In all other cases, you must convert the primitive to the desired type, e.g. double(@mutable_primitive). Mutable primitives work like an array as well, in some cases, but not others. In general, setting of the underlying values may be done with array_push(). Assigning a new value to the variable works the same as assigning a new value to any other value, it overwrites the value with the new type. Most array functions will work with the mutable primitive, however, they will return useless data, for instance, array_resize() will simply set the value to the default value shown. array_size() is an exception to this rule, it will not work, and will throw an exception. See the examples for more use cases. In general, this is meant as a convenience feature for values that are passed to closures or procs, but should be passed by reference. Cloning the mutable primitive with the array clone operation creates a distinct copy.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "@val = mutable_primitive(0);\nmsg('typeof: ' . typeof(@val));\nmsg('value: ' . @val);\nmsg('@val + 5: ' . (@val + 5)); // Works as if it were a primitive with most functions\n(++@val); // As a special exception to how assignments work, increment/decrement works as well\nmsg(@val); // 1\n"), new ExampleScript("Basic usage with procs", "proc(_testWithMutable, @a){\n\t@a[] = 5;\n}\n\nproc(_testWithoutMutable, @a){\n\t@a = 10;\n}\n\n@a = mutable_primitive(0);\nmsg(@a); // The value starts out as 0\n_testWithMutable(@a); // This will actually change the value\nmsg(@a); // Here, the value is 5\n_testWithoutMutable(@a); // This will not change the value\nmsg(@a); // Still the value is 5\n"), new ExampleScript("Basic usage with closure", "@a = mutable_primitive(0);\nexecute(closure(){\n\t@a++;\n});\nmsg(@a); // 1\n"), new ExampleScript("Cloning the value", "@a = mutable_primitive(0);\n@b = @a[];\n@a[] = 5;\nmsg(@a);\nmsg(@b);\n")};
        }
    }

    @api
    @noprofile
    @hide(value="This will eventually be replaced by ; statements.")
    public static class g
    extends AbstractFunction {
        @Override
        public String getName() {
            return "g";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            for (int i = 0; i < args.length; ++i) {
                args[i].val();
            }
            return CVoid.VOID;
        }

        @Override
        public String docs() {
            return "string {func1, [func2...]} Groups any number of functions together, and returns void. ";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }
    }

    @api
    public static class eval
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "eval";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {script_string} Executes arbitrary MethodScript. Note that this function is very experimental, and is subject to changing or removal. To globally disable use of eval, set the runtime setting \"function.eval.disable\" to true, which will cause use of the function to throw an exception.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREInsufficientPermissionException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_0;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            if (ArgumentValidation.getBooleanish(env.getEnv(GlobalEnv.class).GetRuntimeSetting("function.eval.disable", CBoolean.FALSE), t)) {
                throw new CREInsufficientPermissionException("eval is disabled", t);
            }
            boolean oldDynamicScriptMode = env.getEnv(GlobalEnv.class).GetDynamicScriptingMode();
            ParseTree node = nodes[0];
            try {
                env.getEnv(GlobalEnv.class).SetDynamicScriptingMode(true);
                Mixed script = parent.seval(node, env);
                if (script.isInstanceOf(CClosure.class)) {
                    throw new CRECastException("Closures cannot be eval'd directly. Use execute() instead.", t);
                }
                ParseTree root = MethodScriptCompiler.compile(MethodScriptCompiler.lex(script.val(), t.file(), true), env);
                StringBuilder b = new StringBuilder();
                int count = 0;
                for (ParseTree child : root.getChildren()) {
                    Mixed s = parent.seval(child, env);
                    if (!s.val().trim().isEmpty()) {
                        if (count > 0) {
                            b.append(" ");
                        }
                        b.append(s.val());
                    }
                    ++count;
                }
                CString cString = new CString(b.toString(), t);
                return cString;
            }
            catch (ConfigCompileException e) {
                throw new CREFormatException("Could not compile eval'd code: " + e.getMessage(), t);
            }
            catch (ConfigCompileGroupException ex) {
                StringBuilder b = new StringBuilder();
                b.append("Could not compile eval'd code: ");
                for (ConfigCompileException e : ex.getList()) {
                    b.append(e.getMessage()).append("\n");
                }
                throw new CREFormatException(b.toString(), t);
            }
            finally {
                env.getEnv(GlobalEnv.class).SetDynamicScriptingMode(oldDynamicScriptMode);
            }
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() != 1) {
                throw new ConfigCompileException(this.getName() + " expects only one argument", t);
            }
            if (children.get(0).isConst()) {
                MSLog.GetLogger().Log(MSLog.Tags.COMPILER, LogLevel.WARNING, "Eval'd code is hardcoded, consider simply using the code directly, as wrapping hardcoded code in " + this.getName() + " is much less efficient.", t);
            }
            return null;
        }
    }

    @api
    public static class typeof
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            try {
                return args[0].typeof();
            }
            catch (IllegalArgumentException ex) {
                throw new Error("Class " + args[0].getClass().getName() + " is not annotated with @typeof. Please report this error to the developers.");
            }
        }

        @Override
        public String getName() {
            return "typeof";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "ClassType {arg} Returns a string value of the typeof a value. For instance 'array' is returned for typeof(array()). This is a generic replacement for the is_* series of functions.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage, typeof string", "typeof('value')"), new ExampleScript("Basic usage, typeof int", "typeof(1)"), new ExampleScript("Basic usage, typeof double", "typeof(1.0)"), new ExampleScript("Basic usage, typeof closure", "typeof(closure(){ msg('test') })")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE);
        }
    }

    @api
    @seealso(value={to_radix.class})
    public static class parse_int
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRERangeException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            long ret;
            String value = args[0].val();
            int radix = Static.getInt32(args[1], t);
            if (radix < 2 || radix > 36) {
                throw new CRERangeException("The radix must be between 2 and 36, inclusive.", t);
            }
            try {
                ret = Long.parseLong(value, radix);
            }
            catch (NumberFormatException ex) {
                throw new CREFormatException("The input string: \"" + value + "\" is improperly formatted. (Perhaps you're using a character greater than the radix specified?)", t);
            }
            return new CInt(ret, t);
        }

        @Override
        public String getName() {
            return "parse_int";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "int {value, radix} Converts a string representation of an integer to a real integer, given the value's radix (base). See {{function|to_radix}} for a more detailed explanation of number theory. Radix must be between 2 and 36, inclusive.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("From hex string", "parse_int('F', 16)"), new ExampleScript("From binary string", "parse_int('1111', 2)")};
        }
    }

    @api
    @seealso(value={parse_int.class})
    public static class to_radix
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRERangeException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            int radix = Static.getInt32(args[1], t);
            if (radix < 2 || radix > 36) {
                throw new CRERangeException("The radix must be between 2 and 36, inclusive.", t);
            }
            return new CString(Long.toString(Static.getInt(args[0], t), radix), t);
        }

        @Override
        public String getName() {
            return "to_radix";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "string {value, radix} Given an int and a radix, returns a string representation of the integer value in the given base. A common use would be to output a hex or binary representation of a number, for instance. ---- It is useful to note that all integers are stored internally by the computer as binary, but since we usually represent numbers in text as base 10 numbers, we often times forget that both base 16 'F' and base 10 '15' and base 2 '1111' are actually the same number, just represented differently as strings in different bases. This doesn't change how the program behaves, since the base is just a way to represent the number on paper. The 'radix' is the base. So, given to_radix(10, 10), that would return '10', because in code, we wrote out our value '10' in base 10, and we convert it to base 10, so nothing changes. However, if we write to_radix(15, 16) we are saying \"convert the base 10 value 15 to base 16\", so it returns 'F'. See {{function|parse_int}} for the opposite operation. The radix must be between 2 and 36, inclusive, or a range exception is thrown. This is because there are only 36 characters that are normally used to represent different base numbers (that is, 0-9, a-z). The minimum radix is 2, because it is impossible to represent any numbers with out at least a binary base.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("To a hex string", "to_radix(15, 16)"), new ExampleScript("To a binary string", "to_radix(15, 2)"), new ExampleScript("Using hex value in source", "to_radix(0xff, 16)"), new ExampleScript("Using binary value in source", "to_radix(0b10101010, 2)")};
        }
    }

    @api
    public static class _string
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "string";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {item} Creates a new construct that is the \"toString\" of an item. For arrays, an human readable version is returned; this should not be used directly, as the format is not guaranteed to remain consistent. Booleans return \"true\" or \"false\" and null returns \"null\". Strings (and subclasses of strings) are simply returned as is.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args[0].isInstanceOf(CString.class)) {
                return args[0];
            }
            return new CString(args[0].val(), t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "string(1)"), new ExampleScript("Basic usage", "string(true)"), new ExampleScript("Basic usage", "string(false)"), new ExampleScript("Basic usage", "string(null)"), new ExampleScript("Basic usage", "string(array(1, 2))"), new ExampleScript("Basic usage", "string(array(one: 'one', two: 'two'))")};
        }
    }

    @api
    public static class _double
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "double";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "double {item} Returns a new construct that has been cast to an double. This function will throw a CastException if is_numeric would return false for this item, but otherwise, it will be cast properly.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble(Static.getDouble(args[0], t), t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "double(1)"), new ExampleScript("Failure", "@var = 'string';\ndouble(@var);")};
        }
    }

    @api
    public static class _integer
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "integer";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "integer {item} Returns a new construct that has been cast to an integer. This function will throw a CastException if is_numeric would return false for this item, but otherwise, it will be cast properly. Data may be lost in this conversion. For instance, 4.5 will be converted to 4, by using integer truncation. You can use is_integral to see if this data loss would occur.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CInt((long)Static.getDouble(args[0], t), t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "integer(1.0)"), new ExampleScript("Basic usage", "integer(1.5)"), new ExampleScript("Failure", "assign(@var, 'string')\ninteger(@var)")};
        }
    }

    @api
    public static class _boolean
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "boolean";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns a new construct that has been cast to a boolean. The item is cast according to the boolean conversion rules. Since all data types can be cast to a a boolean, this function will never throw an exception.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(ArgumentValidation.getBoolean(args[0], t));
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "boolean(1)"), new ExampleScript("Basic usage", "boolean(0)"), new ExampleScript("Basic usage", "boolean(array(1))"), new ExampleScript("Basic usage", "boolean(array())"), new ExampleScript("Basic usage", "boolean(null)"), new ExampleScript("Basic usage", "boolean('string')"), new ExampleScript("Basic usage", "boolean('')")};
        }
    }

    @api
    @seealso(value={Closures.class})
    public static class executeas
    extends AbstractFunction {
        @Override
        public String getName() {
            return "executeas";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "mixed {player, label, [values...], closure} Executes the given closure in the context of a given player. A closure that runs player(), for instance, would return the specified player's name. The label argument sets the permission label that this closure will use. If null is given, the current label will be used, like with execute().";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (!args[args.length - 1].isInstanceOf(CClosure.class)) {
                throw new CRECastException("Only a closure (created from the closure function) can be sent to executeas()", t);
            }
            Mixed[] vals = new Mixed[args.length - 3];
            System.arraycopy(args, 2, vals, 0, args.length - 3);
            CClosure closure2 = (CClosure)args[args.length - 1];
            CommandHelperEnvironment cEnv = closure2.getEnv().getEnv(CommandHelperEnvironment.class);
            GlobalEnv gEnv = closure2.getEnv().getEnv(GlobalEnv.class);
            MCCommandSender originalSender = cEnv.GetCommandSender();
            cEnv.SetCommandSender(Static.GetPlayer(args[0].val(), t));
            String originalLabel = gEnv.GetLabel();
            if (!(args[1] instanceof CNull)) {
                gEnv.SetLabel(args[1].val());
            }
            try {
                Mixed mixed = closure2.executeCallable(vals);
                return mixed;
            }
            finally {
                cEnv.SetCommandSender(originalSender);
                gEnv.SetLabel(originalLabel);
            }
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    @seealso(value={Closures.class})
    public static class execute
    extends AbstractFunction {
        @Override
        public String getName() {
            return "execute";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "mixed {[values...], closure} Executes the given closure. You can also send arguments to the closure, which it may or may not use, depending on the particular closure's definition. If the closure returns a value with return(), then that value will be returned with execute. Otherwise, void is returned.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args[args.length - 1].isInstanceOf(CClosure.class)) {
                Mixed[] vals = new Mixed[args.length - 1];
                System.arraycopy(args, 0, vals, 0, args.length - 1);
                CClosure closure2 = (CClosure)args[args.length - 1];
                return closure2.executeCallable(vals);
            }
            throw new CRECastException("Only a closure (created from the closure function) can be sent to execute()", t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    @hide(value="Until the Federation system is finished, this is hidden")
    @unbreakable
    @nolinking
    public static class rclosure
    extends closure {
        @Override
        public String getName() {
            return "rclosure";
        }

        @Override
        public String docs() {
            return "closure {[params...], code} Returns a non-linking closure on the provided code. The same rules apply for closures, except the top level internal code does not check for proper linking at compile time, and instead links at runtime. Lexer errors and some other compile time checks ARE done however, but functions are not optimized or linked. This is used for remote code execution, since the remote platform may have some functionality unavailable on this current platform.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    @unbreakable
    @seealso(value={Closures.class})
    public static class iclosure
    extends closure {
        @Override
        public String getName() {
            return "iclosure";
        }

        @Override
        public String docs() {
            return "iclosure {[params...], code} Returns a scope isolated closure on the provided code. An iclosure is a datatype that represents some code as code, not the results of some code after it is run. Code placed in an iclosure can be used as a string, or executed by other functions using the execute() function. If a closure is \"to string'd\" it will not necessarily look like the original code, but will be functionally equivalent. The current environment is \"snapshotted\" and stored with the closure, however, this information is only stored in memory, it isn't retained during a serialization operation. However, the variable table of the parent scope is not retained, thus making this closure \"isolated\" from the parent code. The special variable @arguments is automatically created for you, and contains an array of all the arguments passed to the closure, much like procedures. See the wiki article on [[Closures|closures]] for more details and examples.";
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            Environment myEnv;
            if (nodes.length == 0) {
                return new CIClosure(null, env, Auto.TYPE, new String[0], new Mixed[0], new CClassType[0], t);
            }
            CClassType returnType = Auto.TYPE;
            if (nodes[0].getData().isInstanceOf(CClassType.class)) {
                returnType = (CClassType)nodes[0].getData();
                ParseTree[] newNodes = new ParseTree[nodes.length - 1];
                for (int i = 1; i < nodes.length; ++i) {
                    newNodes[i - 1] = nodes[i];
                }
                nodes = newNodes;
            }
            String[] names = new String[nodes.length - 1];
            Mixed[] defaults = new Mixed[nodes.length - 1];
            CClassType[] types = new CClassType[nodes.length - 1];
            try {
                myEnv = env.clone();
            }
            catch (CloneNotSupportedException ex) {
                myEnv = env;
            }
            for (int i = 0; i < nodes.length - 1; ++i) {
                ParseTree node = nodes[i];
                ParseTree newNode = new ParseTree(new CFunction("g", t), node.getFileOptions());
                ArrayList<ParseTree> children = new ArrayList<ParseTree>();
                children.add(node);
                newNode.setChildren(children);
                Script fakeScript = Script.GenerateScript(newNode, myEnv.getEnv(GlobalEnv.class).GetLabel());
                myEnv.getEnv(GlobalEnv.class).SetFlag("closure-warn-overwrite", true);
                Mixed ret = MethodScriptCompiler.execute(newNode, myEnv, null, fakeScript);
                myEnv.getEnv(GlobalEnv.class).ClearFlag("closure-warn-overwrite");
                if (!(ret instanceof IVariable)) {
                    throw new CRECastException("Arguments sent to " + this.getName() + " barring the last) must be ivariables", t);
                }
                names[i] = ((IVariable)ret).getVariableName();
                try {
                    defaults[i] = ((IVariable)ret).ival().clone();
                    types[i] = ((IVariable)ret).getDefinedType();
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(DataHandling.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            CIClosure closure2 = new CIClosure(nodes[nodes.length - 1], myEnv, returnType, names, defaults, types, t);
            return closure2;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Creates an iclosure", "iclosure(){\n\tmsg('Hello World!');\n};"), new ExampleScript("Executes an iclosure", "execute(iclosure(){\n\tmsg('Hello World!');\n});"), new ExampleScript("Shows scoping", "@a = 'variable';\nmsg('Outside of iclosure: '.reflect_pull('varlist'));\n// Note that this is an iclosure\nexecute('val1', iclosure(@b){\n\tmsg('Inside of iclosure: '.reflect_pull('varlist'));\n});\n// Note that this is a regular closure\nexecute('val2', closure(@c){\n\tmsg('Insider of closure: '.reflect_pull('varlist'));\n});")};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @unbreakable
    @seealso(value={Closures.class})
    public static class closure
    extends AbstractFunction
    implements BranchStatement,
    VariableScope {
        @Override
        public String getName() {
            return "closure";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "closure {[params...], code} Returns a closure on the provided code. A closure is a datatype that represents some code as code, not the results of some code after it is run. Code placed in a closure can be used as a string, or executed by other functions using the execute() function. If a closure is \"to string'd\" it will not necessarily look like the original code, but will be functionally equivalent. The current environment is \"snapshotted\" and stored with the closure, however, this information is only stored in memory, it isn't retained during a serialization operation. Also, the special variable @arguments is automatically created for you, and contains an array of all the arguments passed to the closure, much like procedures. See the wiki article on [[Closures|closures]] for more details and examples.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            Environment myEnv;
            if (nodes.length == 0) {
                return new CClosure(null, env, Auto.TYPE, new String[0], new Mixed[0], new CClassType[0], t);
            }
            CClassType returnType = Auto.TYPE;
            if (nodes[0].getData().isInstanceOf(CClassType.class)) {
                returnType = (CClassType)nodes[0].getData();
                ParseTree[] newNodes = new ParseTree[nodes.length - 1];
                for (int i = 1; i < nodes.length; ++i) {
                    newNodes[i - 1] = nodes[i];
                }
                nodes = newNodes;
            }
            String[] names = new String[nodes.length - 1];
            Mixed[] defaults = new Mixed[nodes.length - 1];
            CClassType[] types = new CClassType[nodes.length - 1];
            try {
                myEnv = env.clone();
            }
            catch (CloneNotSupportedException ex) {
                myEnv = env;
            }
            for (int i = 0; i < nodes.length - 1; ++i) {
                ParseTree node = nodes[i];
                ParseTree newNode = new ParseTree(new CFunction("g", t), node.getFileOptions());
                ArrayList<ParseTree> children = new ArrayList<ParseTree>();
                children.add(node);
                newNode.setChildren(children);
                Script fakeScript = Script.GenerateScript(newNode, myEnv.getEnv(GlobalEnv.class).GetLabel());
                myEnv.getEnv(GlobalEnv.class).SetFlag("closure-warn-overwrite", true);
                Mixed ret = MethodScriptCompiler.execute(newNode, myEnv, null, fakeScript);
                myEnv.getEnv(GlobalEnv.class).ClearFlag("closure-warn-overwrite");
                if (!(ret instanceof IVariable)) {
                    throw new CRECastException("Arguments sent to " + this.getName() + " barring the last) must be ivariables", t);
                }
                names[i] = ((IVariable)ret).getVariableName();
                try {
                    defaults[i] = ((IVariable)ret).ival().clone();
                    types[i] = ((IVariable)ret).getDefinedType();
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(DataHandling.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            CClosure closure2 = new CClosure(nodes[nodes.length - 1], myEnv, returnType, names, defaults, types, t);
            return closure2;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Creates a closure", "closure(){\n\tmsg('Hello World!');\n};"), new ExampleScript("Executes a closure", "execute(closure(){\n\tmsg('Hello World!');\n});")};
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(children.size());
            if (children.isEmpty()) {
                return ret;
            }
            for (int i = 0; i < children.size() - 1; ++i) {
                ret.add(false);
            }
            ret.add(true);
            return ret;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            return this.isBranch(children);
        }
    }

    @api
    @seealso(value={_import.class})
    public static class _export
    extends AbstractFunction {
        @Override
        public String getName() {
            return "export";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "void {key, value} Stores a value in the global storage register. An arbitrary value is stored with the given key, and can be retreived using import. If the value is already stored, it is overwritten. See {{function|import}}. The reference to the value is stored, not a copy of the value, so in the case of arrays, manipulating the contents of the array will manipulate the stored value. An array may be used as a key. It is converted into a string with the array values separated by dots. export() is threadsafe.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIllegalArgumentException.class, CREIndexOverflowException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String key;
            if (args[0].isInstanceOf(CString.class)) {
                key = args[0].val();
            } else if (args[0].isInstanceOf(CArray.class)) {
                if (((CArray)args[0]).isAssociative()) {
                    throw new CREIllegalArgumentException("Associative arrays may not be used as keys in " + this.getName(), t);
                }
                key = DataHandling.GetNamespace((CArray)args[0], t);
            } else {
                throw new CREIllegalArgumentException("Argument 1 in " + this.getName() + " must be a string or array.", t);
            }
            Mixed c = args[1];
            Globals.SetGlobal(key, c);
            return CVoid.VOID;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "@var = 2;\nexport('custom.name', @var);\n@var2 = import('custom.name');\nmsg(@var2);"), new ExampleScript("Storage of references", "@array = array(1, 2, 3);\nexport('array', @array);\n@array[0] = 4;\n@array2 = import('array');\nmsg(@array2);"), new ExampleScript("Array key usage", "@key = array(custom, name);\nexport(@key, 'value');\n@value = import(@key);\nmsg(@value);"), new ExampleScript("Default value usage", "export('custom.name', null);\n@value = import('custom.name', 'default value');\nmsg(@value);")};
        }
    }

    @api
    @seealso(value={_export.class})
    public static class _import
    extends AbstractFunction {
        @Override
        public String getName() {
            return "import";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "mixed {key, [default]} This function imports a value from the global value register. It looks for a value stored with the specified key (using the export function), and returns that value. If specified key doesn't exist, it will return either null or the default value if specified. An array may be used as a key. It is converted into a string with the array values separated by dots. import() is threadsafe.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIllegalArgumentException.class, CREIndexOverflowException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String key;
            if (args[0].isInstanceOf(CString.class)) {
                key = args[0].val();
            } else if (args[0].isInstanceOf(CArray.class)) {
                if (((CArray)args[0]).isAssociative()) {
                    throw new CREIllegalArgumentException("Associative arrays may not be used as keys in " + this.getName(), t);
                }
                key = DataHandling.GetNamespace((CArray)args[0], t);
            } else {
                throw new CREIllegalArgumentException("Argument 1 in " + this.getName() + " must be a string or array.", t);
            }
            Mixed c = Globals.GetGlobalConstruct(key);
            if (args.length == 2 && c instanceof CNull) {
                c = args[1];
            }
            return c;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new _export().examples();
        }
    }

    @api
    public static class is_closure
    extends AbstractFunction {
        @Override
        public String getName() {
            return "is_closure";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {arg} Returns true if the argument is a closure (could be executed) or false otherwise";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CClosure.class));
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_closure(closure(msg('code')))"), new ExampleScript("False condition", "is_closure('a string')")};
        }
    }

    @api
    public static class is_associative
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_associative";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {array} Returns whether or not the array is associative. If the parameter is not an array, throws a CastException.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (args[0].isInstanceOf(CArray.class)) {
                return CBoolean.get(((CArray)args[0]).inAssociativeMode());
            }
            throw new CRECastException(this.getName() + " expects argument 1 to be an array", t);
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_associative(array(one: 1, two: 2))"), new ExampleScript("False condition", "is_associative(array(1, 2, 3))")};
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class is_proc
    extends AbstractFunction {
        @Override
        public String getName() {
            return "is_proc";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {procName} Returns whether or not the given procName is currently defined, i.e. if calling this proc wouldn't throw an exception.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_2_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) {
            return CBoolean.get(env.getEnv(GlobalEnv.class).GetProcs().get(args[0].val()) != null);
        }
    }

    @api
    public static class include
    extends AbstractFunction {
        @Override
        public String getName() {
            return "include";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "void {path} Includes external code at the specified path.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIncludeException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_2_0;
        }

        @Override
        public Boolean runAsync() {
            return true;
        }

        @Override
        public CVoid exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public CVoid execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            ParseTree tree = nodes[0];
            Mixed arg = parent.seval(tree, env);
            String location = arg.val();
            File file = Static.GetFileFromArgument(location, env, t, null);
            ParseTree include2 = IncludeCache.get(file, env, t);
            if (include2 != null) {
                StackTraceManager stManager = env.getEnv(GlobalEnv.class).GetStackTraceManager();
                stManager.addStackTraceElement(new ConfigRuntimeException.StackTraceElement("<<include " + arg.val() + ">>", t));
                try {
                    parent.eval(include2.getChildAt(0), env);
                }
                catch (AbstractCREException e) {
                    e.freezeStackTraceElements(stManager);
                    throw e;
                }
                catch (StackOverflowError e) {
                    throw new CREStackOverflowError(null, t, e);
                }
                finally {
                    stManager.popStackTraceElement();
                }
            }
            return CVoid.VOID;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public LogLevel profileAt() {
            return LogLevel.ERROR;
        }

        @Override
        public String profileMessageS(List<ParseTree> args) {
            String m = "Executing function: include(";
            m = args.get(0).isConst() ? m + args.get(0).getData().val() : m + "<dynamic input>";
            return m + ")";
        }
    }

    @api
    @unbreakable
    public static class proc
    extends AbstractFunction
    implements BranchStatement,
    VariableScope {
        @Override
        public String getName() {
            return "proc";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "void {procName, [params...], procCode} Creates a new user defined procedure (also known as \"function\"), with the given name and parameters, that can be called later in code. The name of the procedure must be a constant and its parameters must be variables. Please see the more detailed documentation on procedures for more information. In general, brace syntax and keyword usage is preferred: proc _myProc(@a, @b){ procCode(@a, @b); }";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_3;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            Procedure myProc = proc.getProcedure(t, env, parent, nodes);
            env.getEnv(GlobalEnv.class).GetProcs().put(myProc.getName(), myProc);
            return CVoid.VOID;
        }

        public static Procedure getProcedure(Target t, Environment env, Script parent, ParseTree ... nodes) {
            int i;
            String name = "";
            ArrayList<IVariable> vars = new ArrayList<IVariable>();
            ParseTree tree = null;
            ArrayList<String> varNames = new ArrayList<String>();
            boolean usesAssign = false;
            CClassType returnType = Auto.TYPE;
            if (nodes[0].getData().isInstanceOf(CClassType.class)) {
                returnType = (CClassType)nodes[0].getData();
                ParseTree[] newNodes = new ParseTree[nodes.length - 1];
                for (i = 1; i < nodes.length; ++i) {
                    newNodes[i - 1] = nodes[i];
                }
                nodes = newNodes;
            }
            IVariableList originalList = env.getEnv(GlobalEnv.class).GetVarList().clone();
            for (i = 0; i < nodes.length; ++i) {
                if (i == nodes.length - 1) {
                    tree = nodes[i];
                    continue;
                }
                boolean thisNodeIsAssign = false;
                if (nodes[i].getData() instanceof CFunction && ((CFunction)nodes[i].getData()).val().equals("assign")) {
                    thisNodeIsAssign = true;
                    if (nodes[i].getChildren().size() == 3 && Construct.IsDynamicHelper(nodes[i].getChildAt(0).getData()) || Construct.IsDynamicHelper(nodes[i].getChildAt(1).getData())) {
                        usesAssign = true;
                    }
                }
                env.getEnv(GlobalEnv.class).SetFlag("no-check-duplicate-assign", true);
                Mixed cons = parent.eval(nodes[i], env);
                env.getEnv(GlobalEnv.class).ClearFlag("no-check-duplicate-assign");
                if (i == 0 && cons instanceof IVariable) {
                    throw new CREInvalidProcedureException("Anonymous Procedures are not allowed", t);
                }
                if (i == 0 && !(cons instanceof IVariable)) {
                    name = cons.val();
                    continue;
                }
                if (!(cons instanceof IVariable)) {
                    throw new CREInvalidProcedureException("You must use IVariables as the arguments", t);
                }
                IVariable ivar = null;
                try {
                    Mixed c = cons;
                    if (c instanceof IVariable) {
                        String varName = ((IVariable)c).getVariableName();
                        if (varNames.contains(varName)) {
                            throw new CREInvalidProcedureException("Same variable name defined twice in " + name, t);
                        }
                        varNames.add(varName);
                    }
                    while (c instanceof IVariable) {
                        c = env.getEnv(GlobalEnv.class).GetVarList().get(((IVariable)c).getVariableName(), t, true, env).ival();
                    }
                    if (!thisNodeIsAssign) {
                        c = new CString("", t);
                    }
                    ivar = new IVariable(((IVariable)cons).getDefinedType(), ((IVariable)cons).getVariableName(), c.clone(), t, env);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                vars.add(ivar);
            }
            env.getEnv(GlobalEnv.class).SetVarList(originalList);
            Procedure myProc = new Procedure(name, returnType, vars, tree, t);
            if (usesAssign) {
                myProc.definitelyNotConstant();
            }
            return myProc;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        public static Mixed optimizeProcedure(Target t, Procedure myProc, List<ParseTree> children) throws ConfigRuntimeException {
            if (myProc.isPossiblyConstant()) {
                try {
                    FileOptions options = new FileOptions(new HashMap<String, String>());
                    if (!children.isEmpty()) {
                        options = children.get(0).getFileOptions();
                    }
                    ParseTree root = new ParseTree(new CFunction("__autoconcat__", Target.UNKNOWN), options);
                    Script fakeScript = Script.GenerateScript(root, "*");
                    Environment env = Static.GenerateStandaloneEnvironment();
                    env.getEnv(GlobalEnv.class).SetScript(fakeScript);
                    Mixed c = myProc.cexecute(children, env, t);
                    return c;
                }
                catch (ConfigRuntimeException e) {
                    if (e instanceof CREThrowable && ((CREThrowable)e).isInstanceOf(CREInvalidProcedureException.class)) {
                        return null;
                    }
                    throw e;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(children.size());
            for (int i = 0; i < children.size() - 1; ++i) {
                ret.add(false);
            }
            ret.add(true);
            return ret;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(children.size());
            for (ParseTree child : children) {
                ret.add(true);
            }
            return ret;
        }
    }

    @api
    public static class is_integral
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_integral";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns true if the numeric value represented by  a given double or numeric string could be cast to an integer without losing data (or if it's an integer). For instance, is_numeric(4.5) would return true, and integer(4.5) would work, however, equals(4.5, integer(4.5)) returns false, because the value was narrowed to 4.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            double d;
            try {
                d = Static.getDouble(args[0], t);
            }
            catch (ConfigRuntimeException e) {
                return CBoolean.FALSE;
            }
            return CBoolean.get((double)((long)d) == d);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_integral(1.0)"), new ExampleScript("True condition", "is_integral(1)"), new ExampleScript("True condition", "is_integral('5.0')"), new ExampleScript("True condition", "is_integral('6')"), new ExampleScript("False condition", "is_integral(1.5)"), new ExampleScript("True condition, because null is coerced to 0, which is integral", "is_integral(null)")};
        }
    }

    @api
    public static class is_numeric
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_numeric";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns false if the item would fail if it were used as a numeric value. If it can be parsed or otherwise converted into a numeric value, true is returned.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean b = true;
            try {
                Static.getNumber(args[0], t);
            }
            catch (ConfigRuntimeException e) {
                b = false;
            }
            return CBoolean.get(b);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_numeric('1.0')"), new ExampleScript("True condition", "is_numeric('1')"), new ExampleScript("True condition", "is_numeric(1)"), new ExampleScript("True condition", "is_numeric(1.5)"), new ExampleScript("False condition", "is_numeric('string')"), new ExampleScript("True condition, because null is coerced to 0.0, which is numeric.", "is_numeric(null)")};
        }
    }

    @api
    public static class is_null
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_null";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the given item is null.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0] instanceof CNull);
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_null(null)"), new ExampleScript("False condition", "is_null(0)")};
        }
    }

    @api
    public static class is_boolean
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_boolean";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether the given item is of the boolean datatype. Note that all datatypes can be used as booleans, however this function checks the specific datatype of the given item.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CBoolean.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_boolean(false)"), new ExampleScript("False condition", "is_boolean(0)")};
        }
    }

    @api
    public static class is_integer
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_integer";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the given item is an integer. Note that numeric strings can usually be used as integers, however this function checks the actual datatype of the item. If you just want to see if an item can be used as a number, use is_integral() or is_numeric() instead.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CInt.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_integer(1)"), new ExampleScript("False condition", "is_integer(1.0)")};
        }
    }

    @api
    public static class is_double
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_double";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the given item is a double. Note that numeric strings and integers can usually be used as a double, however this function checks the actual datatype of the item. If you just want to see if an item can be used as a number, use is_numeric() instead.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CDouble.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_double(1.0)"), new ExampleScript("False condition", "is_double(1)")};
        }
    }

    @api
    public static class is_number
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_number";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the given item is an integer or a double. Note that numeric strings can usually be used as integers and doubles, however this function checks the actual datatype of the item. If you just want to see if an item can be used as a number, use is_integral() or is_numeric() instead.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CInt.class) || args[0].isInstanceOf(CDouble.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_number(1)"), new ExampleScript("True condition", "is_number(1.0)"), new ExampleScript("False condition", "is_number('1')"), new ExampleScript("False condition", "is_number('1.0')")};
        }
    }

    @api
    public static class is_array
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_array";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the item is an array";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CArray.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_array(array(1))"), new ExampleScript("True condition", "is_array(array(one: 1))"), new ExampleScript("False condition", "is_array('no')")};
        }
    }

    @api
    public static class is_bytearray
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_bytearray";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the item is actually a ByteArray datatype.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CByteArray.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_bytearray(string_get_bytes('yay'))"), new ExampleScript("False condition", "is_bytearray('Nay')"), new ExampleScript("False condition", "is_bytearray(123)")};
        }
    }

    @api
    public static class is_string
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_string";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the item is actually a string datatype. If you just care if some data can be used as a string, use is_stringable().";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(args[0].isInstanceOf(CString.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_string('yes')"), new ExampleScript("False condition", "is_string(1) #is_stringable() would return true here")};
        }
    }

    @api
    public static class is_stringable
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "is_stringable";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {item} Returns whether or not the item is convertable to a string. Everything but arrays can be used as strings.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(!args[0].isInstanceOf(CArray.class));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("True condition", "is_stringable('yes')"), new ExampleScript("True condition", "is_stringable(1) #This can be used as a string, yes"), new ExampleScript("False condition", "is_stringable(array(1))")};
        }
    }

    @api
    @seealso(value={Variables.class})
    public static class assign
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "assign";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            CClassType type;
            String name;
            int offset;
            IVariableList list = env.getEnv(GlobalEnv.class).GetVarList();
            if (args.length == 3) {
                offset = 1;
                if (!(args[offset] instanceof IVariable)) {
                    throw new CRECastException(this.getName() + " with 3 arguments only accepts an ivariable as the second argument.", t);
                }
                name = ((IVariable)args[offset]).getVariableName();
                if (list.has(name) && env.getEnv(GlobalEnv.class).GetFlag("no-check-duplicate-assign") == null) {
                    if (env.getEnv(GlobalEnv.class).GetFlag("closure-warn-overwrite") != null) {
                        MSLog.GetLogger().Log(MSLog.Tags.RUNTIME, LogLevel.ERROR, "The variable " + name + " is hiding another value of the same name in the main scope.", t);
                    } else {
                        MSLog.GetLogger().Log(MSLog.Tags.RUNTIME, LogLevel.ERROR, name + " was already defined at " + list.get(name, t, true, env).getDefinedTarget() + " but is being redefined.", t);
                    }
                }
                type = ArgumentValidation.getClassType(args[0], t);
            } else {
                offset = 0;
                if (!(args[offset] instanceof IVariable)) {
                    throw new CRECastException(this.getName() + " with 2 arguments only accepts an ivariable as the first argument.", t);
                }
                name = ((IVariable)args[offset]).getVariableName();
                type = list.get(name, t, true, env).getDefinedType();
            }
            Mixed c = args[offset + 1];
            while (c instanceof IVariable) {
                IVariable cur = (IVariable)c;
                c = list.get(cur.getVariableName(), cur.getTarget(), env).ival();
            }
            IVariable v = new IVariable(type, name, c, t, env);
            list.set(v);
            return v;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public String docs() {
            return "ivariable {[type], ivar, mixed} Accepts an ivariable ivar as a parameter, and puts the specified value mixed in it. Returns the variable that was assigned. Operator syntax is also supported: <code>@a = 5;</code>. Other forms are supported as well, +=, -=, *=, /=, .=, which do multiple operations at once. Array assigns are also supported: @array[5] = 'new value in index 5';";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_CONSTANT, Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public Mixed optimize(Target t, Environment env, Mixed ... args) throws ConfigCompileException {
            int offset = 0;
            if (args.length == 3) {
                offset = 1;
                if (!args[0].isInstanceOf(CClassType.class)) {
                    throw new ConfigCompileException("Expecting a ClassType for parameter 1 to assign", t);
                }
            }
            if (args.length > 0 && !(args[offset] instanceof IVariable)) {
                throw new ConfigCompileException("Expecting an ivar for argument 1 to assign", t);
            }
            return null;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 2) {
                return null;
            }
            if (children.get(0).getData() instanceof IVariable && children.get(1).getData() instanceof IVariable && ((IVariable)children.get(0).getData()).getVariableName().equals(((IVariable)children.get(1).getData()).getVariableName())) {
                MSLog.GetLogger().Log(MSLog.Tags.COMPILER, LogLevel.WARNING, "Assigning a variable to itself", t);
            }
            if (children.get(0).getData() instanceof CFunction && array_get.equals(children.get(0).getData().val())) {
                if (children.get(0).getChildAt(1).getData() instanceof CSlice) {
                    CSlice cs = (CSlice)children.get(0).getChildAt(1).getData();
                    if (cs.getStart() == 0L && cs.getFinish() == -1L) {
                        ParseTree tree = new ParseTree(new CFunction(array_push, t), children.get(0).getFileOptions());
                        tree.addChild(children.get(0).getChildAt(0));
                        tree.addChild(children.get(1));
                        return tree;
                    }
                } else {
                    ParseTree tree = new ParseTree(new CFunction(array_set, t), children.get(0).getFileOptions());
                    tree.addChild(children.get(0).getChildAt(0));
                    tree.addChild(children.get(0).getChildAt(1));
                    tree.addChild(children.get(1));
                    return tree;
                }
            }
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "assign(@variable, 5);\nmsg(@variable);"), new ExampleScript("Array assignment", "assign(@variable, associative_array());\nassign(@variable['associative'], 5);\nmsg(@variable);"), new ExampleScript("String assignment with type", "assign(string, @s, 'string');"), new ExampleScript("String assignment with invalid type", "assign(int, @i, 'string');", true), new ExampleScript("Operator syntax", "@variable = 5;\nmsg(@variable);"), new ExampleScript("Operator syntax with type", "string @s = 'string';"), new ExampleScript("Operator syntax using combined operators", "@variable = 'string';\n@variable .= ' more string';\nmsg(@variable);"), new ExampleScript("Operator syntax using combined operators", "@variable = 5;\n@variable += 10;\nmsg(@variable);"), new ExampleScript("Operator syntax using combined operators", "@variable = 5;\n@variable -= 10;\nmsg(@variable);"), new ExampleScript("Operator syntax using combined operators", "@variable = 5;\n@variable *= 10;\nmsg(@variable);"), new ExampleScript("Operator syntax using combined operators", "@variable = 5;\n@variable /= 10;\nmsg(@variable);")};
        }
    }

    @api
    @seealso(value={Arrays.class, ArrayIteration.class})
    public static class associative_array
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray array2 = CArray.GetAssociativeArray(t, args);
            return array2;
        }

        @Override
        public String getName() {
            return "associative_array";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "array {[args...]} Works exactly like array(), except the array created will be an associative array, even if the array has been created with no elements. This is the only use case where this is neccessary, vs using the normal array() function, or in the case where you assign sequential keys anyways, and the same array could have been created using array().";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Usage with an empty array", "assign(@array, associative_array())\nmsg(is_associative(@array))"), new ExampleScript("Usage with an array with sequential keys", "assign(@array, array(0: '0', 1: '1'))\nmsg(is_associative(@array))\nassign(@array, associative_array(0: '0', 1: '1'))\nmsg(is_associative(@array))")};
        }
    }

    @api
    @seealso(value={Arrays.class, ArrayIteration.class})
    public static class array
    extends AbstractFunction
    implements Optimizable {
        FileOptions lastFileOptions = null;

        @Override
        public String getName() {
            return "array";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return new CArray(t, args);
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public String docs() {
            return "array {[var1, [var2...]]} Creates an array of values.";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "assign(@array, array(1, 2, 3))\nmsg(@array)"), new ExampleScript("Associative array creation", "assign(@array, array(one: 'apple', two: 'banana'))\nmsg(@array)")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            for (ParseTree child : children) {
                if (!(child.getData() instanceof CFunction) || !new Compiler.centry().getName().equals(child.getData().val())) continue;
                if (((CLabel)child.getChildAt(0).getData()).cVal() instanceof CSlice) {
                    throw new ConfigCompileException("Slices cannot be used as array indices", child.getChildAt(0).getTarget());
                }
                if (!(((CLabel)child.getChildAt(0).getData()).cVal() instanceof IVariable)) continue;
                String array2 = "@a";
                String valueName = ((IVariable)((CLabel)child.getChildAt(0).getData()).cVal()).getVariableName();
                Mixed value = child.getChildAt(1).getData();
                String v = value instanceof IVariable ? ((IVariable)value).getVariableName() : (value.isInstanceOf(CString.class) ? ((CString)value).getQuote() : "@value");
                if ("@a".equals(valueName)) {
                    array2 = "@myArray";
                }
                throw new ConfigCompileException("Dynamic values cannot be used as indices in array construction.\nTo make dynamic indicies, do the following: array " + array2 + " = array(); " + array2 + "[" + valueName + "] = " + v + ";", t);
            }
            return null;
        }
    }
}

