/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.objects;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.ZipReader;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.DuplicateObjectDefintionException;
import com.laytonsmith.core.objects.ObjectDefinition;
import com.laytonsmith.core.objects.ObjectDefinitionNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class ObjectDefinitionTable
implements Iterable<ObjectDefinition> {
    private final Map<String, ObjectDefinition> classList;
    private final AtomicBoolean nativeTypesAdded = new AtomicBoolean(false);

    private ObjectDefinitionTable() {
        this.classList = new ConcurrentHashMap<String, ObjectDefinition>(NativeTypeList.getNativeTypeList().size());
    }

    public static ObjectDefinitionTable GetNewInstance(Environment env) {
        ObjectDefinitionTable table = new ObjectDefinitionTable();
        table.addNativeTypes(env);
        return table;
    }

    public static ObjectDefinitionTable GetBlankInstance() {
        return new ObjectDefinitionTable();
    }

    public void addNativeTypes(Environment env) {
        if (this.nativeTypesAdded.compareAndSet(false, true)) {
            ArrayList<IOException> oops = new ArrayList<IOException>();
            if (ObjectDefinitionTable.class.getResource("/nativeSource.ser") != null) {
                throw new UnsupportedOperationException();
            }
            LinkedList msFiles = new LinkedList();
            try {
                LinkedList<File> q = new LinkedList<File>();
                File root = new File(ObjectDefinitionTable.class.getResource("/nativeSource").toExternalForm());
                ZipReader zipReader = new ZipReader(root);
                q.addAll(Arrays.asList(zipReader.listFiles()));
                while (q.peek() != null) {
                    ZipReader r = new ZipReader((File)q.peek());
                    if (r.isDirectory()) {
                        q.addAll(Arrays.asList(r.listFiles()));
                        q.poll();
                        continue;
                    }
                    msFiles.add(q.poll());
                }
            }
            catch (IOException ex) {
                oops.add(ex);
            }
            ((Stream)msFiles.stream().parallel()).forEach((? super T file) -> {
                try {
                    String script = FileUtil.read(file);
                    TokenStream ts = MethodScriptCompiler.lex(script, file, true);
                    MethodScriptCompiler.compile(ts, env);
                }
                catch (ConfigCompileGroupException g2) {
                    oops.addAll(g2.getList());
                }
                catch (ConfigCompileException | IOException ex) {
                    oops.add((IOException)ex);
                }
            });
            if (!oops.isEmpty()) {
                ArrayList<String> b = new ArrayList<String>();
                for (Exception exception : oops) {
                    if (exception instanceof ConfigCompileException) {
                        ConfigCompileException cce = (ConfigCompileException)exception;
                        b.add(cce.getMessage() + " " + cce.getFile() + ":" + cce.getLineNum() + "." + cce.getColumn());
                        continue;
                    }
                    b.add(exception.getMessage() + "\n" + StackTraceUtils.GetStacktrace(exception));
                }
                throw new Error("One or more exceptions occured while trying to compile the native files!\n" + StringUtils.Join(b, "\n"));
            }
        }
    }

    @Override
    public Iterator<ObjectDefinition> iterator() {
        return this.classList.values().iterator();
    }

    @Override
    public void forEach(Consumer<? super ObjectDefinition> action) {
        this.classList.values().forEach(action);
    }

    @Override
    public Spliterator<ObjectDefinition> spliterator() {
        return this.classList.values().spliterator();
    }

    private ObjectDefinition get(String fullyQualifiedClassName) throws ObjectDefinitionNotFoundException {
        if (this.classList.containsKey(fullyQualifiedClassName)) {
            return this.classList.get(fullyQualifiedClassName);
        }
        throw new ObjectDefinitionNotFoundException(fullyQualifiedClassName + " could not be found.");
    }

    public ObjectDefinition get(FullyQualifiedClassName fullyQualifiedClassName) throws ObjectDefinitionNotFoundException {
        return this.get(fullyQualifiedClassName.getFQCN());
    }

    public ObjectDefinition get(Class<? extends Mixed> clazz) {
        try {
            return this.get(clazz.getAnnotation(typeof.class).value());
        }
        catch (ObjectDefinitionNotFoundException ex) {
            throw new Error("Missing ObjectDefinition for native class: " + clazz.getName(), ex);
        }
    }

    public void add(ObjectDefinition object, Target t) throws DuplicateObjectDefintionException {
        if (this.classList.containsKey(object.getClassName())) {
            String msg2 = "The class " + object.getClassName() + " was attempted to be redefined.";
            boolean isCopy = false;
            if (this.classList.get(object.getClassName()).exactlyEquals(object)) {
                msg2 = msg2 + " The object appears to be an identical definition, is code running twice that shouldn't?";
                isCopy = true;
            }
            throw new DuplicateObjectDefintionException(msg2, t, isCopy);
        }
        this.classList.put(object.getClassName(), object);
    }

    public Set<ObjectDefinition> getObjectDefinitionSet() {
        return new HashSet<ObjectDefinition>(this.classList.values());
    }
}

