/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.packetjumper;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class PacketInfo
implements Comparable<PacketInfo> {
    private final int packetID;
    private final String packetName;
    private final Class<?> packetClass;
    private final Constructor<?>[] constructors;
    private final Class[][] arguments;
    private final String docs;

    public PacketInfo(Class<?> packetClass) {
        this.packetClass = packetClass;
        this.constructors = packetClass.getConstructors();
        this.arguments = new Class[this.constructors.length][];
        for (int i = 0; i < this.constructors.length; ++i) {
            Constructor<?> constructor = this.constructors[i];
            this.arguments[i] = constructor.getParameterTypes();
        }
        this.packetID = Integer.parseInt(packetClass.getSimpleName().replaceAll(".*?(\\d+).*", "$1"));
        this.packetName = packetClass.getSimpleName().replaceAll(".*\\d+(.*)", "$1");
        this.docs = "Docs coming soon!";
    }

    public int getPacketID() {
        return this.packetID;
    }

    public String getPacketName() {
        return this.packetName;
    }

    public Class<?> getPacketClass() {
        return this.packetClass;
    }

    public Constructor<?>[] getConstructors() {
        return this.constructors;
    }

    public Class[] getArguments() {
        Class[] a = new Class[this.arguments.length];
        System.arraycopy(this.arguments, 0, a, 0, this.arguments.length);
        return a;
    }

    public String getDocs() {
        return this.docs;
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        for (Object[] objectArray : this.arguments) {
            l.add(StringUtils.Join(objectArray, ", "));
        }
        return this.packetClass.getName() + "(" + StringUtils.Join(l, " | ") + ")";
    }

    @Override
    public int compareTo(PacketInfo o) {
        if (this.packetID == o.packetID) {
            return 0;
        }
        return this.packetID < o.packetID ? -1 : 1;
    }
}

