/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.MemoryMapFileUtil;
import com.laytonsmith.PureUtilities.RunnableQueue;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.persistence.AbstractDataSource;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

@datasource(value="ser")
public class SerializedPersistence
extends AbstractDataSource {
    private HashMap<String, String> data = new HashMap();
    private HashMap<String, String> transactionData = new HashMap();
    private boolean isLoaded = false;
    private boolean finishedInitializing = false;
    private static RunnableQueue queue = new RunnableQueue("SerializedPersistenceQueue");
    private File storageLocation;
    private byte[] byteData = ArrayUtils.EMPTY_BYTE_ARRAY;
    private MemoryMapFileUtil writer = null;
    private MemoryMapFileUtil.DataGrabber grabber = new MemoryMapFileUtil.DataGrabber(){

        @Override
        public byte[] getData() {
            return SerializedPersistence.this.byteData;
        }
    };

    private SerializedPersistence() {
    }

    public SerializedPersistence(File database) throws DataSourceException {
        super(database.toURI(), new ConnectionMixinFactory.ConnectionMixinOptions());
        this.storageLocation = database;
    }

    public SerializedPersistence(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
        String file;
        try {
            file = this.getConnectionMixin().getPath();
        }
        catch (IOException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        this.storageLocation = new File(file);
        this.finishedInitializing = true;
    }

    public Map<String, String> rawData() {
        return this.data;
    }

    private void load() throws Exception {
        if (!this.isLoaded) {
            queue.invokeAndWait(new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    try {
                        FileInputStream fis = null;
                        ObjectInputStream in = null;
                        try {
                            if (!SerializedPersistence.this.storageLocation.exists()) {
                                SerializedPersistence.this.storageLocation.createNewFile();
                            }
                            if (SerializedPersistence.this.storageLocation.length() == 0L) {
                                SerializedPersistence.this.data = new HashMap();
                            } else {
                                fis = new FileInputStream(SerializedPersistence.this.storageLocation);
                                in = new ObjectInputStream(fis);
                                SerializedPersistence.this.data = (HashMap)in.readObject();
                            }
                            SerializedPersistence.this.isLoaded = true;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (FileNotFoundException fis) {
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    return null;
                }
            });
        }
    }

    private void save(final DaemonManager dm) throws IOException {
        if (!this.inTransaction()) {
            if (this.writer == null) {
                this.writer = MemoryMapFileUtil.getInstance(this.storageLocation, this.grabber);
            }
            queue.invokeLater(dm, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ObjectOutputStream out = null;
                    ByteArrayOutputStream baos = null;
                    try {
                        if (SerializedPersistence.this.storageLocation.getParentFile() != null) {
                            SerializedPersistence.this.storageLocation.getParentFile().mkdirs();
                        }
                        if (!SerializedPersistence.this.storageLocation.exists()) {
                            SerializedPersistence.this.storageLocation.createNewFile();
                        }
                        baos = new ByteArrayOutputStream();
                        out = new ObjectOutputStream(baos);
                        out.writeObject(new HashMap(SerializedPersistence.this.data));
                        SerializedPersistence.access$302(SerializedPersistence.this, baos.toByteArray());
                        SerializedPersistence.this.writer.mark(dm);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SerializedPersistence.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    finally {
                        try {
                            if (baos != null) {
                                baos.close();
                            }
                        }
                        catch (IOException ex) {
                            Logger.getLogger(SerializedPersistence.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ex) {
                            Logger.getLogger(SerializedPersistence.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            });
        }
    }

    private String setValue(DaemonManager dm, String key, String value) {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (Exception ex) {
                Logger.getLogger("Minecraft").log(Level.SEVERE, null, ex);
            }
        }
        String oldVal = this.data.get(key);
        if (value == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, value);
        }
        try {
            this.save(dm);
        }
        catch (Exception ex) {
            Logger.getLogger(SerializedPersistence.class.getName()).log(Level.SEVERE, null, ex);
        }
        return oldVal;
    }

    private String setValue(DaemonManager dm, String[] key, String value) {
        return this.setValue(dm, SerializedPersistence.getNamespace0(key), value);
    }

    private String getValue(String key) {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (Exception ex) {
                Logger.getLogger(SerializedPersistence.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    private static String getNamespace0(String[] key) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < key.length; ++i) {
            if (i > 0) {
                b.append(".").append(key[i]);
                continue;
            }
            b.append(key[i]);
        }
        return b.toString();
    }

    @Override
    public Set<String[]> keySet(String[] keyBase) {
        HashSet<String[]> list = new HashSet<String[]>();
        String kb = StringUtils.Join(keyBase, ".");
        for (String key : this.data.keySet()) {
            if (!key.startsWith(kb)) continue;
            list.add(key.split("\\."));
        }
        return list;
    }

    @Override
    public String get0(String[] key) {
        return this.getValue(StringUtils.Join(key, "."));
    }

    @Override
    public boolean set0(DaemonManager dm, String[] key, String value) throws ReadOnlyException, IOException {
        this.setValue(dm, key, value);
        this.save(dm);
        return true;
    }

    @Override
    public void populate() throws DataSourceException {
        if (!this.finishedInitializing) {
            return;
        }
        try {
            this.load();
        }
        catch (Exception ex) {
            throw new DataSourceException(null, ex);
        }
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> implicitModifiers() {
        return null;
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> invalidModifiers() {
        return EnumSet.of(DataSource.DataSourceModifier.HTTP, DataSource.DataSourceModifier.HTTPS, DataSource.DataSourceModifier.PRETTYPRINT);
    }

    @Override
    public String docs() {
        return "Serialized Persistence {ser:///path/to/persistence.ser} The default type, this simply uses java serialization to store data. Extremely simple to use, it is less scalable than database driven solutions, but for a file based solution, is relatively efficient, since it is stored as binary data. This means that it cannot be easily edited however.";
    }

    @Override
    public MSVersion since() {
        return MSVersion.V3_0_2;
    }

    @Override
    protected void startTransaction0(DaemonManager dm) {
        this.transactionData = (HashMap)this.data.clone();
    }

    @Override
    protected void stopTransaction0(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        if (!rollback) {
            this.save(dm);
        } else {
            this.data = this.transactionData;
        }
        this.transactionData = null;
    }

    @Override
    public void disconnect() {
    }

    static /* synthetic */ byte[] access$302(SerializedPersistence x0, byte[] x1) {
        x0.byteData = x1;
        return x1;
    }
}

