/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.HTMLUtils;
import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Common.WinRegistry;
import com.laytonsmith.PureUtilities.LimitedQueue;
import com.laytonsmith.PureUtilities.RunnableQueue;
import com.laytonsmith.PureUtilities.SignalHandler;
import com.laytonsmith.PureUtilities.SignalType;
import com.laytonsmith.PureUtilities.Signals;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.ZipReader;
import com.laytonsmith.abstraction.AbstractConvertor;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCEnchantment;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCFireworkBuilder;
import com.laytonsmith.abstraction.MCInventory;
import com.laytonsmith.abstraction.MCInventoryHolder;
import com.laytonsmith.abstraction.MCItemMeta;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCMetadataValue;
import com.laytonsmith.abstraction.MCNote;
import com.laytonsmith.abstraction.MCPattern;
import com.laytonsmith.abstraction.MCPlugin;
import com.laytonsmith.abstraction.MCPluginMeta;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCRecipe;
import com.laytonsmith.abstraction.MCServer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.enums.MCDyeColor;
import com.laytonsmith.abstraction.enums.MCPatternShape;
import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import com.laytonsmith.abstraction.enums.MCTone;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.convert;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.Installer;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.MethodScriptComplete;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.InvalidEnvironmentException;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.events.drivers.CmdlineEvents;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.Cmdline;
import com.laytonsmith.core.functions.Echoes;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.ProfilePoint;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.tools.ShellEventMixin;
import com.laytonsmith.tools.docgen.DocGen;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;

public final class Interpreter {
    private static final String INTERPRETER_INSTALLATION_LOCATION = "/usr/local/bin/";
    private boolean inTTYMode = false;
    private boolean multilineMode = false;
    private boolean inShellMode = false;
    private String script = "";
    private Environment env;
    private Thread scriptThread = null;
    private volatile boolean isExecuting = false;
    private final Queue<String> commandHistory = new LimitedQueue<String>(100);
    private volatile int ctrlCcount = 0;
    private static final int MAX_CTRL_C_MASHES = 5;
    private static final int MAX_COMMAND_HISTORY = 100;

    public static void startWithTTY(File file, List<String> args, boolean systemExitOnFailure) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        Interpreter.startWithTTY(file.getCanonicalPath(), args, systemExitOnFailure);
    }

    public static void startWithTTY(String file, List<String> args) throws Profiles.InvalidProfileException, IOException, DataSourceException, URISyntaxException {
        Interpreter.startWithTTY(file, args, true);
    }

    public static void startWithTTY(String file, List<String> args, boolean systemExitOnFailure) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        block4: {
            File fromFile = new File(file).getCanonicalFile();
            Interpreter interpreter = new Interpreter(args, fromFile.getParentFile().getPath(), true);
            try {
                interpreter.execute(FileUtil.read(fromFile), args, fromFile);
            }
            catch (ConfigCompileException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, null, null);
                StreamUtils.GetSystemOut().println(TermColors.reset());
                if (systemExitOnFailure) {
                    System.exit(1);
                }
            }
            catch (ConfigCompileGroupException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, null);
                StreamUtils.GetSystemOut().println(TermColors.reset());
                if (!systemExitOnFailure) break block4;
                System.exit(1);
            }
        }
    }

    private String getHelpMsg() {
        String msg2 = TermColors.YELLOW + "You are now in cmdline interpreter mode.\n- on a line by itself (outside of mulitline mode), or the exit() command exits the shell.\n>>> on a line by itself starts multiline mode, where multiple lines can be written, but not yet executed.\n<<< on a line by itself ends multiline mode, and executes the buffered script.\n- on a line by itself while in multiline mode cancels multiline mode, and clears the buffer, without executing the buffered script.\nIf the line starts with $$, then the rest of the line is taken to be a shell command. The command is taken as a string, wrapped\nin shell_adv(), (where system out and system err are piped to the corresponding outputs).\nIf $$ is on a line by itself, it puts the shell in shell_adv mode, and each line is taken as if it started\nwith $$. Use - on a line by itself to exit this mode as well.\n\nFor more information about a specific function, type \"help function\"\nand for documentation plus examples, type \"examples function\". See the api tool\nfor more information about this feature.";
        try {
            msg2 = msg2 + "\nYour current working directory is: " + this.env.getEnv(GlobalEnv.class).GetRootFolder().getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return msg2;
    }

    public Interpreter(List<String> args, String cwd) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        this(args, cwd, false);
    }

    private Interpreter(List<String> args, String cwd, boolean inTTYMode) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        this.doStartup();
        this.env.getEnv(GlobalEnv.class).SetRootFolder(new File(cwd));
        if (inTTYMode) {
            return;
        }
        if (System.console() == null) {
            Scanner scanner = new Scanner(System.in);
            StringBuilder script = new StringBuilder();
            try {
                String line;
                while ((line = scanner.nextLine()) != null) {
                    script.append(line).append("\n");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                this.execute(script.toString(), args);
                StreamUtils.GetSystemOut().print(TermColors.reset());
                System.exit(0);
            }
            catch (ConfigCompileException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, null, null);
                StreamUtils.GetSystemOut().print(TermColors.reset());
                System.exit(1);
            }
            catch (ConfigCompileGroupException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, null);
                StreamUtils.GetSystemOut().println(TermColors.reset());
                System.exit(1);
            }
        } else {
            String prompt;
            String line;
            ConsoleReader reader = new ConsoleReader();
            reader.setExpandEvents(false);
            Set<FunctionBase> functions = FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA);
            ArrayList<String> names = new ArrayList<String>();
            for (FunctionBase f : functions) {
                if (!f.appearInDocumentation()) continue;
                names.add(f.getName());
            }
            reader.addCompleter((Completer)new ArgumentCompleter((ArgumentCompleter.ArgumentDelimiter)new ArgumentCompleter.AbstractArgumentDelimiter(){

                public boolean isDelimiterChar(CharSequence buffer, int pos) {
                    char c = buffer.charAt(pos);
                    return !Character.isLetter(c) && c != '_';
                }
            }, new Completer[]{new StringsCompleter(names){

                public int complete(String buffer, int cursor, List<CharSequence> candidates) {
                    int ret = super.complete(buffer, cursor, candidates);
                    if (candidates.size() == 1) {
                        String functionName = candidates.get(0).toString().trim();
                        candidates.set(0, functionName + "()");
                    }
                    return ret;
                }
            }}));
            while (this.textLine(line = reader.readLine(prompt = this.multilineMode ? TermColors.WHITE + ">" + TermColors.reset() : this.getPrompt()))) {
            }
        }
    }

    private String getPrompt() {
        CClosure c = (CClosure)this.env.getEnv(GlobalEnv.class).GetCustom("cmdline_prompt");
        if (c != null) {
            try {
                String val = c.executeCallable(CBoolean.get(this.inShellMode)).val();
                return Static.MCToANSIColors(val) + TermColors.RESET;
            }
            catch (ConfigRuntimeException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, this.env);
            }
        }
        return TermColors.BLUE + ":" + TermColors.RESET;
    }

    private void doStartup() throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        Installer.Install(MethodScriptFileLocations.getDefault().getConfigDirectory());
        Installer.InstallCmdlineInterpreter();
        this.env = Static.GenerateStandaloneEnvironment(false);
        this.env.getEnv(GlobalEnv.class).SetCustom("cmdline", true);
        if (Prefs.UseColors().booleanValue()) {
            TermColors.EnableColors();
        } else {
            TermColors.DisableColors();
        }
        String autoInclude = FileUtil.read(MethodScriptFileLocations.getDefault().getCmdlineInterpreterAutoIncludeFile());
        try {
            MethodScriptCompiler.execute(autoInclude, MethodScriptFileLocations.getDefault().getCmdlineInterpreterAutoIncludeFile(), true, this.env, null, null, null);
        }
        catch (ConfigCompileException ex) {
            ConfigRuntimeException.HandleUncaughtException(ex, "Interpreter will continue to run, however.", null);
        }
        catch (ConfigCompileGroupException ex) {
            ConfigRuntimeException.HandleUncaughtException(ex, null);
        }
        SignalHandler.SignalCallback signalHandler = new SignalHandler.SignalCallback(){

            @Override
            public boolean handle(SignalType type) {
                if (Interpreter.this.isExecuting) {
                    Interpreter.this.env.getEnv(GlobalEnv.class).SetInterrupt(true);
                    if (Interpreter.this.scriptThread != null) {
                        Interpreter.this.scriptThread.interrupt();
                    }
                    for (Thread t : Interpreter.this.env.getEnv(GlobalEnv.class).GetDaemonManager().getActiveThreads()) {
                        t.interrupt();
                    }
                } else {
                    Interpreter.this.ctrlCcount++;
                    if (Interpreter.this.ctrlCcount > 5) {
                        StreamUtils.GetSystemOut().println();
                        StreamUtils.GetSystemOut().flush();
                        System.exit(130);
                    }
                    TermColors.pl(TermColors.YELLOW + "\nUse exit() to exit the shell." + TermColors.reset());
                    TermColors.p(Interpreter.this.getPrompt());
                }
                return true;
            }
        };
        try {
            SignalHandler.addHandler(Signals.SIGTERM, signalHandler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignalHandler.addHandler(Signals.SIGINT, signalHandler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean textLine(String line) throws IOException {
        switch (line) {
            case "-": {
                if (this.multilineMode) {
                    this.script = "";
                    break;
                }
                if (this.inShellMode) {
                    this.inShellMode = false;
                    break;
                }
                return false;
            }
            case ">>>": {
                if (this.multilineMode) {
                    TermColors.pl(TermColors.RED + "You are already in multiline mode!");
                    break;
                }
                this.multilineMode = true;
                TermColors.pl(TermColors.YELLOW + "You are now in multiline mode. Type <<< on a line by itself to execute.");
                break;
            }
            case "<<<": {
                this.multilineMode = false;
                try {
                    this.execute(this.script, null);
                    this.script = "";
                }
                catch (ConfigCompileException e) {
                    ConfigRuntimeException.HandleUncaughtException(e, null, null);
                }
                catch (ConfigCompileGroupException e) {
                    ConfigRuntimeException.HandleUncaughtException(e, null);
                }
                break;
            }
            case "$$": {
                this.inShellMode = true;
                break;
            }
            default: {
                Pattern p2 = Pattern.compile("(help|examples) (.*)");
                Matcher m = p2.matcher(line);
                if (m.find()) {
                    String helpCommand = m.group(2);
                    try {
                        ArrayList<FunctionBase> fl = new ArrayList<FunctionBase>();
                        for (FunctionBase fb : FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA)) {
                            if (!fb.getName().matches("^" + helpCommand + "$")) continue;
                            fl.add(fb);
                        }
                        if (fl.isEmpty()) {
                            StreamUtils.GetSystemErr().println("Could not find function of name " + helpCommand);
                            break;
                        }
                        if (fl.size() == 1) {
                            StreamUtils.GetSystemOut().println(Interpreter.formatDocsForCmdline(helpCommand, m.group(1).equals("examples")));
                            break;
                        }
                        StreamUtils.GetSystemOut().println("Multiple function matches found:");
                        for (FunctionBase fb : fl) {
                            StreamUtils.GetSystemOut().println(fb.getName());
                        }
                        break;
                    }
                    catch (ConfigCompileException | DataSourceException | DocGenTemplates.Generator.GenerateException | IOException | URISyntaxException e) {
                        e.printStackTrace(StreamUtils.GetSystemErr());
                        break;
                    }
                }
                if (this.multilineMode) {
                    this.script = this.script + line + "\n";
                    break;
                }
                try {
                    this.execute(line, null);
                }
                catch (ConfigCompileException ex) {
                    ConfigRuntimeException.HandleUncaughtException(ex, null, null);
                }
                catch (ConfigCompileGroupException ex) {
                    ConfigRuntimeException.HandleUncaughtException(ex, null);
                }
                break;
            }
        }
        return true;
    }

    public static String formatDocsForCmdline(String function, boolean showExamples) throws ConfigCompileException, IOException, DataSourceException, URISyntaxException, DocGenTemplates.Generator.GenerateException {
        ExampleScript[] examples;
        Class<? extends CREThrowable>[] thrown;
        StringBuilder b = new StringBuilder();
        FunctionBase f = FunctionList.getFunction(function, Target.UNKNOWN);
        DocGen.DocInfo d = new DocGen.DocInfo(f.docs());
        b.append(TermColors.CYAN).append(d.ret).append(" ");
        b.append(TermColors.RESET).append(f.getName()).append("(").append(TermColors.MAGENTA).append(d.originalArgs).append(TermColors.RESET).append(")\n");
        if (f instanceof Function && (thrown = ((Function)f).thrown()) != null && thrown.length > 0) {
            b.append("Throws: ");
            Class<? extends Documentation>[] th = new HashSet();
            Class<? extends CREThrowable>[] classArray = thrown;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<? extends CREThrowable> c = classArray[i];
                if (c.getAnnotation(typeof.class) == null) continue;
                typeof t = c.getAnnotation(typeof.class);
                th.add(t.value());
            }
            b.append(TermColors.RED).append(StringUtils.Join(th, ", ")).append(TermColors.RESET).append("\n");
        }
        b.append("\n");
        String desc = Interpreter.reverseHTML(d.desc);
        b.append(TermColors.WHITE).append(desc).append("\n");
        if (d.extendedDesc != null) {
            desc = Interpreter.reverseHTML(d.extendedDesc);
            b.append(TermColors.WHITE).append(desc).append("\n");
        }
        if (f instanceof Function && f.getClass().getAnnotation(seealso.class) != null) {
            ArrayList<String> seeAlso = new ArrayList<String>();
            for (Class<? extends Documentation> c : ((Function)f).seeAlso()) {
                Documentation i = ReflectionUtils.newInstance(c);
                if (!(i instanceof Documentation)) continue;
                Documentation seeAlsoDocumentation = i;
                String color2 = TermColors.YELLOW;
                if (i instanceof Function) {
                    color2 = ((Function)f).isRestricted() ? TermColors.CYAN : TermColors.GREEN;
                }
                seeAlso.add(color2 + seeAlsoDocumentation.getName() + TermColors.RESET);
            }
            if (!seeAlso.isEmpty()) {
                b.append("See also: ");
                b.append(StringUtils.Join(seeAlso, ", ")).append("\n");
            }
        }
        if (f instanceof Function && showExamples && (examples = ((Function)f).examples()) != null && examples.length > 0) {
            b.append(TermColors.BOLD).append("\nExamples").append(TermColors.RESET).append("\n");
            b.append("----------------------------------------------\n\n");
            for (int i = 0; i < examples.length; ++i) {
                b.append(TermColors.BRIGHT_WHITE).append(TermColors.BOLD).append(TermColors.UNDERLINE).append("Example ").append(i + 1).append(TermColors.RESET).append("\n");
                if (i > 0) {
                    b.append("\n\n");
                }
                ExampleScript e = examples[i];
                b.append(e.getDescription()).append("\n\n");
                b.append(TermColors.UNDERLINE).append("Code").append(TermColors.RESET).append("\n").append(Interpreter.reverseHTML(DocGenTemplates.CODE.generate(e.getScript()))).append("\n\n");
                b.append(TermColors.UNDERLINE).append("Output").append(TermColors.RESET).append("\n").append(e.getOutput()).append("\n\n");
            }
        }
        b.append(TermColors.RESET).append("\n");
        return b.toString();
    }

    private static String reverseHTML(String input) {
        Matcher functionMatcher;
        input = input.replaceAll("\\<br(.*?)>", "\n").replaceAll("</div>", "\n").replaceAll("\\<.*?>", "").replaceAll("(?s)\\<!--.*?-->", "");
        input = HTMLUtils.unescapeHTML(input);
        input = input.replaceAll("\\{\\{keyword\\|(.*?)\\}\\}", TermColors.BLUE + "$1" + TermColors.RESET);
        input = input.replaceAll("\\{\\{object\\|(.*?)\\}\\}", TermColors.BRIGHT_BLUE + "$1" + TermColors.RESET);
        input = input.replaceAll("\\\\\n", "\n");
        input = input.replaceAll("(?s)\\{\\{Warning\\|text=(.*?)\\}\\}", TermColors.RED + "$1" + TermColors.RESET);
        while ((functionMatcher = Pattern.compile("\\{\\{function\\|(.*?)\\}\\}").matcher(input)).find()) {
            String color2;
            String function = functionMatcher.group(1);
            try {
                FunctionBase f = FunctionList.getFunction(function, Target.UNKNOWN);
                color2 = f instanceof Function ? (((Function)f).isRestricted() ? TermColors.CYAN : TermColors.GREEN) : TermColors.YELLOW;
            }
            catch (ConfigCompileException ex) {
                color2 = TermColors.YELLOW;
            }
            input = input.replaceAll("\\{\\{function\\|" + function + "\\}\\}", color2 + function + TermColors.RESET);
        }
        StringBuilder b = new StringBuilder();
        StringBuilder headerLine = new StringBuilder();
        boolean inTable = false;
        boolean inTableHeader = false;
        boolean inTableHeaderField = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            char c2 = '\u0000';
            char c3 = '\u0000';
            if (i < input.length() - 1) {
                c2 = input.charAt(i + 1);
            }
            if (i < input.length() - 2) {
                c3 = input.charAt(i + 2);
            }
            if (c == '{' && c2 == '|') {
                inTable = true;
                inTableHeader = true;
                b.append("\n");
                ++i;
                continue;
            }
            if (c == '|' && c2 == '}') {
                inTable = false;
                ++i;
                b.append('\n');
                continue;
            }
            if (inTable) {
                if (inTableHeader) {
                    if (c == '|' && c2 == '-') {
                        b.append("\n");
                        ++i;
                        continue;
                    }
                    if (c != '\n') continue;
                    inTableHeader = false;
                    continue;
                }
                if (inTableHeaderField) {
                    if (c == '|') {
                        inTableHeaderField = false;
                        b.append(TermColors.RESET).append("\n|").append(TermColors.MAGENTA);
                    } else if (c == '\n') {
                        b.append(TermColors.RESET).append("| ").append(TermColors.MAGENTA).append(headerLine.toString()).append(TermColors.RESET).append("\n");
                        if (c2 != '!') {
                            inTableHeaderField = false;
                            continue;
                        }
                        headerLine = new StringBuilder();
                        ++i;
                        continue;
                    }
                    headerLine.append(c);
                    continue;
                }
                if (c == '\n' && c2 == '!') {
                    headerLine = new StringBuilder();
                    inTableHeaderField = true;
                    ++i;
                    continue;
                }
                if (c == '\n' && c2 == '|' && c3 == '-' || c == '|' && c2 == '-') {
                    b.append(TermColors.RESET).append("\n").append(StringUtils.stringMultiply(80, "-"));
                    if (c == '\n') {
                        i += 2;
                        continue;
                    }
                    ++i;
                    b.append("\n");
                    continue;
                }
            }
            b.append(c);
        }
        input = b.toString() + "\n";
        return input;
    }

    public void execute(String script, List<String> args) throws ConfigCompileException, IOException, ConfigCompileGroupException {
        this.execute(script, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String script, List<String> args, File fromFile) throws ConfigCompileException, IOException, ConfigCompileGroupException {
        ParseTree tree;
        CmdlineEvents.cmdline_prompt_input.CmdlinePromptInput input = new CmdlineEvents.cmdline_prompt_input.CmdlinePromptInput(script, this.inShellMode);
        EventUtils.TriggerListener(Driver.CMDLINE_PROMPT_INPUT, "cmdline_prompt_input", input);
        if (input.isCancelled()) {
            return;
        }
        this.ctrlCcount = 0;
        if ("exit".equals(script)) {
            if (this.inShellMode) {
                this.inShellMode = false;
                return;
            }
            TermColors.pl(TermColors.YELLOW + "Use exit() if you wish to exit.");
            return;
        }
        if ("help".equals(script)) {
            TermColors.pl(this.getHelpMsg());
            return;
        }
        if (fromFile == null) {
            fromFile = new File("Interpreter");
        }
        boolean localShellMode = false;
        if (!this.inShellMode && script.startsWith("$$")) {
            localShellMode = true;
            script = script.substring(2);
        }
        if (this.inShellMode || localShellMode) {
            if (this.doBuiltin(script)) {
                return;
            }
            List<String> shellArgs = StringUtils.ArgParser(script);
            ArrayList<String> escapedArgs = new ArrayList<String>();
            for (String arg : shellArgs) {
                escapedArgs.add(new CString(arg, Target.UNKNOWN).getQuote());
            }
            script = "shell_adv(array(" + StringUtils.Join(escapedArgs, ",") + "),array('stdout':closure(@l){sys_out(@l);},'stderr':closure(@l){sys_err(@l);}));";
        }
        this.isExecuting = true;
        ProfilePoint compile = this.env.getEnv(GlobalEnv.class).GetProfiler().start("Compilation", LogLevel.VERBOSE);
        try {
            TokenStream stream = MethodScriptCompiler.lex(script, fromFile, true);
            tree = MethodScriptCompiler.compile(stream, this.env);
        }
        finally {
            compile.stop();
        }
        final ArrayList<Variable> vars = new ArrayList<Variable>();
        if (args != null) {
            StringBuilder finalArgument = new StringBuilder();
            CArray arguments = new CArray(Target.UNKNOWN);
            Variable v = new Variable("$0", "", Target.UNKNOWN);
            v.setVal(fromFile.toString());
            v.setDefault(fromFile.toString());
            vars.add(v);
            for (int i = 0; i < args.size(); ++i) {
                String arg = args.get(i);
                if (i > 0) {
                    finalArgument.append(" ");
                }
                Variable v2 = new Variable("$" + Integer.toString(i + 1), "", Target.UNKNOWN);
                v2.setVal(new CString(arg, Target.UNKNOWN));
                v2.setDefault(arg);
                vars.add(v2);
                finalArgument.append(arg);
                arguments.push(new CString(arg, Target.UNKNOWN), Target.UNKNOWN);
            }
            v = new Variable("$", "", false, true, Target.UNKNOWN);
            v.setVal(new CString(finalArgument.toString(), Target.UNKNOWN));
            v.setDefault(finalArgument.toString());
            vars.add(v);
            this.env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, "@arguments", arguments, Target.UNKNOWN, this.env));
        }
        try {
            ProfilePoint p2 = this.env.getEnv(GlobalEnv.class).GetProfiler().start("Interpreter Script", LogLevel.ERROR);
            try {
                MutableObject wasThrown = new MutableObject();
                this.scriptThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block10: {
                            try {
                                MethodScriptCompiler.execute(tree, Interpreter.this.env, new MethodScriptComplete(){

                                    @Override
                                    public void done(String output) {
                                        if (System.console() != null && !"".equals(output.trim())) {
                                            StreamUtils.GetSystemOut().println(output);
                                        }
                                    }
                                }, null, vars);
                                Interpreter.this.env.getEnv(GlobalEnv.class).GetDaemonManager().waitForThreads();
                            }
                            catch (CancelCommandException | InterruptedException e) {
                                for (Thread t : Interpreter.this.env.getEnv(GlobalEnv.class).GetDaemonManager().getActiveThreads()) {
                                    t.interrupt();
                                }
                            }
                            catch (ConfigRuntimeException e) {
                                ConfigRuntimeException.HandleUncaughtException(e, Interpreter.this.env);
                                if (System.console() == null) {
                                    System.exit(1);
                                }
                            }
                            catch (NoClassDefFoundError e) {
                                StreamUtils.GetSystemErr().println(TermColors.RED + Static.getNoClassDefFoundErrorMessage(e) + TermColors.reset());
                                StreamUtils.GetSystemErr().println("Since you're running from standalone interpreter mode, this is not a fatal error, but one of the functions you just used required an actual backing engine that isn't currently loaded. (It still might fail even if you load the engine though.) You simply won't be able to use that function here.");
                                if (System.console() == null) {
                                    System.exit(1);
                                }
                            }
                            catch (InvalidEnvironmentException ex) {
                                StreamUtils.GetSystemErr().println(TermColors.RED + ex.getMessage() + " " + ex.getData() + "() cannot be used in this context.");
                                if (System.console() == null) {
                                    System.exit(1);
                                }
                            }
                            catch (RuntimeException e) {
                                TermColors.pl(TermColors.RED + e.toString());
                                e.printStackTrace(StreamUtils.GetSystemErr());
                                if (System.console() != null) break block10;
                                System.exit(1);
                            }
                        }
                    }
                }, "MethodScript-Main");
                this.scriptThread.start();
                try {
                    this.scriptThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                p2.stop();
            }
        }
        finally {
            this.env.getEnv(GlobalEnv.class).SetInterrupt(false);
            this.isExecuting = false;
        }
    }

    public void execute(File script, List<String> args) throws ConfigCompileException, IOException, ConfigCompileGroupException {
        String scriptString = FileUtil.read(script);
        this.execute(scriptString, args, script);
    }

    public boolean doBuiltin(String script) {
        List<String> args = StringUtils.ArgParser(script);
        if (args.size() > 0) {
            String command = args.get(0);
            args.remove(0);
            switch (command = command.toLowerCase(Locale.ENGLISH)) {
                case "help": {
                    TermColors.pl(this.getHelpMsg());
                    TermColors.pl("Shell builtins:");
                    TermColors.pl("cd <dir> - Runs cd() with the provided argument.");
                    TermColors.pl("s - equivalent to cd('..').");
                    TermColors.pl("echo - Prints the arguments. If -e is set as the first argument, arguments are sent to colorize() first.");
                    TermColors.pl("exit - Exits shellMode, and returns back to normal mscript mode.");
                    TermColors.pl("logout - Exits the shell entirely with a return code of 0.");
                    TermColors.pl("pwd - Runs pwd()");
                    TermColors.pl("help - Prints this message.");
                    return true;
                }
                case "cd": 
                case "s": {
                    if ("s".equals(command)) {
                        args.add("..");
                    }
                    if (args.size() > 1) {
                        TermColors.pl(TermColors.RED + "Too many arguments passed to cd");
                        return true;
                    }
                    Mixed[] a = new Construct[]{};
                    if (args.size() == 1) {
                        a = new Construct[]{new CString(args.get(0), Target.UNKNOWN)};
                    }
                    try {
                        new Cmdline.cd().exec(Target.UNKNOWN, this.env, a);
                    }
                    catch (CREIOException ex) {
                        TermColors.pl(TermColors.RED + ex.getMessage());
                    }
                    return true;
                }
                case "pwd": {
                    TermColors.pl(new Cmdline.pwd().exec(Target.UNKNOWN, this.env, new Mixed[0]).val());
                    return true;
                }
                case "exit": {
                    throw new Error("I should not run");
                }
                case "logout": {
                    new Cmdline.exit().exec(Target.UNKNOWN, this.env, new CInt(0L, Target.UNKNOWN));
                    return true;
                }
                case "echo": {
                    boolean colorize2 = false;
                    if (args.size() > 0 && "-e".equals(args.get(0))) {
                        colorize2 = true;
                        args.remove(0);
                    }
                    String output = StringUtils.Join(args, " ");
                    if (colorize2) {
                        output = new Echoes.colorize().exec(Target.UNKNOWN, this.env, new CString(output, Target.UNKNOWN)).val();
                    }
                    TermColors.pl(output);
                    return true;
                }
            }
        }
        return false;
    }

    public static void install(String commandName) {
        if (null == OSUtils.GetOS()) {
            StreamUtils.GetSystemErr().println("Cmdline MethodScript is only supported on Unix and Windows");
            return;
        }
        switch (OSUtils.GetOS()) {
            case LINUX: 
            case MAC: {
                try {
                    URL jar = Interpreter.class.getProtectionDomain().getCodeSource().getLocation();
                    File exe = new File(INTERPRETER_INSTALLATION_LOCATION + commandName);
                    String bashScript = Static.GetStringResource("/interpreter-helpers/bash.sh");
                    try {
                        bashScript = bashScript.replaceAll("%%LOCATION%%", jar.toURI().getPath());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    exe.createNewFile();
                    if (!exe.canWrite()) {
                        throw new IOException();
                    }
                    FileUtil.write(bashScript, exe);
                    exe.setExecutable(true, false);
                    File manDir = new File("/usr/local/man/man1");
                    if (!manDir.exists()) break;
                    String manPage = Static.GetStringResource("/interpreter-helpers/manpage");
                    try {
                        manPage = DocGenTemplates.DoTemplateReplacement(manPage, DocGenTemplates.GetGenerators());
                        File manPageFile = new File(manDir, commandName + ".1");
                        FileUtil.write(manPage, manPageFile);
                    }
                    catch (DocGenTemplates.Generator.GenerateException ex) {
                        Logger.getLogger(Interpreter.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                catch (IOException e) {
                    StreamUtils.GetSystemErr().println("Cannot install. You must run the command with sudo for it to succeed, however, did you do that?");
                    return;
                }
            }
            case WINDOWS: {
                Path tmp = null;
                try {
                    File root = new File(Interpreter.class.getResource("/interpreter-helpers/csharp").toExternalForm());
                    ZipReader zReader = new ZipReader(root);
                    tmp = Files.createTempDirectory("methodscript-installer", new FileAttribute[0]);
                    zReader.recursiveCopy(tmp.toFile(), false);
                    String me = ClassDiscovery.GetClassContainer(Interpreter.class).toExternalForm().substring(6);
                    String keyName = "Software\\MethodScript";
                    WinRegistry.createKey(-2147483647, keyName);
                    WinRegistry.writeStringValue(-2147483647, keyName, "JarLocation", me);
                    File setup = new File(tmp.toFile(), "setup.exe");
                    int setupResult = new CommandExecutor(new String[]{setup.getAbsolutePath()}).start().waitFor();
                    if (setupResult != 0) {
                        StreamUtils.GetSystemErr().println("Setup failed to complete successfully (exit code " + setupResult + ")");
                        System.exit(setupResult);
                        break;
                    }
                    StreamUtils.GetSystemOut().println("Setup has begun. Finish the installation in the GUI.");
                    break;
                }
                catch (IOException | IllegalAccessException | InterruptedException | InvocationTargetException ex) {
                    ex.printStackTrace(StreamUtils.GetSystemErr());
                    System.exit(1);
                }
            }
        }
        StreamUtils.GetSystemOut().println("MethodScript has successfully been installed on your system. Note that you may need to rerun the install command if you change locations of the jar, or rename it. Be sure to put \"#!/usr/local/bin/" + commandName + "\" at the top of all your scripts, if you wish them to be executable on unix systems, and set the execution bit with chmod +x <script name> on unix systems. (Or use the '" + commandName + " -- new' cmdline utility.)");
        StreamUtils.GetSystemOut().println("Try this script to test out the basic features of the scripting system:\n");
        StreamUtils.GetSystemOut().println(Static.GetStringResource("/interpreter-helpers/sample.ms"));
    }

    public static void uninstall() {
        if (null == OSUtils.GetOS()) {
            StreamUtils.GetSystemErr().println("Sorry, cmdline functionality is currently only supported on unix systems! Check back soon though!");
            return;
        }
        switch (OSUtils.GetOS()) {
            case LINUX: 
            case MAC: {
                try {
                    File exe = new File(INTERPRETER_INSTALLATION_LOCATION);
                    if (!exe.delete()) {
                        throw new IOException();
                    }
                    break;
                }
                catch (IOException e) {
                    StreamUtils.GetSystemErr().println("Cannot uninstall. You must run the command with sudo for it to succeed, however, did you do that?");
                    return;
                }
            }
            case WINDOWS: {
                StreamUtils.GetSystemOut().println("To uninstall on windows, please uninstall from the Add or Remove Programs application.");
                return;
            }
            default: {
                StreamUtils.GetSystemErr().println("Sorry, cmdline functionality is currently only supported on unix systems! Check back soon though!");
                return;
            }
        }
        StreamUtils.GetSystemOut().println("MethodScript has been uninstalled from this system.");
    }

    @convert(type=Implementation.Type.SHELL)
    public static class ShellConvertor
    extends AbstractConvertor {
        RunnableQueue queue = new RunnableQueue("ShellInterpreter-userland");

        @Override
        public MCLocation GetLocation(MCWorld w, double x, double y, double z, float yaw, float pitch) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public Class GetServerEventMixin() {
            return ShellEventMixin.class;
        }

        @Override
        public MCEnchantment[] GetEnchantmentValues() {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCEnchantment GetEnchantmentByName(String name) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCServer GetServer() {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCItemStack GetItemStack(MCMaterial type, int qty) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCItemStack GetItemStack(String type, int qty) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCPotionData GetPotionData(MCPotionType type, boolean extended, boolean upgraded) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public void Startup(CommandHelperPlugin chp) {
        }

        @Override
        public MCEntity GetCorrectEntity(MCEntity e) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCInventory GetEntityInventory(MCEntity entity) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCInventory GetLocationInventory(MCLocation location) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCInventoryHolder CreateInventoryHolder(String id) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCNote GetNote(int octave, MCTone tone, boolean sharp) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCColor GetColor(int red, int green, int blue) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCColor GetColor(String colorName, Target t) throws CREFormatException {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCPattern GetPattern(MCDyeColor color2, MCPatternShape shape) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCFireworkBuilder GetFireworkBuilder() {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCPluginMeta GetPluginMeta() {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCMaterial GetMaterialFromLegacy(String name, int data) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCMaterial GetMaterialFromLegacy(int id, int data) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCItemMeta GetCorrectMeta(MCItemMeta im) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public List<MCEntity> GetEntitiesAt(MCLocation loc, double radius) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCRecipe GetNewRecipe(String key, MCRecipeType type, MCItemStack result) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCRecipe GetRecipe(MCRecipe unspecific) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCMaterial GetMaterial(String name) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public MCMetadataValue GetMetadataValue(Object value, MCPlugin plugin) {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public String GetPluginName() {
            return "MethodScript";
        }

        @Override
        public MCPlugin GetPlugin() {
            throw new UnsupportedOperationException("This method is not supported from a shell.");
        }

        @Override
        public String GetUser(Environment env) {
            return System.getProperty("user.name");
        }
    }
}

