/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ModifierMirror;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract class AbstractElementMirror
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected final ModifierMirror modifiers;
    protected final String name;
    protected final ClassReferenceMirror type;
    protected List<AnnotationMirror> annotations;
    private final ClassReferenceMirror parent;

    protected AbstractElementMirror(Field field) {
        Objects.requireNonNull(field);
        this.type = ClassReferenceMirror.fromClass(field.getType());
        this.modifiers = new ModifierMirror(field.getModifiers());
        this.name = field.getName();
        ArrayList<AnnotationMirror> list = new ArrayList<AnnotationMirror>();
        for (Annotation a : field.getDeclaredAnnotations()) {
            list.add(new AnnotationMirror(a));
        }
        this.annotations = list;
        this.parent = ClassReferenceMirror.fromClass(field.getDeclaringClass());
        Objects.requireNonNull(this.parent);
    }

    protected AbstractElementMirror(Member method) {
        Objects.requireNonNull(method);
        this.type = method instanceof Method ? ClassReferenceMirror.fromClass(((Method)method).getReturnType()) : ClassReferenceMirror.fromClass(((Constructor)method).getDeclaringClass());
        this.modifiers = new ModifierMirror(method.getModifiers());
        this.name = method.getName();
        ArrayList<AnnotationMirror> list = new ArrayList<AnnotationMirror>();
        if (method instanceof Method) {
            for (Annotation a : ((Method)method).getDeclaredAnnotations()) {
                list.add(new AnnotationMirror(a));
            }
        } else if (method instanceof Constructor) {
            for (Annotation a : ((Constructor)method).getDeclaredAnnotations()) {
                list.add(new AnnotationMirror(a));
            }
        } else {
            throw new Error("Unexpected method type");
        }
        this.annotations = list;
        this.parent = ClassReferenceMirror.fromClass(method.getDeclaringClass());
        Objects.requireNonNull(this.parent);
    }

    protected AbstractElementMirror(ClassReferenceMirror parent, List<AnnotationMirror> annotations, ModifierMirror modifiers, ClassReferenceMirror type, String name) {
        this.annotations = annotations;
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationMirror>();
        }
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.parent = parent;
        Objects.requireNonNull(parent);
        Objects.requireNonNull(modifiers);
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
    }

    public ModifierMirror getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public ClassReferenceMirror getType() {
        return this.type;
    }

    public List<AnnotationMirror> getAnnotations() {
        return new ArrayList<AnnotationMirror>(this.annotations);
    }

    public AnnotationMirror getAnnotation(Class<? extends Annotation> annotation) {
        String jvmName = ClassUtils.getJVMName(annotation);
        for (AnnotationMirror a : this.getAnnotations()) {
            if (!a.getType().getJVMName().equals(jvmName)) continue;
            return a;
        }
        return null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.getAnnotation(annotation) != null;
    }

    public <T extends Annotation> T loadAnnotation(Class<T> type) {
        AnnotationMirror mirror = this.getAnnotation(type);
        if (mirror == null) {
            return null;
        }
        return mirror.getProxy(type);
    }

    public final ClassReferenceMirror getDeclaringClass() {
        return this.parent;
    }

    void addAnnotation(AnnotationMirror annotation) {
        this.annotations.add(annotation);
    }

    public int hashCode() {
        int hash2 = 5;
        hash2 = 89 * hash2 + Objects.hashCode(this.name);
        hash2 = 89 * hash2 + Objects.hashCode(this.parent);
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractElementMirror other = (AbstractElementMirror)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.parent, other.parent);
    }

    public Class loadParentClass() throws ClassNotFoundException {
        return this.loadParentClass(AbstractElementMirror.class.getClassLoader(), true);
    }

    public Class loadParentClass(ClassLoader loader, boolean initialize) throws ClassNotFoundException {
        ClassReferenceMirror p2 = this.getDeclaringClass();
        Objects.requireNonNull(p2, "Declaring class is null!");
        return p2.loadClass(loader, initialize);
    }
}

