/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Web;

import com.laytonsmith.PureUtilities.Web.HTTPHeader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HTTPResponse {
    private String rawResponse = null;
    private final List<HTTPHeader> headers = new LinkedList<HTTPHeader>();
    private final String responseText;
    private final int responseCode;
    private final byte[] content;
    private final String httpVersion;

    public HTTPResponse(String responseText, int responseCode, Map<String, List<String>> headers, byte[] response, String httpVersion) {
        this.responseText = responseText;
        this.responseCode = responseCode;
        for (String key : headers.keySet()) {
            for (String value : headers.get(key)) {
                this.headers.add(new HTTPHeader(key, value));
            }
        }
        this.content = response;
        this.httpVersion = httpVersion;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentAsString() {
        try {
            return this.getContentAsString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public String getContentAsString(String encoding) throws UnsupportedEncodingException {
        return new String(this.getContent(), encoding);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getFirstHeader(String key) {
        for (HTTPHeader header : this.headers) {
            if (!header.getHeader().equalsIgnoreCase(key)) continue;
            return header.getValue();
        }
        return null;
    }

    public Set<String> getHeaderNames() {
        HashSet<String> set = new HashSet<String>();
        for (HTTPHeader h : this.headers) {
            if (h.getHeader() == null) continue;
            set.add(h.getHeader());
        }
        return set;
    }

    public List<String> getHeaders(String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (HTTPHeader header : this.headers) {
            if ((header.getHeader() != null || key != null) && (header.getHeader() == null || !header.getHeader().equalsIgnoreCase(key))) continue;
            list.add(header.getValue());
        }
        return list;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public String toString() {
        if (this.rawResponse == null) {
            this.rawResponse = "HTTP/" + this.httpVersion + " " + this.responseCode + " " + this.responseText + "\n";
            for (HTTPHeader h : this.headers) {
                if (h.getHeader() == null) continue;
                this.rawResponse = this.rawResponse + h.getHeader() + ": " + h.getValue() + "\n";
            }
            this.rawResponse = this.rawResponse + "\n<bytes of length " + this.content.length + ">";
        }
        return this.rawResponse;
    }
}

