/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction;

import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCEntityEquipment;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCProjectileSource;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.enums.MCPotionEffectType;
import com.laytonsmith.core.constructs.Target;
import java.util.HashSet;
import java.util.List;

public interface MCLivingEntity
extends MCEntity,
MCProjectileSource {
    public boolean addEffect(MCPotionEffectType var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    public boolean removeEffect(MCPotionEffectType var1);

    public void removeEffects();

    public List<MCEffect> getEffects();

    public void damage(double var1);

    public void damage(double var1, MCEntity var3);

    public boolean getCanPickupItems();

    public boolean getRemoveWhenFarAway();

    public MCEntityEquipment getEquipment();

    public double getEyeHeight();

    public double getEyeHeight(boolean var1);

    public MCLocation getEyeLocation();

    public double getHealth();

    public MCPlayer getKiller();

    public double getLastDamage();

    public MCEntity getLeashHolder();

    public MCLivingEntity getTarget(Target var1);

    public MCBlock getTargetBlock(HashSet<MCMaterial> var1, int var2);

    public MCBlock getTargetSpace(int var1);

    public List<MCBlock> getLineOfSight(HashSet<MCMaterial> var1, int var2);

    public boolean hasLineOfSight(MCEntity var1);

    public double getMaxHealth();

    public int getMaximumAir();

    public int getMaximumNoDamageTicks();

    public int getNoDamageTicks();

    public int getRemainingAir();

    public boolean isGliding();

    public boolean isLeashed();

    public boolean hasAI();

    public void resetMaxHealth();

    public void setCanPickupItems(boolean var1);

    public void setRemoveWhenFarAway(boolean var1);

    public void setHealth(double var1);

    public void setLastDamage(double var1);

    public void setLeashHolder(MCEntity var1);

    public void setMaxHealth(double var1);

    public void setMaximumAir(int var1);

    public void setMaximumNoDamageTicks(int var1);

    public void setNoDamageTicks(int var1);

    public void setRemainingAir(int var1);

    public void setTarget(MCLivingEntity var1, Target var2);

    public void setGliding(Boolean var1);

    public void setAI(Boolean var1);

    public boolean isCollidable();

    public void setCollidable(boolean var1);

    public void kill();

    public boolean isTameable();

    public static class MCEffect {
        private MCPotionEffectType type;
        private int strength;
        private int ticksRemaining;
        private boolean ambient;
        private boolean particles;
        private boolean icon;

        public MCEffect(MCPotionEffectType type, int strength, int ticks, boolean ambient) {
            this(type, strength, ticks, ambient, true, true);
        }

        public MCEffect(MCPotionEffectType type, int strength, int ticks, boolean ambient, boolean particles) {
            this(type, strength, ticks, ambient, particles, particles);
        }

        public MCEffect(MCPotionEffectType type, int strength, int ticks, boolean ambient, boolean particles, boolean icon) {
            this.type = type;
            this.strength = strength;
            this.ticksRemaining = ticks;
            this.ambient = ambient;
            this.particles = particles;
            this.icon = icon;
        }

        public MCPotionEffectType getPotionEffectType() {
            return this.type;
        }

        public int getStrength() {
            return this.strength;
        }

        public int getTicksRemaining() {
            return this.ticksRemaining;
        }

        public boolean isAmbient() {
            return this.ambient;
        }

        public boolean hasParticles() {
            return this.particles;
        }

        public boolean showIcon() {
            return this.icon;
        }
    }
}

