/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCNote;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockFace;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCNote;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockState;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.enums.MCIgniteCause;
import com.laytonsmith.abstraction.enums.MCInstrument;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCBlockFace;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCIgniteCause;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCInstrument;
import com.laytonsmith.abstraction.events.MCBlockBreakEvent;
import com.laytonsmith.abstraction.events.MCBlockBurnEvent;
import com.laytonsmith.abstraction.events.MCBlockDispenseEvent;
import com.laytonsmith.abstraction.events.MCBlockEvent;
import com.laytonsmith.abstraction.events.MCBlockFadeEvent;
import com.laytonsmith.abstraction.events.MCBlockFromToEvent;
import com.laytonsmith.abstraction.events.MCBlockGrowEvent;
import com.laytonsmith.abstraction.events.MCBlockIgniteEvent;
import com.laytonsmith.abstraction.events.MCBlockPistonEvent;
import com.laytonsmith.abstraction.events.MCBlockPistonExtendEvent;
import com.laytonsmith.abstraction.events.MCBlockPistonRetractEvent;
import com.laytonsmith.abstraction.events.MCBlockPlaceEvent;
import com.laytonsmith.abstraction.events.MCNotePlayEvent;
import com.laytonsmith.abstraction.events.MCSignChangeEvent;
import com.laytonsmith.annotations.abstraction;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.util.Vector;

public class BukkitBlockEvents {

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockFadeEvent
    implements MCBlockFadeEvent {
        BlockFadeEvent bfe;

        public BukkitMCBlockFadeEvent(BlockFadeEvent bfe) {
            this.bfe = bfe;
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.bfe.getBlock());
        }

        @Override
        public MCBlockState getNewState() {
            return new BukkitMCBlockState(this.bfe.getNewState());
        }

        @Override
        public Object _GetObject() {
            return this.bfe;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCNotePlayEvent
    implements MCNotePlayEvent {
        NotePlayEvent npe;

        public BukkitMCNotePlayEvent(NotePlayEvent event) {
            this.npe = event;
        }

        @Override
        public Object _GetObject() {
            return this.npe;
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.npe.getBlock());
        }

        @Override
        public MCNote getNote() {
            return new BukkitMCNote(this.npe.getNote());
        }

        @Override
        public MCInstrument getInstrument() {
            return (MCInstrument)((Object)BukkitMCInstrument.getConvertor().getAbstractedEnum(this.npe.getInstrument()));
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockGrowEvent
    implements MCBlockGrowEvent {
        BlockGrowEvent bge;

        public BukkitMCBlockGrowEvent(BlockGrowEvent event) {
            this.bge = event;
        }

        @Override
        public Object _GetObject() {
            return this.bge;
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.bge.getBlock());
        }

        @Override
        public MCBlockState getNewState() {
            return new BukkitMCBlockState(this.bge.getNewState());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockDispenseEvent
    extends BukkitMCBlockEvent
    implements MCBlockDispenseEvent {
        BlockDispenseEvent bde;

        public BukkitMCBlockDispenseEvent(BlockDispenseEvent e) {
            super((BlockEvent)e);
            this.bde = e;
        }

        @Override
        public MCItemStack getItem() {
            return new BukkitMCItemStack(this.bde.getItem());
        }

        @Override
        public void setItem(MCItemStack item) {
            if (item == null || "AIR".equals(item.getType().getName())) {
                throw new CREIllegalArgumentException("Due to Bukkit's handling of this event, the item cannot be set to null. Until they change this, workaround by cancelling the event and manipulating the block using inventory functions.", Target.UNKNOWN);
            }
            this.bde.setItem(((BukkitMCItemStack)item).asItemStack());
        }

        @Override
        public Vector3D getVelocity() {
            Vector v = this.bde.getVelocity();
            return new Vector3D(v.getX(), v.getY(), v.getZ());
        }

        @Override
        public void setVelocity(Vector3D vel) {
            Vector v = new Vector(vel.X(), vel.Y(), vel.Z());
            this.bde.setVelocity(v);
        }

        @Override
        public boolean isCancelled() {
            return this.bde.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancel2) {
            this.bde.setCancelled(cancel2);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockEvent
    implements MCBlockEvent {
        BlockEvent be;

        public BukkitMCBlockEvent(BlockEvent e) {
            this.be = e;
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.be.getBlock());
        }

        @Override
        public Object _GetObject() {
            return this.be;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCSignChangeEvent
    implements MCSignChangeEvent {
        SignChangeEvent pie;

        public BukkitMCSignChangeEvent(SignChangeEvent e) {
            this.pie = e;
        }

        public static BukkitMCSignChangeEvent _instantiate(MCBlock sign, MCPlayer player2, CArray signtext) {
            String[] text = new String[4];
            int i = 0;
            while ((long)i < signtext.size()) {
                text[i] = signtext.get(i, Target.UNKNOWN).toString();
                ++i;
            }
            return new BukkitMCSignChangeEvent(new SignChangeEvent(((BukkitMCBlock)sign).__Block(), ((BukkitMCPlayer)player2)._Player(), text));
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.pie.getPlayer());
        }

        @Override
        public CString getLine(int index) {
            return new CString(this.pie.getLine(index), Target.UNKNOWN);
        }

        @Override
        public CArray getLines() {
            CArray retn = new CArray(Target.UNKNOWN);
            for (int i = 0; i < 4; ++i) {
                retn.push(new CString(this.pie.getLine(i), Target.UNKNOWN), Target.UNKNOWN);
            }
            return retn;
        }

        @Override
        public void setLine(int index, String text) {
            this.pie.setLine(index, text);
        }

        @Override
        public void setLines(String[] text) {
            for (int i = 0; i < 4; ++i) {
                this.pie.setLine(i, text[i]);
            }
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.pie.getBlock());
        }

        @Override
        public Object _GetObject() {
            return this.pie;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockFromToEvent
    implements MCBlockFromToEvent {
        BlockFromToEvent event;

        public BukkitMCBlockFromToEvent(BlockFromToEvent e) {
            this.event = e;
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.event.getBlock());
        }

        @Override
        public MCBlock getToBlock() {
            return new BukkitMCBlock(this.event.getToBlock());
        }

        @Override
        public MCBlockFace getBlockFace() {
            return (MCBlockFace)((Object)BukkitMCBlockFace.getConvertor().getAbstractedEnum(this.event.getFace()));
        }

        @Override
        public boolean isCancelled() {
            return this.event.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.event.setCancelled(cancelled);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockIgniteEvent
    extends BukkitMCBlockEvent
    implements MCBlockIgniteEvent {
        BlockIgniteEvent event;

        public BukkitMCBlockIgniteEvent(BlockIgniteEvent e) {
            super((BlockEvent)e);
            this.event = e;
        }

        @Override
        public MCIgniteCause getCause() {
            return (MCIgniteCause)((Object)BukkitMCIgniteCause.getConvertor().getAbstractedEnum(this.event.getCause()));
        }

        @Override
        public MCEntity getIgnitingEntity() {
            if (this.event.getIgnitingEntity() != null) {
                return new BukkitMCEntity(this.event.getIgnitingEntity());
            }
            return null;
        }

        @Override
        public MCBlock getIgnitingBlock() {
            if (this.event.getIgnitingBlock() != null) {
                return new BukkitMCBlock(this.event.getIgnitingBlock());
            }
            return null;
        }

        @Override
        public MCPlayer getPlayer() {
            if (this.event.getPlayer() != null) {
                return new BukkitMCPlayer((Entity)this.event.getPlayer());
            }
            return null;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockBurnEvent
    implements MCBlockBurnEvent {
        BlockBurnEvent event;

        public BukkitMCBlockBurnEvent(BlockBurnEvent e) {
            this.event = e;
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.event.getBlock());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockPlaceEvent
    implements MCBlockPlaceEvent {
        BlockPlaceEvent event;

        public BukkitMCBlockPlaceEvent(BlockPlaceEvent e) {
            this.event = e;
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.event.getPlayer());
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.event.getBlock());
        }

        @Override
        public MCBlock getBlockAgainst() {
            return new BukkitMCBlock(this.event.getBlockAgainst());
        }

        @Override
        public MCItemStack getItemInHand() {
            return new BukkitMCItemStack(this.event.getItemInHand());
        }

        @Override
        public boolean canBuild() {
            return this.event.canBuild();
        }

        @Override
        public MCBlockState getBlockReplacedState() {
            return new BukkitMCBlockState(this.event.getBlockReplacedState());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockBreakEvent
    implements MCBlockBreakEvent {
        BlockBreakEvent event;
        boolean dropsModified = false;
        List<MCItemStack> drops = null;

        public BukkitMCBlockBreakEvent(BlockBreakEvent e) {
            this.event = e;
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.event.getPlayer());
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.event.getBlock());
        }

        @Override
        public int getExpToDrop() {
            return this.event.getExpToDrop();
        }

        @Override
        public void setExpToDrop(int exp) {
            this.event.setExpToDrop(exp);
        }

        @Override
        public List<MCItemStack> getDrops() {
            return this.drops;
        }

        @Override
        public void setDrops(List<MCItemStack> drops) {
            this.dropsModified = true;
            this.drops = drops;
        }

        @Override
        public boolean isModified() {
            return this.dropsModified;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockPistonRetractEvent
    extends BukkitMCBlockPistonEvent
    implements MCBlockPistonRetractEvent {
        BlockPistonRetractEvent event;

        public BukkitMCBlockPistonRetractEvent(BlockPistonRetractEvent e) {
            super((BlockPistonEvent)e);
            this.event = e;
        }

        @Override
        public MCLocation getRetractedLocation() {
            return new BukkitMCLocation(this.event.getRetractLocation());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBlockPistonExtendEvent
    extends BukkitMCBlockPistonEvent
    implements MCBlockPistonExtendEvent {
        BlockPistonExtendEvent event;

        public BukkitMCBlockPistonExtendEvent(BlockPistonExtendEvent e) {
            super((BlockPistonEvent)e);
            this.event = e;
        }

        @Override
        public List<MCBlock> getPushedBlocks() {
            ArrayList<MCBlock> blocks = new ArrayList<MCBlock>();
            for (Block b : this.event.getBlocks()) {
                blocks.add(new BukkitMCBlock(b));
            }
            return blocks;
        }
    }

    public static class BukkitMCBlockPistonEvent
    implements MCBlockPistonEvent {
        BlockPistonEvent event;

        public BukkitMCBlockPistonEvent(BlockPistonEvent e) {
            this.event = e;
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }

        @Override
        public MCBlockFace getDirection() {
            return (MCBlockFace)((Object)BukkitMCBlockFace.getConvertor().getAbstractedEnum(this.event.getDirection()));
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.event.getBlock());
        }

        @Override
        public boolean isSticky() {
            return this.event.isSticky();
        }

        @Override
        public boolean isCancelled() {
            return this.event.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.event.setCancelled(cancelled);
        }
    }
}

