/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Particle;

public class BukkitMCParticle
extends MCParticle<Particle> {
    private static final Map<Particle, MCParticle> BUKKIT_MAP = new HashMap<Particle, MCParticle>();

    public BukkitMCParticle(MCParticle.MCVanillaParticle vanillaParticle, Particle particle) {
        super(vanillaParticle, particle);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCParticle.MCVanillaParticle.UNKNOWN ? this.concreteName() : ((MCParticle.MCVanillaParticle)((Object)this.getAbstracted())).name();
    }

    @Override
    public String concreteName() {
        Particle b = (Particle)this.getConcrete();
        if (b == null) {
            return "null";
        }
        return b.name();
    }

    public static MCParticle valueOfConcrete(Particle test) {
        MCParticle type = BUKKIT_MAP.get(test);
        if (type == null) {
            return NULL;
        }
        return type;
    }

    public static void build() {
        NULL = new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, null);
        for (MCParticle.MCVanillaParticle mCVanillaParticle : MCParticle.MCVanillaParticle.values()) {
            Particle type;
            if (!mCVanillaParticle.existsInCurrent()) continue;
            try {
                type = BukkitMCParticle.getBukkitType(mCVanillaParticle);
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit Particle for " + mCVanillaParticle.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCParticle wrapper = new BukkitMCParticle(mCVanillaParticle, type);
            BUKKIT_MAP.put(type, wrapper);
            MAP.put(mCVanillaParticle.name(), wrapper);
        }
        for (MCParticle.MCVanillaParticle mCVanillaParticle : Particle.values()) {
            if (BUKKIT_MAP.containsKey((Object)mCVanillaParticle)) continue;
            MAP.put(mCVanillaParticle.name(), new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, (Particle)mCVanillaParticle));
            BUKKIT_MAP.put((Particle)mCVanillaParticle, new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, (Particle)mCVanillaParticle));
        }
    }

    private static Particle getBukkitType(MCParticle.MCVanillaParticle v) {
        return Particle.valueOf((String)v.name());
    }
}

