/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.annotations;

import com.laytonsmith.core.PlatformResolver;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.bash.BashPlatformResolver;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface api {
    public Platforms[] platform() default {Platforms.INTERPRETER_JAVA};

    public Class<? extends Environment.EnvironmentImpl>[] environments() default {};

    public boolean enabled() default true;

    public static enum ValidClasses {
        FUNCTION(FunctionBase.class),
        EVENT(Event.class);

        private static List<Class> classes;
        Class classType;

        private ValidClasses(Class c) {
            this.classType = c;
        }

        public static List<Class> Classes() {
            if (classes == null) {
                Class[] cc = new Class[ValidClasses.values().length];
                for (int i = 0; i < ValidClasses.values().length; ++i) {
                    cc[i] = ValidClasses.values()[i].classType;
                }
                classes = Arrays.asList(cc);
            }
            return new ArrayList<Class>(classes);
        }

        public static boolean IsValid(Class c) {
            for (Class cc : ValidClasses.Classes()) {
                if (!cc.isAssignableFrom(c)) continue;
                return true;
            }
            return false;
        }

        static {
            classes = null;
        }
    }

    public static enum Platforms {
        INTERPRETER_JAVA(null, "Java Interpreter"),
        COMPILER_BASH(new BashPlatformResolver(), "Bash Compiler");

        private final PlatformResolver resolver;
        private final String platformName;

        public PlatformResolver getResolver() {
            return this.resolver;
        }

        public String platformName() {
            return this.platformName;
        }

        private Platforms(PlatformResolver resolver, String platformName) {
            this.resolver = resolver;
            this.platformName = platformName;
        }
    }
}

