/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.UnqualifiedClassName;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.ObjectDefinitionNotFoundException;
import com.laytonsmith.core.objects.ObjectDefinitionTable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;

public final class FullyQualifiedClassName
implements Comparable<FullyQualifiedClassName> {
    public static final String PATH_SEPARATOR = ".";
    private final String fullyQualifiedName;
    private Class<? extends Mixed> nativeClass;

    private FullyQualifiedClassName(String name) {
        Objects.requireNonNull(name, "The name passed in may not be null");
        this.fullyQualifiedName = name;
    }

    public static FullyQualifiedClassName forName(String unqualified, Target t, Environment env) throws CRECastException {
        ObjectDefinitionTable odt = env.getEnv(CompilerEnvironment.class).getObjectDefinitionTable();
        try {
            FullyQualifiedClassName fqcn = new FullyQualifiedClassName(unqualified);
            odt.get(fqcn);
            return fqcn;
        }
        catch (ObjectDefinitionNotFoundException objectDefinitionNotFoundException) {
            return FullyQualifiedClassName.forDefaultClasses(unqualified, t);
        }
    }

    public static FullyQualifiedClassName forNativeEnum(Class<? extends Enum> clazz) {
        MEnum m = clazz.getAnnotation(MEnum.class);
        if (m == null) {
            throw new Error("Native enum " + clazz + " does not provide an MEnum annotation");
        }
        String fqcn = m.value();
        FullyQualifiedClassName f = new FullyQualifiedClassName(fqcn);
        try {
            f.nativeClass = NativeTypeList.getNativeEnumType(f).typeof().getNativeType();
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
        return f;
    }

    public static FullyQualifiedClassName forNativeClass(Class<? extends Mixed> clazz) {
        typeof t = clazz.getAnnotation(typeof.class);
        if (t == null) {
            throw new Error("Native class " + clazz + " does not provide a typeof annotation");
        }
        String fqcn = t.value();
        FullyQualifiedClassName f = new FullyQualifiedClassName(fqcn);
        f.nativeClass = clazz;
        return f;
    }

    private static FullyQualifiedClassName forDefaultClasses(String unqualified, Target t) throws CRECastException {
        String fqcn = NativeTypeList.resolveNativeType(unqualified);
        if (fqcn == null) {
            throw new CRECastException("Cannot find \"" + unqualified + "\" type", t);
        }
        return new FullyQualifiedClassName(fqcn);
    }

    public static FullyQualifiedClassName forFullyQualifiedClass(String qualified) {
        return new FullyQualifiedClassName(qualified);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FullyQualifiedClassName)) {
            return false;
        }
        return this.fullyQualifiedName.equals(((FullyQualifiedClassName)obj).fullyQualifiedName);
    }

    public int hashCode() {
        return this.fullyQualifiedName.hashCode();
    }

    public String getFQCN() {
        return this.fullyQualifiedName;
    }

    public UnqualifiedClassName asUCN() {
        return new UnqualifiedClassName(this);
    }

    public String toString() {
        return this.fullyQualifiedName;
    }

    @Override
    public int compareTo(FullyQualifiedClassName o) {
        return this.fullyQualifiedName.compareTo(o.fullyQualifiedName);
    }

    public boolean isTypeUnion() {
        return this.fullyQualifiedName.contains("|");
    }

    public Class<? extends Mixed> getNativeClass() {
        return this.nativeClass;
    }

    public String getSimpleName() {
        ArrayList<String> parts = new ArrayList<String>();
        for (String t : this.fullyQualifiedName.split("\\|")) {
            String[] sparts = t.split(Pattern.quote(PATH_SEPARATOR));
            try {
                parts.add(sparts[sparts.length - 1]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ArrayIndexOutOfBoundsException("Could not properly get simple name for " + this.fullyQualifiedName);
            }
        }
        return StringUtils.Join(parts, "|");
    }
}

