/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.Compiler;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.List;

public abstract class Keyword
implements Documentation {
    private static final String __CBRACE__ = new Compiler.__cbrace__().getName();

    protected Keyword() {
    }

    public abstract int process(List<ParseTree> var1, int var2) throws ConfigCompileException;

    public final String getKeywordName() {
        keyword k = this.getClass().getAnnotation(keyword.class);
        return k == null ? null : k.value();
    }

    protected void validateCodeBlock(ParseTree node, String message) throws ConfigCompileException {
        if (node.getChildren().size() > 1) {
            throw new ConfigCompileException("Unexpected number of arguments in code block", node.getTarget());
        }
        if (!Keyword.isCodeBlock(node)) {
            throw new ConfigCompileException(message, node.getTarget());
        }
    }

    protected boolean isValidCodeBlock(ParseTree node) {
        return node.getChildren().size() <= 1 && Keyword.isCodeBlock(node);
    }

    protected static boolean isCodeBlock(ParseTree node) {
        return node.getData() instanceof CFunction && node.getData().val().equals(__CBRACE__);
    }

    protected static ParseTree getArgumentOrNull(ParseTree node) {
        if (node.getChildren().isEmpty()) {
            return new ParseTree(CNull.NULL, node.getFileOptions());
        }
        return node.getChildAt(0);
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        return new Class[0];
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public String getName() {
        return this.getClass().getAnnotation(keyword.class).value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface keyword {
        public String value();
    }
}

