/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.functions.CompiledFunction;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import java.io.File;
import java.util.ArrayList;

public final class MethodScriptStaticCompiler {
    private MethodScriptStaticCompiler() {
    }

    public static String compile(String script, api.Platforms platform, File file) throws ConfigCompileException, ConfigCompileGroupException {
        ParseTree tree = MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, file, true), null);
        StringBuilder b = new StringBuilder();
        for (ParseTree node : tree.getChildren()) {
            MethodScriptStaticCompiler.go(node, b, platform);
        }
        return b.toString();
    }

    private static void go(ParseTree node, StringBuilder b, api.Platforms platform) throws ConfigCompileException {
        if (node.hasChildren()) {
            FunctionBase f = FunctionList.getFunction((CFunction)node.getData(), platform);
            if (!(f instanceof CompiledFunction)) {
                throw new ConfigCompileException("The function " + f.getName() + " is unknown in this platform.", node.getData().getTarget());
            }
            CompiledFunction cf = (CompiledFunction)((Object)f);
            ArrayList<String> children = new ArrayList<String>();
            for (ParseTree baby : node.getChildren()) {
                StringBuilder bb = new StringBuilder();
                MethodScriptStaticCompiler.go(baby, bb, platform);
                children.add(bb.toString());
            }
            b.append(cf.compile(node.getData().getTarget(), children.toArray(new String[children.size()])));
        } else if (platform.getResolver() == null) {
            b.append(node.getData().val());
        } else {
            b.append(platform.getResolver().outputConstant(node.getData()));
        }
    }
}

